/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;

public class LogFormatHelper {
    private static final int ODL_SUBSTRING_LEN = 5;
    private static final String ODL_LINE_BEGIN_REGEX = "\\[(\\d){4}";
    private static final String GZIP_EXTENSION = ".gz";

    public static boolean isUniformFormatLogHeader(String line) {
        return line.startsWith("[#|") && LogFormatHelper.countOccurrences(line, '|') > 4;
    }

    public static boolean isODLFormatLogHeader(String line) {
        return line.length() > 5 && PatternHolder.ODL_PATTERN.matcher(line.substring(0, 5)).matches() && LogFormatHelper.countOccurrences(line, '[') > 4;
    }

    public static boolean isJSONFormatLogHeader(String line) {
        JsonReader reader = Json.createReader((Reader)new StringReader(line));
        try {
            reader.read();
            return true;
        }
        catch (JsonException ex) {
            return false;
        }
    }

    private static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public static boolean isCompressedFile(String filename) {
        return filename.endsWith(GZIP_EXTENSION);
    }

    private static final class PatternHolder {
        private static final Pattern ODL_PATTERN = Pattern.compile("\\[(\\d){4}");

        private PatternHolder() {
        }
    }
}

