/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserFactory;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ODLLogParser
implements LogParser {
    private static final int ODL_FIXED_FIELD_COUNT = 5;
    private static final String ODL_FIELD_REGEX = "(\\[[^\\[\\]]*?\\])+?";
    private static final Map<String, String> ODL_STANDARD_FIELDS = new HashMap<String, String>(){
        private static final long serialVersionUID = -6870456038890663569L;
        {
            this.put("tid", "threadId");
        }
    };
    private String streamName;

    public ODLLogParser(String name) {
        this.streamName = name;
    }

    @Override
    public void parseLog(BufferedReader reader, LogParserListener listener) throws LogParserException {
        try {
            String line = null;
            StringBuilder buffer = new StringBuilder();
            long position = 0L;
            while ((line = reader.readLine()) != null) {
                Matcher m = LogParserFactory.getInstance().getODLDateFormatPattern().matcher(line);
                if (m.matches()) {
                    String logRecord = buffer.toString();
                    this.parseLogRecord(position, logRecord, listener);
                    position += (long)logRecord.length();
                    buffer = new StringBuilder();
                }
                buffer.append(line);
                buffer.append(LogParserFactory.NEWLINE);
            }
            String logRecord = buffer.toString();
            this.parseLogRecord(position, logRecord, listener);
        }
        catch (IOException e) {
            throw new LogParserException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogFacade.LOGGING_LOGGER.log(Level.FINE, "Got exception while clsoing reader " + this.streamName, e);
                }
            }
        }
    }

    private void parseLogRecord(long position, String logRecord, LogParserListener listener) {
        ParsedLogRecord parsedLogRecord = new ParsedLogRecord();
        if (this.initializeUniformFormatLogRecord(parsedLogRecord, logRecord)) {
            listener.foundLogRecord(position, parsedLogRecord);
        }
    }

    private boolean initializeUniformFormatLogRecord(ParsedLogRecord parsedLogRecord, String logRecord) {
        int endIndex;
        parsedLogRecord.setFormattedLogRecord(logRecord);
        Matcher matcher = ODLFieldPatternHolder.ODL_FIELD_PATTERN.matcher(logRecord);
        int start = 0;
        int end = 0;
        int fieldIndex = 0;
        while (matcher.find()) {
            ++fieldIndex;
            start = matcher.start();
            if (end != 0 && start != end + 1) break;
            end = matcher.end();
            String text = matcher.group();
            text = text.substring(1, text.length() - 1);
            if (fieldIndex <= 5) {
                this.populateLogRecordFields(fieldIndex, text, parsedLogRecord);
                continue;
            }
            this.populateLogRecordSuppAttrs(text, parsedLogRecord);
        }
        String msg = logRecord.substring(end);
        msg = msg.trim();
        boolean multiLineBegin = false;
        if (msg.startsWith("[[")) {
            msg = msg.replaceFirst("\\[\\[", "").trim();
            multiLineBegin = true;
            multiLineBegin = true;
        }
        if (multiLineBegin && msg.endsWith("]]") && (endIndex = msg.length() - 2) > 0) {
            msg = msg.substring(0, endIndex);
        }
        parsedLogRecord.setFieldValue("message", msg);
        return fieldIndex >= 5;
    }

    private void populateLogRecordSuppAttrs(String text, ParsedLogRecord parsedLogRecord) {
        int index = text.indexOf(58);
        if (index > 0) {
            String key = text.substring(0, index);
            String value = text.substring(index + 1);
            value = value.trim();
            if (ODL_STANDARD_FIELDS.containsKey(key)) {
                parsedLogRecord.setFieldValue(ODL_STANDARD_FIELDS.get(key), value);
            } else {
                Properties props = (Properties)parsedLogRecord.getFieldValue("suppAttrs");
                props.put(key, value);
                if (key.equals("timeMillis")) {
                    parsedLogRecord.setFieldValue("timeMillis", value);
                }
            }
        }
    }

    private void populateLogRecordFields(int index, String fieldData, ParsedLogRecord parsedLogRecord) {
        switch (index) {
            case 1: {
                parsedLogRecord.setFieldValue("timestamp", fieldData);
                break;
            }
            case 2: {
                parsedLogRecord.setFieldValue("productId", fieldData);
                break;
            }
            case 3: {
                parsedLogRecord.setFieldValue("level", fieldData);
                break;
            }
            case 4: {
                parsedLogRecord.setFieldValue("msgId", fieldData);
                break;
            }
            case 5: {
                parsedLogRecord.setFieldValue("logger", fieldData);
                break;
            }
        }
    }

    private static final class ODLFieldPatternHolder {
        static final Pattern ODL_FIELD_PATTERN = Pattern.compile("(\\[[^\\[\\]]*?\\])+?");

        private ODLFieldPatternHolder() {
        }
    }
}

