/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.cdi;

import fish.payara.microprofile.config.cdi.ConfigProducer;
import fish.payara.microprofile.config.cdi.ConfigPropertiesProducer;
import fish.payara.microprofile.config.cdi.ConfigPropertyProducer;
import fish.payara.microprofile.config.cdi.TypesBeanAttributes;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfig;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Provider;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigCdiExtension
implements Extension {
    private Set<Type> configPropertiesBeanTypes = new HashSet<Type>();

    public void validateInjectionPoint(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty property = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (property != null) {
            try {
                Class rawClazz;
                Type t = pip.getInjectionPoint().getType();
                if (Class.class.isInstance(pip.getInjectionPoint().getType())) {
                    ConfigPropertyProducer.getGenericProperty(pip.getInjectionPoint());
                } else if (t instanceof ParameterizedType && (rawClazz = (Class)((ParameterizedType)t).getRawType()) != Provider.class && rawClazz != Optional.class) {
                    ConfigPropertyProducer.getGenericProperty(pip.getInjectionPoint());
                }
            }
            catch (Throwable de) {
                Class failingClass = null;
                Bean bean = pip.getInjectionPoint().getBean();
                failingClass = bean == null ? pip.getInjectionPoint().getMember().getDeclaringClass() : pip.getInjectionPoint().getBean().getBeanClass();
                pip.addDefinitionError((Throwable)new DeploymentException("Deployment Failure for ConfigProperty " + property.name() + " in class " + failingClass.getCanonicalName() + " Reason " + de.getMessage(), de));
            }
        }
    }

    public void createConfigProducer(@Observes BeforeBeanDiscovery event, BeanManager bm) {
        AnnotatedType at = bm.createAnnotatedType(ConfigProducer.class);
        event.addAnnotatedType(at, ConfigProducer.class.getName());
    }

    public <T> void storeConfigPropertiesType(@Observes @WithAnnotations(value={ConfigProperties.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.getJavaClass().isAnnotationPresent(ConfigProperties.class)) {
            event.veto();
            return;
        }
        for (AnnotatedField field : type.getFields()) {
            Class<?> memberClass = field.getJavaMember().getType();
            if (!memberClass.isAnnotationPresent(ConfigProperties.class)) continue;
            this.configPropertiesBeanTypes.add(memberClass);
        }
    }

    public void addDynamicProducers(@Observes AfterBeanDiscovery event, BeanManager bm) {
        Config config = ConfigProvider.getConfig();
        if (config instanceof PayaraConfig) {
            AnnotatedType propertyProducerType = bm.createAnnotatedType(ConfigPropertyProducer.class);
            AnnotatedType objectProducerType = bm.createAnnotatedType(ConfigPropertiesProducer.class);
            BeanAttributes propertyBeanAttributes = null;
            BeanAttributes objectBeanAttributes = null;
            AnnotatedMethod propertyProducerMethod = null;
            AnnotatedMethod objectProducerMethod = null;
            for (AnnotatedMethod m : propertyProducerType.getMethods()) {
                String string = m.getJavaMember().getName();
                if (!string.equals("getGenericProperty")) continue;
                propertyBeanAttributes = bm.createBeanAttributes((AnnotatedMember)m);
                propertyProducerMethod = m;
                break;
            }
            for (AnnotatedMethod m : objectProducerType.getMethods()) {
                String string = m.getJavaMember().getName();
                if (!string.equals("getGenericObject")) continue;
                objectBeanAttributes = bm.createBeanAttributes((AnnotatedMember)m);
                objectProducerMethod = m;
                break;
            }
            if (objectProducerMethod != null & !this.configPropertiesBeanTypes.isEmpty()) {
                Bean bean = bm.createBean((BeanAttributes)new TypesBeanAttributes<Object>(objectBeanAttributes){

                    public Set<Type> getTypes() {
                        return ConfigCdiExtension.this.configPropertiesBeanTypes;
                    }
                }, ConfigPropertiesProducer.class, bm.getProducerFactory(objectProducerMethod, null));
                event.addBean(bean);
            }
            if (propertyProducerMethod != null) {
                HashSet types = new HashSet();
                types.add(ConfigValue.class);
                types.addAll(((PayaraConfig)config).getConverterTypes());
                types.add(String.class);
                for (final Type type : types) {
                    Bean bean = bm.createBean((BeanAttributes)new TypesBeanAttributes<Object>(propertyBeanAttributes){

                        public Set<Type> getTypes() {
                            HashSet<Type> result = new HashSet<Type>();
                            result.add(type);
                            if (type instanceof Class) {
                                Object array = Array.newInstance((Class)type, 0);
                                result.add(array.getClass());
                            }
                            if (type == Long.class) {
                                result.add(Long.TYPE);
                                result.add(new long[0].getClass());
                            } else if (type == Boolean.class) {
                                result.add(Boolean.TYPE);
                                result.add(new boolean[0].getClass());
                            } else if (type == Integer.class) {
                                result.add(Integer.TYPE);
                                result.add(new int[0].getClass());
                            } else if (type == Float.class) {
                                result.add(Float.TYPE);
                                result.add(new float[0].getClass());
                            } else if (type == Double.class) {
                                result.add(Double.TYPE);
                                result.add(new double[0].getClass());
                            }
                            return result;
                        }
                    }, ConfigPropertyProducer.class, bm.getProducerFactory(propertyProducerMethod, null));
                    event.addBean(bean);
                }
            }
        }
    }
}

