/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.cdi;

import fish.payara.microprofile.config.cdi.ConfigPropertyProducer;
import fish.payara.microprofile.config.cdi.model.ConfigPropertyModel;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public class ConfigPropertiesProducer {
    private static final Logger LOGGER = Logger.getLogger(ConfigPropertiesProducer.class.getName());

    @ConfigProperties
    public static final Object getGenericObject(InjectionPoint injectionPoint, BeanManager bm) throws InstantiationException, IllegalAccessException {
        Type type = injectionPoint.getType();
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("Unable to process injection point with @ConfigProperties of type " + type);
        }
        Object object = ((Class)type).newInstance();
        AnnotatedType annotatedType = bm.createAnnotatedType((Class)type);
        ConfigProperties injectionAnnotation = ConfigPropertiesProducer.getQualifier(injectionPoint);
        ConfigProperties classAnnotation = (ConfigProperties)annotatedType.getAnnotation(ConfigProperties.class);
        String prefix = ConfigPropertiesProducer.parsePrefixes(injectionAnnotation, classAnnotation);
        for (AnnotatedField field : annotatedType.getFields()) {
            Field javaField = field.getJavaMember();
            javaField.setAccessible(true);
            InjectionPoint fieldInjectionPoint = bm.createInjectionPoint(field);
            ConfigPropertyModel model = new ConfigPropertyModel(fieldInjectionPoint, prefix);
            try {
                Object value = ConfigPropertyProducer.getGenericPropertyFromModel(model);
                if (value == null) continue;
                javaField.set(object, value);
            }
            catch (Exception ex) {
                if (javaField.get(object) != null) continue;
                LOGGER.log(Level.WARNING, String.format("Unable to inject property with name %s into type %s.", model.getName(), type.getTypeName()), ex);
                throw ex;
            }
        }
        return object;
    }

    private static ConfigProperties getQualifier(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated != null) {
            return (ConfigProperties)annotated.getAnnotation(ConfigProperties.class);
        }
        Set qualifiers = injectionPoint.getQualifiers();
        for (Annotation qualifier : qualifiers) {
            if (!(qualifier instanceof ConfigProperties)) continue;
            return (ConfigProperties)qualifier;
        }
        return null;
    }

    private static String parsePrefixes(ConfigProperties injectionAnnotation, ConfigProperties classAnnotation) {
        String injectionPrefix = ConfigPropertiesProducer.parsePrefix(injectionAnnotation);
        if (injectionPrefix != null) {
            return injectionPrefix;
        }
        return ConfigPropertiesProducer.parsePrefix(classAnnotation);
    }

    private static String parsePrefix(ConfigProperties annotation) {
        if (annotation == null) {
            return null;
        }
        String value = annotation.prefix();
        if (value == null || value.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
            return null;
        }
        if (value.isEmpty()) {
            return "";
        }
        return value + ".";
    }
}

