/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.util;

import com.sun.jsft.util.LogUtil;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class Util {
    private static final String CLASSLOADER_CACHE = "__jsft_ClassLoaders";
    public static final String CUSTOM_CLASS_LOADER = "com.sun.jsft.CLASSLOADER";

    public static ClassLoader getClassLoader(Object obj) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && obj != null) {
            loader = obj.getClass().getClassLoader();
        }
        loader = Util.getCustomClassLoader(loader);
        return loader;
    }

    private static ClassLoader getCustomClassLoader(ClassLoader parent) {
        parent = parent == null ? ClassLoader.getSystemClassLoader() : parent;
        FacesContext ctx = FacesContext.getCurrentInstance();
        Map<ClassLoader, ClassLoader> classLoaderCache = Util.getClassLoaderCache(ctx);
        ClassLoader loader = classLoaderCache.get(parent);
        if (loader != null) {
            return loader;
        }
        loader = parent;
        String clsName = null;
        if (ctx != null) {
            clsName = ctx.getExternalContext().getInitParameterMap().get(CUSTOM_CLASS_LOADER);
        }
        if (clsName != null) {
            if (clsName.equals(loader.getClass().getName())) {
                return loader;
            }
            try {
                Class<?> cls = Class.forName(clsName, true, parent);
                loader = (ClassLoader)cls.getConstructor(ClassLoader.class).newInstance(parent);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Unable to load class (" + clsName + ").  Make sure your context-param is specified correctly and that your custom ClassLoader is included in your application.", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("Unable to load class (" + clsName + ").  You must have a constructor that allows the parent ClassLoader to be provided on your custom ClassLoader.", ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Unable to instantiate class (" + clsName + ")!", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Unable to access class (" + clsName + ")!", ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException("Unable to instantiate class (" + clsName + ")!", ex);
            }
        }
        classLoaderCache.put(parent, loader);
        return loader;
    }

    private static Map<ClassLoader, ClassLoader> getClassLoaderCache(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        HashMap map = null;
        if (ctx != null) {
            map = (HashMap)ctx.getExternalContext().getApplicationMap().get(CLASSLOADER_CACHE);
        }
        if (map == null) {
            map = new HashMap(4);
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(CLASSLOADER_CACHE, map);
            }
        }
        return map;
    }

    public static Class loadClass(String className, Object obj) throws ClassNotFoundException {
        Class<?> cls;
        ClassLoader loader;
        block8: {
            loader = Util.getClassLoader(obj);
            cls = null;
            if (loader != null) {
                try {
                    cls = Class.forName(className, false, loader);
                }
                catch (ClassNotFoundException ex) {
                    if (!LogUtil.finestEnabled()) break block8;
                    LogUtil.finest("Unable to find class (" + className + ") using the context ClassLoader: '" + loader + "'.  I will keep looking.", ex);
                }
            }
        }
        if (cls == null) {
            block9: {
                if (obj != null && (loader = obj.getClass().getClassLoader()) != null) {
                    try {
                        cls = Class.forName(className, false, loader);
                    }
                    catch (ClassNotFoundException ex) {
                        if (!LogUtil.finestEnabled()) break block9;
                        LogUtil.finest("Unable to find class (" + className + ") using ClassLoader: '" + loader + "'.  I will try the System ClassLoader.", ex);
                    }
                }
            }
            if (cls == null) {
                loader = ClassLoader.getSystemClassLoader();
                cls = Class.forName(className, false, loader);
            }
        }
        return cls;
    }

    public static Class noExceptionLoadClass(String name) {
        Class cls = null;
        try {
            cls = Util.loadClass(name, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cls;
    }

    public static Class getClass(Object obj) throws ClassNotFoundException {
        if (obj == null || obj instanceof Class) {
            return (Class)obj;
        }
        Class cls = null;
        cls = obj instanceof String ? Util.loadClass((String)obj, obj) : obj.getClass();
        return cls;
    }

    public static Method getMethod(Class cls, String name, Class ... prms) {
        Method method = null;
        try {
            method = cls.getMethod(name, prms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return method;
    }

    public static Properties mapToProperties(Map map) {
        if (map == null || map instanceof Properties) {
            return (Properties)map;
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)map);
        return props;
    }

    public static Locale getLocale(FacesContext context) {
        UIViewRoot root;
        Locale locale = null;
        if (context != null && (root = context.getViewRoot()) != null) {
            locale = root.getLocale();
        }
        return locale == null ? Locale.getDefault() : locale;
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        block5: for (char ch : str.toCharArray()) {
            switch (ch) {
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    protected static String stripLeadingDelimeter(String str, char ch) {
        if (str == null || str.equals("")) {
            return str;
        }
        int j = 0;
        char[] strArr = str.toCharArray();
        for (int i = 0; i < strArr.length; ++i) {
            j = i;
            if (strArr[i] != ch) break;
        }
        return str.substring(j);
    }

    public static void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

