/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.event;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.util.LogUtil;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ValueChangeEvent;
import java.io.Serializable;
import java.util.List;

public class ValueChangeListener
implements jakarta.faces.event.ValueChangeListener,
Serializable {
    private static final String VCL_INSTANCE = "__jsft_ValueChangeListener";
    private static final long serialVersionUID = 2L;
    public static final String VALUE_CHANGE = "valueChange";

    public static ValueChangeListener getInstance() {
        return ValueChangeListener.getInstance(FacesContext.getCurrentInstance());
    }

    public static ValueChangeListener getInstance(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        ValueChangeListener instance = null;
        if (ctx != null) {
            instance = (ValueChangeListener)ctx.getExternalContext().getApplicationMap().get(VCL_INSTANCE);
        }
        if (instance == null) {
            instance = new ValueChangeListener();
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(VCL_INSTANCE, instance);
            }
        }
        return instance;
    }

    @Override
    public void processValueChange(ValueChangeEvent event) {
        this.invokeValueChangeHandlers(event);
    }

    public void invokeValueChangeHandlers(ValueChangeEvent event) {
        UIComponent evh = (UIComponent)event.getSource();
        if (evh == null) {
            throw new IllegalArgumentException("ValueChange invoked, however, no source was given!");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        LayoutElement desc = null;
        List handlers = (List)evh.getAttributes().get(VALUE_CHANGE);
        if (handlers != null && handlers.size() > 0) {
            desc = new LayoutComponent(null, evh.getId(), null);
        } else {
            String viewId = ValueChangeListener.getViewId(evh);
            desc = ValueChangeListener.findLayoutElementByClientId(context, viewId, evh.getClientId(context));
            if (desc == null) {
                desc = ValueChangeListener.findLayoutElementById(context, viewId, evh.getId());
            }
        }
        if (desc == null) {
            throw new IllegalArgumentException("Unable to locate handlers for '" + evh.getClientId(context) + "'.");
        }
        desc.dispatchHandlers(context, VALUE_CHANGE, event);
    }

    public static String getViewId(UIComponent comp) {
        String result = null;
        while (comp != null && !(comp instanceof UIViewRoot)) {
            comp = comp.getParent();
        }
        if (comp != null) {
            result = ((UIViewRoot)comp).getViewId();
        }
        return result;
    }

    public static LayoutElement findLayoutElementByClientId(FacesContext ctx, String layoutDefKey, String clientId) {
        LayoutElement result;
        block2: {
            result = null;
            try {
                result = ValueChangeListener.findLayoutElementByClientId(LayoutDefinitionManager.getLayoutDefinition(ctx, layoutDefKey), clientId);
            }
            catch (LayoutDefinitionException ex) {
                if (!LogUtil.configEnabled()) break block2;
                LogUtil.config("Unable to resolve client id '" + clientId + "' for LayoutDefinition key: '" + layoutDefKey + "'.", ex);
            }
        }
        return result;
    }

    public static LayoutElement findLayoutElementByClientId(LayoutDefinition def, String clientId) {
        return null;
    }

    public static LayoutElement findLayoutElementById(FacesContext ctx, String layoutDefKey, String id) {
        LayoutElement result;
        block3: {
            if (id == null) {
                return null;
            }
            result = null;
            try {
                result = ValueChangeListener.findLayoutElementById(LayoutDefinitionManager.getLayoutDefinition(ctx, layoutDefKey), id);
            }
            catch (LayoutDefinitionException ex) {
                if (!LogUtil.configEnabled()) break block3;
                LogUtil.config("Unable to resolve id '" + id + "' for LayoutDefinition key: '" + layoutDefKey + "'.", ex);
            }
        }
        return result;
    }

    public static LayoutElement findLayoutElementById(LayoutElement elt, String id) {
        if (elt.getUnevaluatedId().equals(id)) {
            return elt;
        }
        LayoutElement child2 = null;
        for (LayoutElement child2 : elt.getChildLayoutElements()) {
            if (!(child2 instanceof LayoutComponent) || (child2 = ValueChangeListener.findLayoutElementById(child2, id)) == null) continue;
            return child2;
        }
        return null;
    }
}

