/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.server.internal.admingui;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.HighAvailabilityEnabler;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.spi.ThreadContext;
import com.sun.faces.util.FacesLogger;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class GlassFishInjectionProvider
extends DiscoverableInjectionProvider
implements AnnotationScanner,
HighAvailabilityEnabler,
ThreadContext {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String HABITAT_ATTRIBUTE = "org.glassfish.servlet.habitat";
    private ComponentEnvManager compEnvManager;
    private InjectionManager injectionManager;
    private InvocationManager invocationManager;
    private JCDIService cdiService;

    public GlassFishInjectionProvider(ServletContext servletContext) {
        ServiceLocator defaultServices = (ServiceLocator)servletContext.getAttribute(HABITAT_ATTRIBUTE);
        this.compEnvManager = (ComponentEnvManager)defaultServices.getService(ComponentEnvManager.class, new Annotation[0]);
        this.invocationManager = (InvocationManager)defaultServices.getService(InvocationManager.class, new Annotation[0]);
        this.injectionManager = (InjectionManager)defaultServices.getService(InjectionManager.class, new Annotation[0]);
        this.cdiService = (JCDIService)defaultServices.getService(JCDIService.class, new Annotation[0]);
    }

    @Override
    public Map<String, List<AnnotationScanner.ScannedAnnotation>> getAnnotatedClassesInCurrentModule(ServletContext servletContext) throws InjectionProviderException {
        HashMap<String, List<AnnotationScanner.ScannedAnnotation>> classesByAnnotation = new HashMap<String, List<AnnotationScanner.ScannedAnnotation>>();
        Collection allTypes = ((Types)((DeploymentContext)servletContext.getAttribute("com.sun.enterprise.web.WebModule.DeploymentContext")).getTransientAppMetaData(Types.class.getName(), Types.class)).getAllTypes();
        for (final Type type : allTypes) {
            for (AnnotationModel annotationModel : type.getAnnotations()) {
                AnnotationScanner.ScannedAnnotation toAdd;
                String annotationName = annotationModel.getType().getName();
                ArrayList<1> classesWithThisAnnotation = (ArrayList<1>)classesByAnnotation.get(annotationName);
                if (classesWithThisAnnotation == null) {
                    classesWithThisAnnotation = new ArrayList<1>();
                    classesByAnnotation.put(annotationName, classesWithThisAnnotation);
                }
                if (classesWithThisAnnotation.contains(toAdd = new AnnotationScanner.ScannedAnnotation(){

                    public boolean equals(Object obj) {
                        String otherName;
                        boolean result = false;
                        if (obj instanceof AnnotationScanner.ScannedAnnotation && (otherName = ((AnnotationScanner.ScannedAnnotation)obj).getFullyQualifiedClassName()) != null) {
                            result = type.getName().equals(otherName);
                        }
                        return result;
                    }

                    public int hashCode() {
                        String str = this.getFullyQualifiedClassName();
                        Collection<URI> obj = this.getDefiningURIs();
                        int result = str != null ? str.hashCode() : 0;
                        result = 31 * result + (obj != null ? obj.hashCode() : 0);
                        return result;
                    }

                    @Override
                    public String getFullyQualifiedClassName() {
                        return type.getName();
                    }

                    @Override
                    public Collection<URI> getDefiningURIs() {
                        return type.getDefiningURIs();
                    }
                })) continue;
                classesWithThisAnnotation.add(toAdd);
            }
        }
        return classesByAnnotation;
    }

    @Override
    public void inject(Object managedBean) throws InjectionProviderException {
        try {
            this.injectionManager.injectInstance(managedBean, this.getComponentEnvironment(), false);
            if (this.cdiService.isCurrentModuleJCDIEnabled()) {
                this.cdiService.injectManagedObject(managedBean, this.getBundle());
            }
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException(ie);
        }
    }

    @Override
    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            this.invokePostConstruct(managedBean, this.getComponentEnvironment());
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException(ie);
        }
    }

    @Override
    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            this.injectionManager.invokeInstancePreDestroy(managedBean);
        }
        catch (InjectionException ie) {
            throw new InjectionProviderException(ie);
        }
    }

    @Override
    public Object getParentWebContext() {
        return this.invocationManager.getAllInvocations();
    }

    @Override
    public void propagateWebContextToChild(Object context) {
        if (!(context instanceof List)) {
            throw new IllegalArgumentException("Context of incorrect type, was it obtained by calling getParentWebContext()?");
        }
        this.invocationManager.setThreadInheritableInvocation((List)context);
    }

    @Override
    public void clearChildContext() {
        this.invocationManager.popAllInvocations();
    }

    private JndiNameEnvironment getComponentEnvironment() throws InjectionException {
        ComponentInvocation invocation = this.invocationManager.getCurrentInvocation();
        if (invocation == null) {
            throw new InjectionException("null invocation context");
        }
        if (invocation.getInvocationType() != ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
            throw new InjectionException("Wrong invocation type");
        }
        JndiNameEnvironment componentEnvironment = (JndiNameEnvironment)invocation.getJndiEnvironment();
        if (componentEnvironment == null) {
            throw new InjectionException("No descriptor registered for  current invocation : " + invocation);
        }
        return componentEnvironment;
    }

    private void invokePostConstruct(Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class<?> nextClass = instance.getClass(); !Object.class.equals(nextClass) && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injectionInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injectionInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injectionInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private Method getPostConstructMethod(InjectionInfo injectionInfo, Class<? extends Object> resourceClass) throws InjectionException {
        Method postConstructMethod = injectionInfo.getPostConstructMethod();
        if (postConstructMethod == null) {
            String postConstructMethodName = injectionInfo.getPostConstructMethodName();
            for (Method declaredMethod : resourceClass.getDeclaredMethods()) {
                if (!declaredMethod.getName().equals(postConstructMethodName) || declaredMethod.getParameterTypes().length != 0) continue;
                postConstructMethod = declaredMethod;
                injectionInfo.setPostConstructMethod(postConstructMethod);
                break;
            }
        }
        if (postConstructMethod == null) {
            throw new InjectionException("InjectionManager exception. PostConstruct method " + injectionInfo.getPostConstructMethodName() + " could not be found in class " + injectionInfo.getClassName());
        }
        return postConstructMethod;
    }

    private void invokeLifecycleMethod(final Method lifecycleMethod, final Object instance) throws InjectionException {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Calling lifecycle method " + lifecycleMethod + " on class " + lifecycleMethod.getDeclaringClass());
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (!lifecycleMethod.isAccessible()) {
                        lifecycleMethod.setAccessible(true);
                    }
                    lifecycleMethod.invoke(instance, new Object[0]);
                    return null;
                }
            });
        }
        catch (Exception t) {
            String msg = "Exception attempting invoke lifecycle  method " + lifecycleMethod;
            LOGGER.log(Level.FINE, msg, t);
            InjectionException ie = new InjectionException(msg);
            Throwable cause = t instanceof InvocationTargetException ? t.getCause() : t;
            ie.initCause(cause);
            throw ie;
        }
    }

    private BundleDescriptor getBundle() {
        JndiNameEnvironment componentEnvironment = this.compEnvManager.getCurrentJndiNameEnvironment();
        BundleDescriptor bundle = null;
        if (componentEnvironment instanceof BundleDescriptor) {
            bundle = (BundleDescriptor)componentEnvironment;
        }
        if (bundle == null) {
            throw new IllegalStateException("Invalid context for managed bean creation");
        }
        return bundle;
    }

    @Override
    public void enableHighAvailability(ServletContext ctx) {
        WebConfiguration config = WebConfiguration.getInstance(ctx);
        if (!config.isSet(WebConfiguration.BooleanWebContextInitParameter.EnableAgressiveSessionDirtying)) {
            Object isDistributableObj = ctx.getAttribute("com.sun.enterprise.web.WebModule.isDistributable");
            Object enableHAObj = ctx.getAttribute("com.sun.enterprise.web.WebModule.enableHA");
            if (isDistributableObj instanceof Boolean && enableHAObj instanceof Boolean) {
                boolean isDistributable = (Boolean)isDistributableObj;
                boolean enableHA = (Boolean)enableHAObj;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "isDistributable = {0} enableHA = {1}", new Object[]{isDistributable, enableHA});
                }
                if (isDistributable && enableHA) {
                    LOGGER.fine("setting the EnableAgressiveSessionDirtying to true");
                    config.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.EnableAgressiveSessionDirtying, Boolean.TRUE);
                }
            }
        }
    }
}

