/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client.utils;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.rest.client.utils.RestClientLogging;
import org.glassfish.api.logging.LogHelper;

public class Util {
    public static Map processJsonMap(String json) {
        Map<Object, Object> map;
        try (JsonParser parser = Json.createParser((Reader)new StringReader(json));){
            if (parser.hasNext()) {
                parser.next();
                map = Util.processJsonObject(parser.getObject());
            } else {
                map = new HashMap();
            }
        }
        catch (JsonException e) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, Object> processJsonObject(JsonObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            block11: for (String key : jsonObject.keySet()) {
                JsonValue value = (JsonValue)jsonObject.get((Object)key);
                switch (value.getValueType()) {
                    case ARRAY: {
                        map.put(key, Util.processJsonArray((JsonArray)value));
                        continue block11;
                    }
                    case OBJECT: {
                        map.put(key, Util.processJsonObject((JsonObject)value));
                        continue block11;
                    }
                    case NULL: {
                        map.put(key, null);
                        continue block11;
                    }
                    case STRING: {
                        map.put(key, ((JsonString)value).getString());
                        continue block11;
                    }
                    case NUMBER: {
                        map.put(key, ((JsonNumber)value).numberValue());
                        continue block11;
                    }
                    case TRUE: {
                        map.put(key, Boolean.TRUE);
                        continue block11;
                    }
                    case FALSE: {
                        map.put(key, Boolean.FALSE);
                        continue block11;
                    }
                }
                map.put(key, value);
            }
        }
        catch (JsonException e) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00004", (Throwable)e, (Object[])new Object[0]);
        }
        return map;
    }

    public static List processJsonArray(JsonArray jsonArray) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            block10: for (JsonValue entry : jsonArray) {
                if (null == entry.getValueType()) {
                    results.add(entry);
                    continue;
                }
                switch (entry.getValueType()) {
                    case ARRAY: {
                        results.add(Util.processJsonArray((JsonArray)entry));
                        continue block10;
                    }
                    case OBJECT: {
                        results.add(Util.processJsonObject((JsonObject)entry));
                        continue block10;
                    }
                    case STRING: {
                        results.add(((JsonString)entry).getString());
                        continue block10;
                    }
                    case NUMBER: {
                        results.add(((JsonNumber)entry).numberValue());
                        continue block10;
                    }
                    case TRUE: {
                        results.add(Boolean.TRUE);
                        continue block10;
                    }
                    case FALSE: {
                        results.add(Boolean.FALSE);
                        continue block10;
                    }
                }
                results.add(entry);
            }
        }
        catch (JsonException e) {
            LogHelper.log((Logger)RestClientLogging.logger, (Level)Level.SEVERE, (String)"NCLS-RSCL-00004", (Throwable)e, (Object[])new Object[0]);
        }
        return results;
    }
}

