/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ha.hazelcast.store;

import fish.payara.nucleus.store.ClusteredStore;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;

public class HazelcastBackingStore<K extends Serializable, V extends Serializable>
extends BackingStore<K, V> {
    private final BackingStoreFactory factory;
    private final String storeName;
    private String instanceName;
    private ClusteredStore clusteredStore;

    public HazelcastBackingStore(BackingStoreFactory factory, String storeName, ClusteredStore clusteredStore) {
        this.factory = factory;
        this.storeName = storeName;
        this.clusteredStore = clusteredStore;
    }

    @Override
    public BackingStoreFactory getBackingStoreFactory() {
        return this.factory;
    }

    @Override
    public V load(K k, String string) throws BackingStoreException {
        this.init();
        try {
            return (V)this.clusteredStore.get(this.storeName, k);
        }
        catch (ClassCastException cce) {
            Logger.getLogger(HazelcastBackingStore.class.getName()).log(Level.WARNING, "ClassCastException when reading value from store", cce);
            throw new BackingStoreException(cce.getMessage());
        }
    }

    @Override
    public String save(K k, V v, boolean bln) throws BackingStoreException {
        this.init();
        this.clusteredStore.set(this.storeName, k, v);
        return this.instanceName;
    }

    @Override
    public void remove(K k) throws BackingStoreException {
        this.init();
        this.clusteredStore.remove(this.storeName, k);
    }

    @Override
    public int size() throws BackingStoreException {
        this.init();
        return this.clusteredStore.getMap(this.storeName).size();
    }

    private void init() throws BackingStoreException {
        if (this.instanceName != null) {
            return;
        }
        if (this.clusteredStore == null) {
            throw new BackingStoreException("Clustered Store not available, cannot use sessions yet", new IllegalStateException("Initializing"));
        }
        if (!this.clusteredStore.isEnabled()) {
            throw new BackingStoreException("Hazelcast is not enabled, please enable Hazelcast");
        }
        this.instanceName = this.clusteredStore.getInstanceId().toString();
    }
}

