/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.audit;

import com.sun.appserv.security.AuditModule;
import com.sun.enterprise.security.BaseAuditModule;
import com.sun.enterprise.security.audit.BaseAuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@Rank(value=20)
public final class AppServerAuditManager
extends BaseAuditManager<AuditModule> {
    private static final Logger _logger = LogDomains.getLogger(AppServerAuditManager.class, (String)"javax.enterprise.system.core.security", (boolean)false);
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(AppServerAuditManager.class);
    private static final String AUDIT_MGR_WS_INVOCATION_KEY = "auditmgr.webServiceInvocation";
    private static final String AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY = "auditmgr.ejbAsWebServiceInvocation";
    private List<AuditModule> myAuditModules;

    @Override
    public BaseAuditModule addAuditModule(String name, String classname, Properties props) throws Exception {
        BaseAuditModule auditModule = super.addAuditModule(name, classname, props);
        if (AuditModule.class.isAssignableFrom(auditModule.getClass())) {
            this.myAuditModules().add((AuditModule)auditModule);
        }
        return auditModule;
    }

    @Override
    public BaseAuditModule removeAuditModule(String name) {
        BaseAuditModule auditModule = super.removeAuditModule(name);
        if (AuditModule.class.isAssignableFrom(auditModule.getClass())) {
            this.myAuditModules().remove((AuditModule)auditModule);
        }
        return auditModule;
    }

    public void webInvocation(String user, HttpServletRequest request, String type, boolean success) {
        if (this.auditOn) {
            for (AuditModule auditModule : this.myAuditModules()) {
                try {
                    auditModule.webInvocation(user, request, type, success);
                }
                catch (Exception ex) {
                    _logger.log(Level.INFO, _localStrings.getLocalString("auditmgr.webinvocation", " Audit Module {0} threw the following exception during web invocation :", new Object[]{this.moduleName((BaseAuditModule)auditModule)}), ex);
                }
            }
        }
    }

    public void ejbInvocation(String user, String ejb, String method, boolean success) {
        if (this.auditOn) {
            for (AuditModule auditModule : this.myAuditModules()) {
                try {
                    auditModule.ejbInvocation(user, ejb, method, success);
                }
                catch (Exception ex) {
                    _logger.log(Level.INFO, _localStrings.getLocalString("auditmgr.ejbinvocation", " Audit Module {0} threw the following exception during ejb invocation :", new Object[]{this.moduleName((BaseAuditModule)auditModule)}), ex);
                }
            }
        }
    }

    public void webServiceInvocation(String uri, String endpoint, boolean validRequest) {
        if (this.auditOn) {
            for (AuditModule auditModule : this.myAuditModules()) {
                try {
                    auditModule.webServiceInvocation(uri, endpoint, validRequest);
                }
                catch (Exception ex) {
                    String name = this.moduleName((BaseAuditModule)auditModule);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    public void ejbAsWebServiceInvocation(String endpoint, boolean validRequest) {
        if (this.auditOn) {
            for (AuditModule auditModule : this.myAuditModules()) {
                try {
                    auditModule.ejbAsWebServiceInvocation(endpoint, validRequest);
                }
                catch (Exception ex) {
                    String name = this.moduleName((BaseAuditModule)auditModule);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during ejb as web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    private synchronized List<AuditModule> myAuditModules() {
        if (this.myAuditModules == null) {
            this.myAuditModules = this.instances(AuditModule.class);
        }
        return this.myAuditModules;
    }
}

