/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.auth.login;

import com.sun.appserv.security.ProgrammaticLoginPermission;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.web.integration.WebProgrammaticLogin;
import com.sun.logging.LogDomains;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ProgrammaticLogin {
    private static final Logger logger = LogDomains.getLogger(ProgrammaticLogin.class, (String)"javax.enterprise.system.core.security");
    private static ProgrammaticLoginPermission plLogin = new ProgrammaticLoginPermission("login");
    private static ProgrammaticLoginPermission plLogout = new ProgrammaticLoginPermission("logout");
    private static CallbackHandler handler = new LoginCallbackHandler(false);
    private WebProgrammaticLogin webProgrammaticLogin;

    public ProgrammaticLogin() {
        if (SecurityServicesUtil.getInstance() != null) {
            this.resolveWebProgrammaticLogin();
        }
    }

    public Boolean login(String user, String password) {
        return this.login(user, password.toCharArray());
    }

    public Boolean login(String user, char[] password) {
        try {
            return this.login(user, password, null, false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean login(String user, String password, String realm, boolean errors) throws Exception {
        return this.login(user, password.toCharArray(), realm, errors);
    }

    public Boolean login(final String user, final char[] password, final String realm, boolean errors) throws Exception {
        Boolean authenticated = null;
        try {
            this.checkLoginPermission(user);
            authenticated = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (ProgrammaticLogin.this.isServer()) {
                        WebAndEjbToJaasBridge.login(user, password, realm);
                    } else {
                        ProgrammaticLogin.this.executeWithCredentials(user, password, () -> LoginContextDriver.doClientLogin(1, handler));
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "prog.login.failed", e);
            this.throwOrFalse(e, errors);
        }
        return authenticated;
    }

    public Boolean logout() {
        try {
            return this.logout(false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean logout(boolean errors) throws Exception {
        Boolean loggedout = null;
        try {
            this.checkLogoutPermission();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (SecurityServicesUtil.getInstance() != null && SecurityServicesUtil.getInstance().isServer()) {
                        WebAndEjbToJaasBridge.logout();
                    } else {
                        UsernamePasswordStore.reset();
                        LoginContextDriver.doClientLogout();
                    }
                    return null;
                }
            });
            loggedout = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "prog.logout.failed", e);
            loggedout = this.throwOrFalse(e, errors);
        }
        return loggedout;
    }

    public Boolean login(String user, String password, String realm, HttpServletRequest request, HttpServletResponse response, boolean errors) throws Exception {
        return this.login(user, password.toCharArray(), realm, request, response, errors);
    }

    public Boolean login(String user, String password, HttpServletRequest request, HttpServletResponse response) {
        return this.login(user, password.toCharArray(), request, response);
    }

    public Boolean login(String user, char[] password, HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.login(user, password, null, request, response, false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean login(String user, char[] password, String realm, HttpServletRequest request, HttpServletResponse response, boolean errors) throws Exception {
        try {
            this.checkLoginPermission(user);
            return AppservAccessController.privilegedAlways(() -> this.webProgrammaticLogin.login(user, password, realm, request, response));
        }
        catch (Exception e) {
            return this.throwOrFalse(e, errors);
        }
    }

    public Boolean logout(HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.logout(request, response, false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean logout(final HttpServletRequest request, final HttpServletResponse response, boolean errors) throws Exception {
        try {
            this.checkLogoutPermission();
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return ProgrammaticLogin.this.webProgrammaticLogin.logout(request, response);
                }
            });
        }
        catch (Exception e) {
            return this.throwOrFalse(e, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithCredentials(String user, char[] password, Runnable action) {
        UsernamePasswordStore.set(user, password);
        try {
            action.run();
        }
        finally {
            UsernamePasswordStore.resetThreadLocalOnly();
        }
    }

    private void checkLoginPermission(String user) throws Exception {
        try {
            SecurityManager securityManager;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ProgrammaticLogin.login() called for user: " + user);
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPermission((Permission)plLogin);
            }
        }
        catch (Exception e) {
            logger.warning("proglogin.noperm");
            throw e;
        }
    }

    private void checkLogoutPermission() throws Exception {
        try {
            logger.log(Level.FINE, "ProgrammaticLogin.logout() called.");
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission((Permission)plLogout);
            }
        }
        catch (Exception e) {
            logger.warning("prologout.noperm");
            throw e;
        }
    }

    private void resolveWebProgrammaticLogin() {
        this.webProgrammaticLogin = SecurityServicesUtil.getInstance().getHabitat().getService(WebProgrammaticLogin.class, new Annotation[0]);
    }

    private boolean isServer() {
        return SecurityServicesUtil.getInstance() != null && SecurityServicesUtil.getInstance().isServer() || Util.isEmbeddedServer();
    }

    private boolean throwOrFalse(Exception e, boolean errors) throws Exception {
        if (errors) {
            throw e;
        }
        return false;
    }
}

