/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.cache;

import com.sun.enterprise.security.ee.J2EESecurityManager;
import com.sun.enterprise.security.jacc.cache.PermissionCache;
import java.net.SocketPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.util.Hashtable;
import java.util.PropertyPermission;

public class PermissionCacheFactory {
    private static final Hashtable cacheMap = new Hashtable();
    private static int factoryKey;
    private static boolean supportsReuse;
    private static Permission[] protoPerms;
    private static PermissionCache securityManagerCache;

    private static Integer getNextKey() {
        Integer key = factoryKey++;
        while (cacheMap.get(key) != null) {
            key = factoryKey++;
        }
        return key;
    }

    private static synchronized PermissionCache createSecurityManagerCache() {
        return PermissionCacheFactory.registerPermissionCache(new PermissionCache(PermissionCacheFactory.getNextKey(), null, null, protoPerms, null));
    }

    public static synchronized PermissionCache createPermissionCache(String pcID, CodeSource codesource, Permission[] perms, String name) {
        if (!supportsReuse) {
            return null;
        }
        Integer key = PermissionCacheFactory.getNextKey();
        PermissionCache cache = new PermissionCache(key, pcID, codesource, perms, name);
        return PermissionCacheFactory.registerPermissionCache(cache);
    }

    public static synchronized PermissionCache createPermissionCache(String pcID, CodeSource codesource, Class clazz, String name) {
        if (!supportsReuse) {
            return null;
        }
        return PermissionCacheFactory.registerPermissionCache(new PermissionCache(PermissionCacheFactory.getNextKey(), pcID, codesource, clazz, name));
    }

    private static PermissionCache registerPermissionCache(PermissionCache cache) {
        cacheMap.put(cache.getFactoryKey(), cache);
        return cache;
    }

    public static synchronized PermissionCache removePermissionCache(PermissionCache cache) {
        Object value;
        PermissionCache rvalue = null;
        if (cache != null && (value = cacheMap.remove(cache.getFactoryKey())) != null && value instanceof PermissionCache) {
            rvalue = (PermissionCache)value;
            rvalue.reset();
        }
        return rvalue;
    }

    public static synchronized void resetCaches() {
        supportsReuse = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && sm instanceof J2EESecurityManager && !((J2EESecurityManager)sm).cacheEnabled()) {
            ((J2EESecurityManager)sm).enablePermissionCache(securityManagerCache);
        }
        for (Object cache : cacheMap.values()) {
            if (!(cache instanceof PermissionCache)) continue;
            ((PermissionCache)cache).reset();
        }
    }

    static {
        protoPerms = new Permission[]{new SocketPermission("localhost", "connect"), new PropertyPermission("x", "read")};
        securityManagerCache = PermissionCacheFactory.createSecurityManagerCache();
        try {
            Policy policy = Policy.getPolicy();
            if (policy != null) {
                policy.refresh();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

