/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jacc.context;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jacc.cache.PermissionCacheFactory;
import com.sun.enterprise.security.jacc.context.PolicyContextDelegate;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.internal.api.Globals;

public class PolicyContextHandlerData {
    private HttpServletRequest httpServletRequest;
    private ComponentInvocation invocation;
    private PolicyContextDelegate ejbDelegate = Globals.getDefaultHabitat().getService(PolicyContextDelegate.class, "EJB", new Annotation[0]);

    private PolicyContextHandlerData() {
    }

    public static PolicyContextHandlerData getInstance() {
        return new PolicyContextHandlerData();
    }

    public void setHttpServletRequest(HttpServletRequest httpReq) {
        this.httpServletRequest = httpReq;
    }

    public void setInvocation(ComponentInvocation inv) {
        this.invocation = inv;
    }

    public Object get(String key) {
        if ("jakarta.servlet.http.HttpServletRequest".equalsIgnoreCase(key)) {
            return this.httpServletRequest;
        }
        if ("javax.security.auth.Subject.container".equalsIgnoreCase(key)) {
            return SecurityContext.getCurrent().getSubject();
        }
        if ("java.security.Policy.supportsReuse".equalsIgnoreCase(key)) {
            PermissionCacheFactory.resetCaches();
            return 0;
        }
        if (this.invocation == null) {
            return null;
        }
        if ("jakarta.xml.soap.SOAPMessage".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getSOAPMessage(this.invocation) : null;
        }
        if ("jakarta.ejb.EnterpriseBean".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getEnterpriseBean(this.invocation) : null;
        }
        if ("jakarta.ejb.arguments".equalsIgnoreCase(key)) {
            return this.ejbDelegate != null ? this.ejbDelegate.getEJbArguments(this.invocation) : null;
        }
        return null;
    }

    void reset() {
        this.httpServletRequest = null;
        this.invocation = null;
        this.ejbDelegate = null;
    }
}

