/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jaspic.callback;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.JaspicToJaasBridge;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.jaspic.config.CallbackHandlerConfig;
import com.sun.enterprise.security.jaspic.config.HandlerContext;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.CertStoreCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.callback.PrivateKeyCallback;
import jakarta.security.auth.message.callback.SecretKeyCallback;
import jakarta.security.auth.message.callback.TrustStoreCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.MasterPassword;
import org.glassfish.security.common.PrincipalImpl;

abstract class BaseContainerCallbackHandler
implements CallbackHandler,
CallbackHandlerConfig {
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";
    private static final String CLIENT_SECRET_KEYSTORE = "com.sun.appserv.client.secretKeyStore";
    private static final String CLIENT_SECRET_KEYSTORE_PASSWORD = "com.sun.appserv.client.secretKeyStorePassword";
    protected static final Logger _logger = LogDomains.getLogger(BaseContainerCallbackHandler.class, (String)"javax.enterprise.system.core.security");
    protected HandlerContext handlerContext;
    protected final SSLUtils sslUtils;
    protected final SecuritySupport securitySupport;
    protected final MasterPassword masterPasswordHelper;

    protected BaseContainerCallbackHandler() {
        if (Globals.getDefaultHabitat() == null) {
            this.sslUtils = new SSLUtils();
            this.securitySupport = SecuritySupport.getDefaultInstance();
            this.masterPasswordHelper = null;
            this.sslUtils.postConstruct();
        } else {
            this.sslUtils = Globals.getDefaultHabitat().getService(SSLUtils.class, new Annotation[0]);
            this.securitySupport = Globals.getDefaultHabitat().getService(SecuritySupport.class, new Annotation[0]);
            this.masterPasswordHelper = Globals.getDefaultHabitat().getService(MasterPassword.class, "Security SSL Password Provider Service", new Annotation[0]);
        }
    }

    @Override
    public void setHandlerContext(HandlerContext handlerContext) {
        this.handlerContext = handlerContext;
    }

    protected abstract boolean isSupportedCallback(Callback var1);

    protected abstract void handleSupportedCallbacks(Callback[] var1) throws IOException, UnsupportedCallbackException;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        for (Callback callback : callbacks) {
            if (this.isSupportedCallback(callback)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JASPIC: UnsupportedCallback : " + callback.getClass().getName());
            }
            throw new UnsupportedCallbackException(callback);
        }
        this.handleSupportedCallbacks(callbacks);
    }

    protected void processCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof CallerPrincipalCallback) {
            this.processCallerPrincipal((CallerPrincipalCallback)callback);
        } else if (callback instanceof GroupPrincipalCallback) {
            this.processGroupPrincipal((GroupPrincipalCallback)callback);
        } else if (callback instanceof PasswordValidationCallback) {
            this.processPasswordValidation((PasswordValidationCallback)callback);
        } else if (callback instanceof PrivateKeyCallback) {
            this.processPrivateKey((PrivateKeyCallback)callback);
        } else if (callback instanceof TrustStoreCallback) {
            TrustStoreCallback tstoreCallback = (TrustStoreCallback)callback;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JASPIC: In TrustStoreCallback Processor");
            }
            tstoreCallback.setTrustStore(this.sslUtils.getMergedTrustStore());
        } else if (callback instanceof CertStoreCallback) {
            this.processCertStore((CertStoreCallback)callback);
        } else if (callback instanceof SecretKeyCallback) {
            this.processSecretKey((SecretKeyCallback)callback);
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JASPIC: UnsupportedCallback : " + callback.getClass().getName());
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private boolean reuseWebPrincipal(final Subject fs, final WebPrincipal wp) {
        SecurityContext sc = wp.getSecurityContext();
        final Subject wps = sc != null ? sc.getSubject() : null;
        final Principal callerPrincipal = sc != null ? sc.getCallerPrincipal() : null;
        final Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        return (Boolean)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Boolean run() {
                if (callerPrincipal == null || callerPrincipal.equals(defaultPrincipal) || wps == null) {
                    return Boolean.FALSE;
                }
                boolean hasObject = false;
                Set<DistinguishedPrincipalCredential> distinguishedCreds = wps.getPublicCredentials(DistinguishedPrincipalCredential.class);
                if (distinguishedCreds.size() == 1) {
                    for (DistinguishedPrincipalCredential cred : distinguishedCreds) {
                        if (!cred.getPrincipal().equals(callerPrincipal)) continue;
                        hasObject = true;
                    }
                }
                if (!hasObject) {
                    return Boolean.FALSE;
                }
                hasObject = wps.getPrincipals().contains(callerPrincipal);
                if (!hasObject) {
                    return Boolean.FALSE;
                }
                if (wp.getName() == null || !wp.getName().equals(callerPrincipal.getName())) {
                    return Boolean.FALSE;
                }
                Iterator<Object> iter = fs.getPublicCredentials().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof DistinguishedPrincipalCredential)) continue;
                    iter.remove();
                }
                for (Principal p : wps.getPrincipals()) {
                    fs.getPrincipals().add(p);
                }
                for (Object publicCred : wps.getPublicCredentials()) {
                    fs.getPublicCredentials().add(publicCred);
                }
                for (Object privateCred : wps.getPrivateCredentials()) {
                    fs.getPrivateCredentials().add(privateCred);
                }
                return Boolean.TRUE;
            }
        });
    }

    private void processCallerPrincipal(CallerPrincipalCallback callerPrincipalCallback) {
        Principal additional;
        Subject subject = callerPrincipalCallback.getSubject();
        Principal principal = callerPrincipalCallback.getPrincipal();
        if (principal != null && !(principal instanceof WebPrincipal) && (additional = SecurityContext.getCurrent().getAdditionalPrincipal()) != null && additional instanceof WebPrincipal && ((WebPrincipal)((Object)additional)).getCustomPrincipal() == principal) {
            principal = additional;
        }
        if (principal instanceof WebPrincipal) {
            Principal callerPrincipal;
            WebPrincipal webPrincipal = (WebPrincipal)((Object)principal);
            if (this.reuseWebPrincipal(subject, webPrincipal)) {
                return;
            }
            Principal defaultCallerPrincipal = SecurityContext.getDefaultCallerPrincipal();
            SecurityContext securityContext = webPrincipal.getSecurityContext();
            Principal principal2 = callerPrincipal = securityContext != null ? securityContext.getCallerPrincipal() : null;
            if (webPrincipal.getName() == null || webPrincipal.equals(defaultCallerPrincipal) || callerPrincipal == null || callerPrincipal.equals(defaultCallerPrincipal)) {
                principal = null;
            }
        }
        String realmName = null;
        if (this.handlerContext != null) {
            realmName = this.handlerContext.getRealmName();
        }
        boolean isCertRealm = "certificate".equals(realmName);
        if (principal == null) {
            principal = callerPrincipalCallback.getName() != null ? (isCertRealm ? new X500Principal(callerPrincipalCallback.getName()) : new PrincipalImpl(callerPrincipalCallback.getName())) : SecurityContext.getDefaultCallerPrincipal();
        }
        if (isCertRealm) {
            if (principal instanceof X500Principal) {
                JaspicToJaasBridge.jaasX500Login(subject, (X500Principal)principal);
            }
        } else if (!principal.equals(SecurityContext.getDefaultCallerPrincipal())) {
            JaspicToJaasBridge.addRealmGroupsToSubject(subject, principal.getName(), realmName);
        }
        Principal finalPrincipal = principal;
        DistinguishedPrincipalCredential distinguishedPrincipalCredential = new DistinguishedPrincipalCredential(principal);
        AppservAccessController.privileged(() -> {
            subject.getPrincipals().add(finalPrincipal);
            Iterator<Object> publicCredentials = subject.getPublicCredentials().iterator();
            while (publicCredentials.hasNext()) {
                if (!(publicCredentials.next() instanceof DistinguishedPrincipalCredential)) continue;
                publicCredentials.remove();
            }
            subject.getPublicCredentials().add(distinguishedPrincipalCredential);
        });
    }

    private void processGroupPrincipal(GroupPrincipalCallback groupCallback) {
        Subject subject = groupCallback.getSubject();
        String[] groups = groupCallback.getGroups();
        if (groups != null && groups.length > 0) {
            AppservAccessController.privileged(() -> Arrays.stream(groups).forEach(group -> subject.getPrincipals().add((Principal)new Group(group))));
        } else if (groups == null) {
            AppservAccessController.privileged(() -> subject.getPrincipals().removeAll(subject.getPrincipals(Group.class)));
        }
    }

    private void processPasswordValidation(PasswordValidationCallback pwdCallback) {
        if (SecurityServicesUtil.getInstance().isACC()) {
            _logger.log(Level.FINE, "JASPIC: In PasswordValidationCallback Processor for appclient - will do nothing");
            pwdCallback.setResult(true);
            return;
        }
        String username = pwdCallback.getUsername();
        char[] passwd = pwdCallback.getPassword();
        _logger.log(Level.FINE, "JASPIC: In PasswordValidationCallback Processor");
        try {
            String realmName = null;
            if (this.handlerContext != null) {
                realmName = this.handlerContext.getRealmName();
            }
            JaspicToJaasBridge.validateUsernamePasswordByJaas(pwdCallback.getSubject(), username, passwd, realmName);
            _logger.log(Level.FINE, "JASPIC: authentication succeeded for user = ", username);
            if (passwd != null) {
                for (int i = 0; i < passwd.length; ++i) {
                    passwd[i] = 32;
                }
            }
            pwdCallback.setResult(true);
        }
        catch (LoginException le) {
            _logger.log(Level.INFO, "jaspic.loginfail", username);
            pwdCallback.setResult(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrivateKey(PrivateKeyCallback privKeyCallback) {
        Certificate[] certificateChain;
        PrivateKey privateKey;
        block22: {
            KeyStore[] keyStores = this.securitySupport.getKeyStores();
            _logger.log(Level.FINE, "JASPIC: In PrivateKeyCallback Processor");
            if (keyStores == null || keyStores.length == 0) {
                privKeyCallback.setKey(null, null);
                return;
            }
            PrivateKeyCallback.Request request = privKeyCallback.getRequest();
            privateKey = null;
            certificateChain = null;
            if (request == null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = this.getDefaultPrivateKeyEntry(keyStores);
                if (privateKeyEntry != null) {
                    privateKey = privateKeyEntry.getPrivateKey();
                    certificateChain = privateKeyEntry.getCertificateChain();
                }
                privKeyCallback.setKey(privateKey, certificateChain);
                return;
            }
            try {
                if (request instanceof PrivateKeyCallback.AliasRequest) {
                    PrivateKeyCallback.AliasRequest aliasRequest = (PrivateKeyCallback.AliasRequest)request;
                    String alias = aliasRequest.getAlias();
                    KeyStore.PrivateKeyEntry privKeyEntry = alias == null ? this.getDefaultPrivateKeyEntry(keyStores) : this.sslUtils.getPrivateKeyEntryFromTokenAlias(alias);
                    if (privKeyEntry != null) {
                        privateKey = privKeyEntry.getPrivateKey();
                        certificateChain = privKeyEntry.getCertificateChain();
                    }
                    break block22;
                }
                if (request instanceof PrivateKeyCallback.IssuerSerialNumRequest) {
                    PrivateKeyCallback.IssuerSerialNumRequest issuerSerialNumRequest = (PrivateKeyCallback.IssuerSerialNumRequest)request;
                    X500Principal issuer = issuerSerialNumRequest.getIssuer();
                    BigInteger serialNum = issuerSerialNumRequest.getSerialNum();
                    if (issuer != null && serialNum != null) {
                        boolean found = false;
                        for (int i = 0; i < keyStores.length && !found; ++i) {
                            Enumeration<String> aliases = keyStores[i].aliases();
                            while (aliases.hasMoreElements() && !found) {
                                Certificate[] certificates;
                                X509Certificate eeCert;
                                String nextAlias = aliases.nextElement();
                                PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                                if (key == null || !(eeCert = (X509Certificate)(certificates = keyStores[i].getCertificateChain(nextAlias))[0]).getIssuerX500Principal().equals(issuer) || !eeCert.getSerialNumber().equals(serialNum)) continue;
                                privateKey = key;
                                certificateChain = certificates;
                                found = true;
                            }
                        }
                    }
                    break block22;
                }
                if (request instanceof PrivateKeyCallback.SubjectKeyIDRequest) {
                    PrivateKeyCallback.SubjectKeyIDRequest subjectKeyIDRequest = (PrivateKeyCallback.SubjectKeyIDRequest)request;
                    byte[] subjectKeyID = subjectKeyIDRequest.getSubjectKeyID();
                    if (subjectKeyID != null) {
                        boolean found = false;
                        X509CertSelector selector = new X509CertSelector();
                        selector.setSubjectKeyIdentifier(this.toDerOctetString(subjectKeyID));
                        for (int i = 0; i < keyStores.length && !found; ++i) {
                            Enumeration<String> aliases = keyStores[i].aliases();
                            while (aliases.hasMoreElements() && !found) {
                                Certificate[] certificates;
                                String nextAlias = aliases.nextElement();
                                PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                                if (key == null || !selector.match((certificates = keyStores[i].getCertificateChain(nextAlias))[0])) continue;
                                privateKey = key;
                                certificateChain = certificates;
                                found = true;
                            }
                        }
                    }
                    break block22;
                }
                if (request instanceof PrivateKeyCallback.DigestRequest) {
                    PrivateKeyCallback.DigestRequest digestRequest = (PrivateKeyCallback.DigestRequest)request;
                    byte[] digest = digestRequest.getDigest();
                    String algorithm = digestRequest.getAlgorithm();
                    KeyStore.PrivateKeyEntry privateKeyEntry = null;
                    if (digest == null) {
                        privateKeyEntry = this.getDefaultPrivateKeyEntry(keyStores);
                    } else {
                        if (algorithm == null) {
                            algorithm = DEFAULT_DIGEST_ALGORITHM;
                        }
                        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
                        privateKeyEntry = this.getPrivateKeyEntry(keyStores, messageDigest, digest);
                    }
                    if (privateKeyEntry != null) {
                        privateKey = privateKeyEntry.getPrivateKey();
                        certificateChain = privateKeyEntry.getCertificateChain();
                    }
                    break block22;
                }
                if (!_logger.isLoggable(Level.FINE)) break block22;
                _logger.log(Level.FINE, "invalid request type: " + request.getClass().getName());
            }
            catch (Exception e) {
                block23: {
                    try {
                        if (!_logger.isLoggable(Level.FINE)) break block23;
                        _logger.log(Level.FINE, "JASPIC: In PrivateKeyCallback Processor:  Error reading key !", e);
                    }
                    catch (Throwable throwable) {
                        privKeyCallback.setKey(privateKey, certificateChain);
                        throw throwable;
                    }
                }
                privKeyCallback.setKey(privateKey, certificateChain);
            }
        }
        privKeyCallback.setKey(privateKey, certificateChain);
    }

    private byte[] toDerOctetString(byte[] value) throws IOException {
        ByteArrayOutputStream subjectOutputStream = new ByteArrayOutputStream();
        subjectOutputStream.write(4);
        subjectOutputStream.write(this.length2Bytes(value.length));
        subjectOutputStream.write(value);
        return subjectOutputStream.toByteArray();
    }

    private byte[] length2Bytes(int length) {
        if (length <= 127) {
            return new byte[]{(byte)length};
        }
        int byteCount = 1;
        int lengthValue = length;
        while ((lengthValue >>>= 8) != 0) {
            ++byteCount;
        }
        byte[] lengthBytes = new byte[byteCount + 1];
        lengthBytes[0] = (byte)(byteCount | 0x80);
        int pos = 1;
        for (int i = (byteCount - 1) * 8; i >= 0; i -= 8) {
            lengthBytes[pos] = (byte)(length >> i);
            ++pos;
        }
        return lengthBytes;
    }

    private KeyStore.PrivateKeyEntry getDefaultPrivateKeyEntry(KeyStore[] keyStores) {
        Certificate[] certificates;
        PrivateKey privateKey;
        block4: {
            privateKey = null;
            certificates = null;
            try {
                for (int i = 0; i < keyStores.length && privateKey == null; ++i) {
                    Enumeration<String> aliases = keyStores[i].aliases();
                    while (aliases.hasMoreElements() && privateKey == null) {
                        String nextAlias = aliases.nextElement();
                        privateKey = null;
                        certificates = null;
                        PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                        if (key == null) continue;
                        privateKey = key;
                        certificates = keyStores[i].getCertificateChain(nextAlias);
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "Exception in getDefaultPrivateKeyEntry", e);
            }
        }
        return new KeyStore.PrivateKeyEntry(privateKey, certificates);
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(KeyStore[] kstores, MessageDigest md, byte[] digest) {
        PrivateKey privKey = null;
        Certificate[] certs = null;
        try {
            for (int i = 0; i < kstores.length && privKey == null; ++i) {
                Enumeration<String> aliases = kstores[i].aliases();
                while (aliases.hasMoreElements() && privKey == null) {
                    String nextAlias = aliases.nextElement();
                    privKey = null;
                    certs = null;
                    PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                    if (key == null) continue;
                    certs = kstores[i].getCertificateChain(nextAlias);
                    md.reset();
                    byte[] cDigest = md.digest(certs[0].getEncoded());
                    if (!Arrays.equals(digest, cDigest)) continue;
                    privKey = key;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception in getPrivateKeyEntry for Digest", e);
        }
        return new KeyStore.PrivateKeyEntry(privKey, certs);
    }

    private void processCertStore(CertStoreCallback certStoreCallback) {
        _logger.log(Level.FINE, "JASPIC: In CertStoreCallback Processor");
        KeyStore certStore = this.sslUtils.getMergedTrustStore();
        if (certStore == null) {
            certStoreCallback.setCertStore(null);
        }
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        try {
            if (certStore != null) {
                Enumeration<String> enu = certStore.aliases();
                while (enu.hasMoreElements()) {
                    String alias = enu.nextElement();
                    if (!certStore.isCertificateEntry(alias)) continue;
                    try {
                        Certificate cert = certStore.getCertificate(alias);
                        list.add(cert);
                    }
                    catch (KeyStoreException kse) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, "JASPIC: Cannot retrieve certificate for alias " + alias);
                    }
                }
            }
            CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
            CertStore certstore = CertStore.getInstance("Collection", ccsp);
            certStoreCallback.setCertStore(certstore);
        }
        catch (KeyStoreException kse) {
            _logger.log(Level.FINE, "JASPIC:  Cannot determine truststore aliases", kse);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException iape) {
            _logger.log(Level.FINE, "JASPIC:  Cannot instantiate CertStore", iape);
        }
    }

    private void processSecretKey(SecretKeyCallback secretKeyCallback) {
        String alias;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JASPIC: In SecretKeyCallback Processor");
        }
        if ((alias = ((SecretKeyCallback.AliasRequest)secretKeyCallback.getRequest()).getAlias()) != null) {
            try {
                PasswordAdapter passwordAdapter = null;
                passwordAdapter = SecurityServicesUtil.getInstance().isACC() ? new PasswordAdapter(System.getProperty(CLIENT_SECRET_KEYSTORE), System.getProperty(CLIENT_SECRET_KEYSTORE_PASSWORD).toCharArray()) : this.masterPasswordHelper.getMasterPasswordAdapter();
                secretKeyCallback.setKey(passwordAdapter.getPasswordSecretKeyForAlias(alias));
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JASPIC: In SecretKeyCallback Processor:  Error reading key ! for alias " + alias, e);
                }
                secretKeyCallback.setKey(null);
            }
        } else {
            secretKeyCallback.setKey(null);
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "jaspic.unsupportreadprinciple");
            }
        }
    }
}

