/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.glassfish.security.common.Role;

abstract class ConnectorStarter {
    protected final MBeanServer mMBeanServer;
    protected final String mHostName;
    protected final int mPort;
    protected final boolean mSecurityEnabled;
    private final ServiceLocator mHabitat;
    protected final BootAMXListener mBootListener;
    protected volatile JMXServiceURL mJMXServiceURL = null;
    protected volatile JMXConnectorServer mConnectorServer = null;

    protected static void debug(String s) {
        System.out.println(s);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.mJMXServiceURL;
    }

    public String hostname() throws UnknownHostException {
        if (this.mHostName.equals("")) {
            return Util.localhost();
        }
        if (this.mHostName.equals("*")) {
            return "0.0.0.0";
        }
        if (this.mHostName.contains(":") && !this.mHostName.startsWith("[")) {
            return "[" + this.mHostName + "]";
        }
        return this.mHostName;
    }

    ConnectorStarter(MBeanServer mbeanServer, String host, int port, boolean securityEnabled, ServiceLocator habitat, BootAMXListener bootListener) {
        this.mMBeanServer = mbeanServer;
        this.mHostName = host;
        this.mPort = port;
        this.mSecurityEnabled = securityEnabled;
        this.mHabitat = habitat;
        this.mBootListener = bootListener;
    }

    abstract JMXConnectorServer start() throws Exception;

    public JMXAuthenticator getAccessController() {
        return new JMXAuthenticator(){

            @Override
            public Subject authenticate(Object credentials) {
                JMXAuthenticator controller = (JMXAuthenticator)ConnectorStarter.this.mHabitat.getService(JMXAuthenticator.class, new Annotation[0]);
                Subject adminSubject = controller.authenticate(credentials);
                if (adminSubject != null) {
                    Set<PrincipalImpl> principals = adminSubject.getPrincipals(PrincipalImpl.class);
                    for (PrincipalImpl principal : principals) {
                        if (principal instanceof Group || principal instanceof Role) continue;
                        adminSubject.getPrincipals().add(new JMXPrincipal(principal.getName()));
                    }
                }
                return adminSubject;
            }
        };
    }

    public synchronized void stop() {
        try {
            if (this.mConnectorServer != null) {
                this.mConnectorServer.stop();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void ignore(Throwable t) {
    }

    protected boolean isSecurityEnabled() {
        return this.mSecurityEnabled;
    }
}

