/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import java.io.File;

public class SSLParams {
    private File trustStore;
    private String trustStorePwd;
    private String trustStoreType = "JKS";
    private String trustAlgorithm = "SunX509";
    private String keyAlgorithm;
    private String keyStoreType = "JKS";
    private String keyStorePassword;
    private File keyStore;
    private String protocol = "TLS";
    private String[] enabledCiphers = new String[5];
    private String[] enabledProtocols = new String[5];
    private String trustMaxCertLength;
    private String certNickname;
    private String clientAuthEnabled;
    private String clientAuth;
    private String crlFile;
    private String ssl3TlsCiphers;
    private Boolean tls12Enabled = true;
    private Boolean tls13Enabled = true;
    private Boolean tlsRollBackEnabled = false;
    private Boolean hstsEnabled = false;
    private Boolean hstsSubDomains = false;
    private Boolean hstsPreload = false;

    public SSLParams(File truststore, String trustStorePwd, String trustStoreType) {
        this.trustStore = truststore;
        this.trustStorePwd = trustStorePwd;
        this.trustStoreType = trustStoreType;
    }

    public SSLParams() {
    }

    public File getTrustStore() {
        if (this.trustStore != null) {
            return this.trustStore;
        }
        if (System.getProperty("javax.net.ssl.trustStore") != null) {
            return new File(System.getProperty("javax.net.ssl.trustStore"));
        }
        return null;
    }

    public String getTrustStorePassword() {
        if (this.trustStorePwd != null) {
            return this.trustStorePwd;
        }
        if (System.getProperty("javax.net.ssl.trustStorePassword") != null) {
            return System.getProperty("javax.net.ssl.trustStorePassword");
        }
        return null;
    }

    public String getTrustStoreType() {
        if (this.trustStoreType != null) {
            return this.trustStoreType;
        }
        if (System.getProperty("javax.net.ssl.trustStoreType") != null) {
            return System.getProperty("javax.net.ssl.trustStoreType");
        }
        return "JKS";
    }

    String getTrustMaxCertLength() {
        if (this.trustMaxCertLength == null) {
            return "5";
        }
        return this.trustMaxCertLength;
    }

    public String getTrustAlgorithm() {
        return this.trustAlgorithm;
    }

    public void setTrustAlgorithm(String algorithm) {
        this.trustAlgorithm = algorithm;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        this.enabledCiphers = enabledCiphers;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setTrustMaxCertLength(String maxLength) {
        this.trustMaxCertLength = maxLength;
    }

    public String getCertNickname() {
        return this.certNickname;
    }

    public void setCertNickname(String certNickname) {
        this.certNickname = certNickname;
    }

    public String getClientAuthEnabled() {
        return this.clientAuthEnabled;
    }

    public void setClientAuthEnabled(String clientAuthEnabled) {
        this.clientAuthEnabled = clientAuthEnabled;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getCrlFile() {
        return this.crlFile;
    }

    public void setCrlFile(String crlFile) {
        this.crlFile = crlFile;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String algorithm) {
        this.keyAlgorithm = algorithm;
    }

    public String getKeyStoreType() {
        if (this.keyStoreType == null) {
            this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
        }
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword == null ? System.getProperty("javax.net.ssl.keyStorePassword") : this.keyStorePassword;
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
    }

    public File getKeyStore() {
        return this.keyStore == null ? new File(System.getProperty("javax.net.ssl.keyStore")) : this.keyStore;
    }

    public void setKeyStore(String location) {
        this.keyStore = new File(location);
    }

    public String getSsl3TlsCiphers() {
        return this.ssl3TlsCiphers;
    }

    public void setSsl3TlsCiphers(String ssl3TlsCiphers) {
        this.ssl3TlsCiphers = ssl3TlsCiphers;
    }

    public Boolean getTls12Enabled() {
        return this.tls12Enabled;
    }

    public void setTls12Enabled(String tls12Enabled) {
        this.tls12Enabled = Boolean.parseBoolean(tls12Enabled);
    }

    public Boolean getTls13Enabled() {
        return this.tls13Enabled;
    }

    public void setTls13Enabled(String tls13Enabled) {
        this.tls13Enabled = Boolean.parseBoolean(tls13Enabled);
    }

    public Boolean getTlsRollbackEnabled() {
        return this.tlsRollBackEnabled;
    }

    public void setTlsRollbackEnabled(String tlsRollBackEnabled) {
        this.tlsRollBackEnabled = Boolean.parseBoolean(tlsRollBackEnabled);
    }

    public Boolean getHstsEnabled() {
        return this.hstsEnabled;
    }

    public void setHstsEnabled(String hstsEnabled) {
        this.hstsEnabled = Boolean.parseBoolean(hstsEnabled);
    }

    public Boolean getHstsSubDomains() {
        return this.hstsSubDomains;
    }

    public void setHstsSubDomains(Boolean hstsSubDomains) {
        this.hstsSubDomains = hstsSubDomains;
    }

    public Boolean getHstsPreload() {
        return this.hstsPreload;
    }

    public void setHstsPreload(Boolean hstsPreload) {
        this.hstsPreload = hstsPreload;
    }
}

