/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRED)
public class TransactionalInterceptorRequired
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.FINE, "AS-JTA-00009");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            boolean isTransactionStarted = false;
            if (this.getTransactionManager().getTransaction() == null) {
                _logger.log(Level.FINE, "AS-JTA-00010");
                try {
                    this.getTransactionManager().begin();
                    TransactionManager transactionManager = this.getTransactionManager();
                    if (transactionManager instanceof TransactionManagerHelper) {
                        ((TransactionManagerHelper)transactionManager).preInvokeTx(true);
                    }
                }
                catch (Exception exception) {
                    _logger.log(Level.FINE, "AS-JTA-00011", exception);
                    throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during begin " + exception, (Throwable)exception);
                }
                isTransactionStarted = true;
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                if (isTransactionStarted) {
                    try {
                        TransactionManager transactionManager = this.getTransactionManager();
                        if (transactionManager instanceof TransactionManagerHelper) {
                            ((TransactionManagerHelper)transactionManager).postInvokeTx(false, true);
                        }
                        if (this.getTransactionManager().getTransaction().getStatus() == 1) {
                            this.getTransactionManager().rollback();
                        } else {
                            this.getTransactionManager().commit();
                        }
                    }
                    catch (Exception exception) {
                        _logger.log(Level.FINE, "AS-JTA-00012", exception);
                        throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during commit " + exception, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

