/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public final class ClassGenerator {
    private static Method defineClassMethod;
    private static Method defineClassMethodSM;

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] b) {
        return ClassGenerator.defineClass(loader, className, b, 0, b.length);
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] b, int off, int len, ProtectionDomain protectionDomain) {
        try {
            return (Class)defineClassMethodSM.invoke((Object)loader, className, b, 0, len, protectionDomain);
        }
        catch (Exception e) {
            throw new ClassDefinitionException(className, loader, e);
        }
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] b, ProtectionDomain protectionDomain) {
        return ClassGenerator.defineClass(loader, className, b, 0, b.length, protectionDomain);
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] b, int off, int len) {
        try {
            return (Class)defineClassMethod.invoke((Object)loader, className, b, 0, len);
        }
        catch (Exception e) {
            throw new ClassDefinitionException(className, loader, e);
        }
    }

    static {
        try {
            PrivilegedExceptionAction<Void> action = () -> {
                Class<?> cl = Class.forName("java.lang.ClassLoader");
                String name = "defineClass";
                defineClassMethod = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClassMethod.setAccessible(true);
                defineClassMethodSM = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                defineClassMethodSM.setAccessible(true);
                return null;
            };
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            throw new Error("Could not initialize access to ClassLoader.defineClass method.", e);
        }
    }

    public static class ClassDefinitionException
    extends RuntimeException {
        private static final long serialVersionUID = -8955780830818904365L;

        ClassDefinitionException(String className, ClassLoader loader, Exception cause) {
            super("Could not define class '" + className + "' by the class loader: " + loader, cause);
        }
    }
}

