/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.lang.annotation.Annotation;
import java.security.ProtectionDomain;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.weld.ClassGenerator;
import org.glassfish.weld.WeldProxyException;
import org.jboss.weld.serialization.spi.ProxyServices;

public class ProxyServicesImpl
implements ProxyServices {
    ClassLoaderHierarchy clh;

    public ProxyServicesImpl(ServiceLocator services) {
        this.clh = (ClassLoaderHierarchy)services.getService(ClassLoaderHierarchy.class, new Annotation[0]);
    }

    private ClassLoader getClassLoaderforBean(Class<?> proxiedBeanType) {
        ClassLoader prxCL = proxiedBeanType.getClassLoader();
        boolean isAppCL = this.isApplicationClassLoader(prxCL);
        if (!isAppCL) {
            prxCL = this._getClassLoader();
        }
        return prxCL;
    }

    private boolean isApplicationClassLoader(ClassLoader prxCL) {
        boolean isAppCL = false;
        while (prxCL != null) {
            if (prxCL.equals(this.clh.getCommonClassLoader())) {
                isAppCL = true;
                break;
            }
            prxCL = prxCL.getParent();
        }
        return isAppCL;
    }

    private ClassLoader _getClassLoader() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        return tcl;
    }

    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        return this._getClassLoader().loadClass(classBinaryName);
    }

    public void cleanup() {
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        ClassLoader cl = this.getClassLoaderforBean(originalClass);
        if (protectionDomain == null) {
            return this.defineClass(cl, className, classBytes, off, len);
        }
        return this.defineClass(cl, className, classBytes, off, len, protectionDomain);
    }

    public Class<?> defineClass(Class<?> originalClass, String className, byte[] classBytes, int off, int len) throws ClassFormatError {
        return this.defineClass(originalClass, className, classBytes, off, len, null);
    }

    private Class<?> defineClass(ClassLoader loader, String className, byte[] classBytes, int off, int len) {
        try {
            return ClassGenerator.defineClass(loader, className, classBytes, 0, len);
        }
        catch (Exception e) {
            throw new WeldProxyException("Could not define class" + className, e);
        }
    }

    private Class<?> defineClass(ClassLoader loader, String className, byte[] classBytes, int off, int len, ProtectionDomain protectionDomain) {
        try {
            return ClassGenerator.defineClass(loader, className, classBytes, 0, len, protectionDomain);
        }
        catch (Exception e) {
            throw new WeldProxyException("Could not define class" + className, e);
        }
    }
}

