/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.util.cluster.SshAuthType;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class UpdateNodeRemoteCommand
implements AdminCommand {
    private static final Logger LOG = Logger.getLogger(UpdateNodeRemoteCommand.class.getName());
    @Inject
    private CommandRunner cr;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost", optional=true)
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    protected String remotePort;
    protected String remoteUser;
    protected String sshAuthType;
    protected String sshkeyfile;
    protected String sshkeypassphrase;
    protected String remotepassword;
    protected String windowsdomain;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    private static final String NL = System.lineSeparator();

    protected abstract void populateParameters();

    protected abstract RemoteType getType();

    protected abstract String getDefaultPort();

    protected final void executeInternal(AdminCommandContext context) {
        LOG.finest(() -> String.format("executeInternal(context=%s)", context));
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        Node node = null;
        Logger logger = context.getLogger();
        node = this.nodes.getNode(this.name);
        if (node == null) {
            String m = Strings.get("noSuchNode", this.name);
            logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        if (node.isDefaultLocalNode()) {
            String m = Strings.get("update.node.config.defaultnode", this.name);
            logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        this.populateParameters();
        try {
            NodeUtils nodeUtils = new NodeUtils(this.serviceLocator, logger);
            nodeUtils.validate(this.createValidationParameters(node));
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("node.ssh.invalid.params");
            if (this.force) {
                String m2 = Strings.get("update.node.ssh.continue.force");
                msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, e.getMessage(), m2}));
            }
            String m2 = Strings.get("update.node.ssh.not.updated");
            msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, m2, e.getMessage()}));
            report.setMessage(msg.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"DEFAULT", (Object)this.name);
        commandParameters.add((Object)"installdir", (Object)this.installdir);
        commandParameters.add((Object)"nodehost", (Object)this.nodehost);
        commandParameters.add((Object)"nodedir", (Object)this.nodedir);
        commandParameters.add((Object)"sshport", (Object)this.remotePort);
        commandParameters.add((Object)"sshuser", (Object)this.remoteUser);
        commandParameters.add((Object)"sshpassword", (Object)this.remotepassword);
        commandParameters.add((Object)"sshauthtype", (Object)this.sshAuthType);
        commandParameters.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        commandParameters.add((Object)"sshkeypassphrase", (Object)this.sshkeypassphrase);
        commandParameters.add((Object)"windowsdomain", (Object)this.windowsdomain);
        commandParameters.add((Object)"type", (Object)this.getType().toString());
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_update-node", report, context.getSubject());
        ci.parameters(commandParameters);
        ci.execute();
        if (StringUtils.ok((String)report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private ParameterMap createValidationParameters(Node node) {
        ParameterMap parameters = new ParameterMap();
        parameters.insert("DEFAULT", this.name);
        parameters.insert("type", this.getType().toString());
        parameters.insert("nodehost", this.nodehost, node.getNodeHost());
        parameters.insert("installdir", this.installdir, node.getInstallDir());
        parameters.insert("nodedir", this.nodedir, node.getNodeDir());
        parameters.insert("windowsdomain", this.windowsdomain, node.getWindowsDomain());
        SshConnector sshc = node.getSshConnector();
        parameters.insert("sshport", this.remotePort, this.getSupplier(sshc, () -> ((SshConnector)sshc).getSshPort()));
        SshAuth ssha = sshc.getSshAuth();
        parameters.insert("sshuser", this.remoteUser, this.getSupplier(ssha, () -> ((SshAuth)ssha).getUserName()));
        parameters.insert("sshauthtype", this.sshAuthType, this.getSupplier(ssha, () -> null));
        if (this.sshAuthType == null) {
            if (this.sshkeyfile == null && this.remotepassword == null) {
                parameters.insert("sshpassword", null, this.getSupplier(ssha, () -> ((SshAuth)ssha).getPassword()));
                parameters.insert("sshkeyfile", null, this.getSupplier(ssha, () -> ((SshAuth)ssha).getKeyfile()));
                parameters.insert("sshkeypassphrase", null, this.getSupplier(ssha, () -> ((SshAuth)ssha).getKeyPassphrase()));
            } else if (this.remotepassword != null) {
                parameters.insert("sshpassword", this.remotepassword, this.getSupplier(ssha, () -> ((SshAuth)ssha).getPassword()));
            } else {
                parameters.insert("sshkeyfile", this.sshkeyfile, this.getSupplier(ssha, () -> ((SshAuth)ssha).getKeyfile()));
                parameters.insert("sshkeypassphrase", this.sshkeypassphrase, this.getSupplier(ssha, () -> ((SshAuth)ssha).getKeyPassphrase()));
            }
        } else if (SshAuthType.KEY.name().equals(this.sshAuthType)) {
            parameters.insert("sshkeyfile", this.sshkeyfile, this.getSupplier(ssha, () -> ((SshAuth)ssha).getKeyfile()));
            parameters.insert("sshkeypassphrase", this.sshkeypassphrase, this.getSupplier(ssha, () -> ((SshAuth)ssha).getKeyPassphrase()));
        } else if (SshAuthType.PASSWORD.name().equals(this.sshAuthType)) {
            parameters.insert("sshpassword", this.remotepassword, this.getSupplier(ssha, () -> ((SshAuth)ssha).getPassword()));
        }
        return parameters;
    }

    private Supplier<String> getSupplier(Object getterOwner, Supplier<String> getter) {
        if (getterOwner == null) {
            return () -> null;
        }
        return () -> (String)getter.get();
    }
}

