/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.hazelcast.cp.exception.CPSubsystemException;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.lock.exception.LockOwnershipLostException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.util.DOLUtils;
import fish.payara.cluster.Clustered;
import fish.payara.cluster.DistributedLockType;
import fish.payara.micro.cdi.extension.cluster.ClusteredSingletonLookupImpl;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScoped;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.soteria.cdi.CdiUtils;

class ClusterScopeContext
implements Context {
    private static final Logger log = Logger.getLogger(ClusterScopeContext.class.getName());
    private final BeanManager beanManager;
    private final ClusteredSingletonLookupImpl clusteredLookup;

    public ClusterScopeContext(BeanManager beanManager, Deployment deployment) {
        this.beanManager = beanManager;
        Application app = (Application)deployment.getCurrentDeploymentContext().getModuleMetaData(Application.class);
        this.clusteredLookup = new ClusteredSingletonLookupImpl(beanManager, DOLUtils.getApplicationName((JndiNameEnvironment)app));
    }

    public Class<? extends Annotation> getScope() {
        return ClusterScoped.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TT> TT get(Contextual<TT> contextual, CreationalContext<TT> creationalContext) {
        Bean bean = (Bean)contextual;
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, bean);
        this.clusteredLookup.setClusteredSessionKeyIfNotSet(bean.getBeanClass(), clusteredAnnotation);
        boolean locked = ClusterScopeContext.lock(clusteredAnnotation, this.clusteredLookup.getDistributedLock());
        TT beanInstance = null;
        try {
            beanInstance = this.get(contextual);
            if (beanInstance == null) {
                beanInstance = this.getFromApplicationScoped(contextual, Optional.of(creationalContext));
                if (this.clusteredLookup.getClusteredSingletonMap().putIfAbsent((Object)ClusterScopeContext.getBeanName(bean, clusteredAnnotation), beanInstance) != null) {
                    bean.destroy(beanInstance, creationalContext);
                    beanInstance = this.get(contextual);
                }
            }
        }
        finally {
            if (locked && beanInstance == null) {
                ClusterScopeContext.unlock(clusteredAnnotation, this.clusteredLookup.getDistributedLock());
            }
        }
        return beanInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TT> TT get(Contextual<TT> contextual) {
        Bean bean = (Bean)contextual;
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, bean);
        String beanName = ClusterScopeContext.getBeanName(bean, clusteredAnnotation);
        this.clusteredLookup.setClusteredSessionKeyIfNotSet(bean.getBeanClass(), clusteredAnnotation);
        boolean locked = ClusterScopeContext.lock(clusteredAnnotation, this.clusteredLookup.getDistributedLock());
        Object beanInstance = null;
        try {
            beanInstance = this.clusteredLookup.getClusteredSingletonMap().get((Object)beanName);
            if (clusteredAnnotation.callPostConstructOnAttach() && beanInstance != null && this.getFromApplicationScoped(contextual, Optional.empty()) == null) {
                this.beanManager.getContext(ApplicationScoped.class).get(contextual, this.beanManager.createCreationalContext(contextual));
            }
        }
        finally {
            if (locked && beanInstance == null) {
                ClusterScopeContext.unlock(clusteredAnnotation, this.clusteredLookup.getDistributedLock());
            }
        }
        return (TT)beanInstance;
    }

    public boolean isActive() {
        return true;
    }

    private <TT> TT getFromApplicationScoped(Contextual<TT> contextual, Optional<CreationalContext<TT>> creationalContext) {
        if (creationalContext.isPresent()) {
            return (TT)this.beanManager.getContext(ApplicationScoped.class).get(contextual, creationalContext.get());
        }
        return (TT)this.beanManager.getContext(ApplicationScoped.class).get(contextual);
    }

    static <TT> String getBeanName(Bean<TT> bean, Clustered annotation) {
        try {
            return ClusterScopeContext.firstNonNull(annotation.keyName(), bean.getName(), bean.getBeanClass().getName());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not find the name for bean: " + bean.toString(), t);
        }
    }

    static <TT> Clustered getAnnotation(BeanManager beanManager, Bean<TT> bean) {
        return ClusterScopeContext.getAnnotation(beanManager, bean.getBeanClass());
    }

    static <TT> Clustered getAnnotation(BeanManager beanManager, Class<?> clazz) {
        return (Clustered)CdiUtils.getAnnotation((BeanManager)beanManager, clazz, Clustered.class).get();
    }

    static String firstNonNull(String ... items) {
        for (String i : items) {
            if (i == null || i.trim().isEmpty()) continue;
            return i;
        }
        throw new IllegalArgumentException("All elements were null.");
    }

    private static boolean lock(Clustered clusteredAnnotation, FencedLock lock) {
        if (clusteredAnnotation.lock() == DistributedLockType.LOCK && !lock.isLockedByCurrentThread()) {
            lock.lock();
            return true;
        }
        return false;
    }

    protected static void unlock(Clustered clusteredAnnotation, FencedLock lock) {
        if (clusteredAnnotation.lock() == DistributedLockType.LOCK) {
            try {
                if (lock.isLockedByCurrentThread()) {
                    lock.unlock();
                }
            }
            catch (CPSubsystemException | LockOwnershipLostException e) {
                log.log(Level.WARNING, "Distributed unlock failed", e);
            }
        }
    }
}

