/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.hazelcast.cp.IAtomicLong;
import fish.payara.cluster.Clustered;
import fish.payara.micro.cdi.extension.cluster.ClusterScopeContext;
import fish.payara.micro.cdi.extension.cluster.ClusteredSingletonLookupImpl;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScopedIntercepted;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.internal.api.Globals;

@Interceptor
@ClusterScopedIntercepted
@Priority(value=4000)
public class ClusterScopedInterceptor
implements Serializable {
    private final BeanManager beanManager = CDI.current().getBeanManager();
    private transient ClusteredSingletonLookupImpl clusteredLookup;
    private static final long serialVersionUID = 1L;

    public ClusterScopedInterceptor() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object refreshAndUnlock(InvocationContext invocationContext) throws Exception {
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            Class<?> beanClass = invocationContext.getMethod().getDeclaringClass();
            Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, beanClass);
            this.refresh(beanClass, invocationContext.getTarget());
            this.clusteredLookup.setClusteredSessionKeyIfNotSet(beanClass, clusteredAnnotation);
            ClusterScopeContext.unlock(clusteredAnnotation, this.clusteredLookup.getDistributedLock());
        }
    }

    @PostConstruct
    Object postConstruct(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass = invocationContext.getTarget().getClass().getSuperclass();
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, beanClass);
        this.clusteredLookup.setClusteredSessionKeyIfNotSet(beanClass, clusteredAnnotation);
        this.clusteredLookup.getClusteredUsageCount().incrementAndGet();
        return invocationContext.proceed();
    }

    @PreDestroy
    Object preDestroy(InvocationContext invocationContext) throws Exception {
        Class<?> beanClass = invocationContext.getTarget().getClass().getSuperclass();
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, beanClass);
        this.clusteredLookup.setClusteredSessionKeyIfNotSet(beanClass, clusteredAnnotation);
        IAtomicLong count = this.clusteredLookup.getClusteredUsageCount();
        if (count.decrementAndGet() <= 0L) {
            this.clusteredLookup.destroy();
        } else if (!clusteredAnnotation.callPreDestroyOnDetach()) {
            return null;
        }
        return invocationContext.proceed();
    }

    private void refresh(Class<?> beanClass, Object instance) {
        Set managedBeans = this.beanManager.getBeans(beanClass, new Annotation[0]);
        if (managedBeans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans found for " + beanClass);
        }
        Bean bean = (Bean)managedBeans.iterator().next();
        String beanName = ClusterScopeContext.getBeanName(bean, ClusterScopeContext.getAnnotation(this.beanManager, bean));
        this.clusteredLookup.getClusteredSingletonMap().set((Object)beanName, instance);
    }

    private void init() {
        String moduleName = ((InvocationManager)Globals.getDefaultHabitat().getService(InvocationManager.class, new Annotation[0])).getCurrentInvocation().getAppName();
        this.clusteredLookup = new ClusteredSingletonLookupImpl(this.beanManager, moduleName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

