/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.session.PersistenceType;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.ha.authenticator.HASingleSignOn;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class HASSOFactory
implements SSOFactory {
    private static final String STORE_NAME = "SSOStore";
    private static BackingStore<String, HASingleSignOnEntryMetadata> ssoEntryMetadataBackingStore = null;
    @Inject
    private ServiceLocator services;
    @Inject
    private JavaEEIOUtils ioUtils;
    @Inject
    private ServerConfigLookup serverConfigLookup;

    @Override
    public GlassFishSingleSignOn createSingleSignOnValve(String virtualServerName) {
        PersistenceType persistenceType = this.serverConfigLookup.getPersistenceTypeFromConfig();
        String persistenceTypeStr = persistenceType != null ? persistenceType.getType() : PersistenceType.HAZELCAST.getType();
        return new HASingleSignOn(this.ioUtils, HASSOFactory.getSsoEntryMetadataBackingStore(persistenceTypeStr, STORE_NAME, this.services));
    }

    protected static synchronized BackingStore<String, HASingleSignOnEntryMetadata> getSsoEntryMetadataBackingStore(String persistenceType, String storeName, ServiceLocator services) {
        if (ssoEntryMetadataBackingStore == null) {
            BackingStoreFactory factory = (BackingStoreFactory)services.getService(BackingStoreFactory.class, persistenceType, new Annotation[0]);
            BackingStoreConfiguration conf = new BackingStoreConfiguration();
            String clusterName = "";
            String instanceName = "";
            HazelcastCore hazelcast = (HazelcastCore)services.getService(HazelcastCore.class, new Annotation[0]);
            if (hazelcast.isEnabled()) {
                clusterName = hazelcast.getMemberGroup();
                instanceName = hazelcast.getMemberName();
            }
            conf.setStoreName(storeName).setClusterName(clusterName).setInstanceName(instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(HASingleSignOnEntryMetadata.class);
            try {
                ssoEntryMetadataBackingStore = factory.createBackingStore(conf);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return ssoEntryMetadataBackingStore;
    }
}

