/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.util.Enumerator;
import org.glassfish.web.ha.session.management.BaseHASession;
import org.glassfish.web.ha.session.management.HAStoreBase;
import org.glassfish.web.ha.session.management.SessionAttributeState;

public class ModifiedAttributeHASession
extends BaseHASession {
    private static final Logger _logger = HAStoreBase._logger;
    private transient Map<String, SessionAttributeState> _attributeStates = new ConcurrentHashMap<String, SessionAttributeState>();
    private transient boolean _dirtyFlag = false;

    public ModifiedAttributeHASession(Manager manager) {
        super(manager);
    }

    public List<String> getDeletedAttributes() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (Map.Entry<String, SessionAttributeState> entry : this._attributeStates.entrySet()) {
            SessionAttributeState nextAttrState = entry.getValue();
            String nextAttrName = entry.getKey();
            if (!nextAttrState.isDeleted() || !nextAttrState.isPersistent()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    public List<String> getModifiedAttributes() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (Map.Entry<String, SessionAttributeState> entry : this._attributeStates.entrySet()) {
            SessionAttributeState nextAttrState = entry.getValue();
            String nextAttrName = entry.getKey();
            if (!nextAttrState.isDirty() || !nextAttrState.isPersistent() || nextAttrState.isDeleted()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    public List<String> getAddedAttributes() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (Map.Entry<String, SessionAttributeState> entry : this._attributeStates.entrySet()) {
            SessionAttributeState nextAttrState = entry.getValue();
            String nextAttrName = entry.getKey();
            if (nextAttrState.isPersistent() || nextAttrState.isDirty()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    public List<String> getAddedAttributesPrevious() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (Map.Entry<String, SessionAttributeState> entry : this._attributeStates.entrySet()) {
            SessionAttributeState nextAttrState = entry.getValue();
            String nextAttrName = entry.getKey();
            if (nextAttrState.isPersistent()) continue;
            resultList.add(nextAttrName);
        }
        return resultList;
    }

    void clearAttributeStates() {
        if (this._attributeStates == null) {
            this._attributeStates = new ConcurrentHashMap<String, SessionAttributeState>();
        }
        this._attributeStates.clear();
    }

    public void privateResetAttributeState() {
        this.resetAttributeState();
    }

    void resetAttributeState() {
        this.clearAttributeStates();
        Enumeration attrNames = this.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String nextAttrName = (String)attrNames.nextElement();
            SessionAttributeState nextAttrState = SessionAttributeState.createPersistentAttribute();
            this._attributeStates.put(nextAttrName, nextAttrState);
        }
        this.setDirty(false);
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        SessionAttributeState attributeState = this.getAttributeState(name);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ModifiedAttributeHASession>>setAttribute name=" + name + " attributeState=" + attributeState);
        }
        if (value == null) {
            if (attributeState != null) {
                if (attributeState.isPersistent()) {
                    attributeState.setDeleted(true);
                } else {
                    this.removeAttributeState(name);
                }
            }
        } else if (attributeState == null) {
            SessionAttributeState newAttrState = new SessionAttributeState();
            this._attributeStates.put(name, newAttrState);
        } else if (attributeState.isDeleted()) {
            attributeState.setDeleted(false);
        } else if (attributeState.isPersistent()) {
            attributeState.setDirty(true);
        }
        this.setDirty(true);
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        SessionAttributeState attributeState = this.getAttributeState(name);
        if (attributeState != null) {
            if (attributeState.isPersistent()) {
                attributeState.setDeleted(true);
            } else {
                this.removeAttributeState(name);
            }
        }
        this.setDirty(true);
    }

    SessionAttributeState getAttributeState(String attributeName) {
        return this._attributeStates.get(attributeName);
    }

    void setAttributeStatePersistent(String attributeName, boolean persistent) {
        SessionAttributeState attrState = this._attributeStates.get(attributeName);
        if (attrState == null) {
            attrState = new SessionAttributeState();
            attrState.setPersistent(persistent);
            this._attributeStates.put(attributeName, attrState);
        } else {
            attrState.setPersistent(persistent);
        }
    }

    void setAttributeStateDirty(String attributeName, boolean dirty) {
        SessionAttributeState attrState = this._attributeStates.get(attributeName);
        if (attrState == null) {
            attrState = new SessionAttributeState();
            attrState.setDirty(dirty);
            this._attributeStates.put(attributeName, attrState);
        } else {
            attrState.setDirty(dirty);
        }
    }

    void removeAttributeState(String attributeName) {
        this._attributeStates.remove(attributeName);
    }

    @Override
    public boolean isDirty() {
        return this._dirtyFlag;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this._dirtyFlag = isDirty;
    }

    Enumeration<String> privateGetAttributeList() {
        return new Enumerator(new ArrayList(this.attributes.keySet()));
    }
}

