/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.config.validators;

import com.sun.enterprise.config.serverbeans.ResourcePool;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.connectors.config.validators.ConnectionPoolErrorMessages;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.validators.JdbcConnectionPoolConstraint;

public class JdbcConnectionPoolValidator
implements ConstraintValidator<JdbcConnectionPoolConstraint, ResourcePool> {
    protected ConnectionPoolErrorMessages poolFaults;

    public void initialize(JdbcConnectionPoolConstraint constraint) {
        this.poolFaults = constraint.value();
    }

    public boolean isValid(ResourcePool pool, ConstraintValidatorContext context) {
        if (!JdbcConnectionPool.class.isInstance(pool)) {
            return true;
        }
        if (this.poolFaults == null) {
            return true;
        }
        JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
        switch (this.poolFaults) {
            case POOL_SIZE_STEADY: {
                return this.validateSteadyPoolSize(jdbcPool);
            }
            case POOL_SIZE_MAX: {
                return this.validateMaxPoolSize(jdbcPool);
            }
            case STMT_WRAPPING_DISABLED: {
                return this.validateWrapping(jdbcPool);
            }
            case TABLE_NAME_MANDATORY: {
                return this.validateTableConnectionValidation(jdbcPool);
            }
            case CUSTOM_VALIDATION_CLASS_NAME_MANDATORY: {
                return this.validateClassConnectionValidation(jdbcPool);
            }
            case RES_TYPE_MANDATORY: {
                return this.validateResourceType(jdbcPool);
            }
        }
        return true;
    }

    private boolean validateSteadyPoolSize(JdbcConnectionPool jdbcPool) {
        Integer steadyPoolSize = this.getSteadyPoolSize(jdbcPool);
        return steadyPoolSize != null && steadyPoolSize >= 0;
    }

    private boolean validateMaxPoolSize(JdbcConnectionPool jdbcPool) {
        Integer steadyPoolSize = this.getSteadyPoolSize(jdbcPool);
        String propertyValue = jdbcPool.getMaxPoolSize();
        String value = propertyValue == null ? "32" : propertyValue;
        Integer maxPoolSize = this.toInteger(this.resolve(value));
        if (maxPoolSize == null || maxPoolSize < 1) {
            return false;
        }
        return steadyPoolSize == null || steadyPoolSize <= maxPoolSize;
    }

    private boolean validateWrapping(JdbcConnectionPool jdbcPool) {
        String stmtCacheSize = jdbcPool.getStatementCacheSize();
        String stmtLeakTimeout = jdbcPool.getStatementLeakTimeoutInSeconds();
        boolean wrappingEnabled = this.isTrue(jdbcPool.getWrapJdbcObjects());
        if (!wrappingEnabled && this.isPositiveInt(stmtCacheSize)) {
            return false;
        }
        if (!wrappingEnabled && this.isPositiveInt(stmtLeakTimeout)) {
            return false;
        }
        return wrappingEnabled || !this.isTrue(jdbcPool.getStatementLeakReclaim());
    }

    private boolean validateTableConnectionValidation(JdbcConnectionPool jdbcPool) {
        return !this.isTrue(jdbcPool.getIsConnectionValidationRequired()) || !"table".equals(jdbcPool.getConnectionValidationMethod()) || !this.isEmpty(jdbcPool.getValidationTableName());
    }

    private boolean validateClassConnectionValidation(JdbcConnectionPool jdbcPool) {
        return !this.isTrue(jdbcPool.getIsConnectionValidationRequired()) || !"custom-validation".equals(jdbcPool.getConnectionValidationMethod()) || !this.isEmpty(jdbcPool.getValidationClassname());
    }

    private boolean validateResourceType(JdbcConnectionPool jdbcPool) {
        String resType = jdbcPool.getResType();
        String dsClassName = jdbcPool.getDatasourceClassname();
        String driverClassName = jdbcPool.getDriverClassname();
        if (resType == null) {
            if (this.isEmpty(dsClassName) && this.isEmpty(driverClassName)) {
                return false;
            }
            if (dsClassName != null && driverClassName != null) {
                return false;
            }
        } else if (resType.equals("javax.sql.DataSource") || resType.equals("javax.sql.ConnectionPoolDataSource") || resType.equals("javax.sql.XADataSource") ? this.isEmpty(dsClassName) : resType.equals("java.sql.Driver") && this.isEmpty(driverClassName)) {
            return false;
        }
        return true;
    }

    private Integer getSteadyPoolSize(JdbcConnectionPool jdbcPool) {
        String property = jdbcPool.getSteadyPoolSize();
        return this.toInteger(this.resolve(property == null ? "8" : property));
    }

    private String resolve(String propertyValue) {
        if (propertyValue.startsWith("$")) {
            return this.getParsedVariable(propertyValue.substring(2, propertyValue.length() - 1));
        }
        return propertyValue;
    }

    private String getParsedVariable(String variableToRetrieve) {
        String[] variableReference = variableToRetrieve.split("=");
        if (variableReference.length == 1) {
            return System.getProperty(variableReference[0]);
        }
        String variableToFind = variableReference[1];
        switch (variableReference[0]) {
            case "ENV": {
                String varValue = System.getenv(variableToFind);
                if (this.isEmpty(varValue)) break;
                return varValue;
            }
            case "MPCONFIG": {
                Config config = ConfigProvider.getConfig();
                String varValue = (String)config.getValue(variableToFind, String.class);
                if (this.isEmpty(varValue)) break;
                return varValue;
            }
        }
        return null;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private boolean isPositiveInt(String value) {
        try {
            return !this.isEmpty(value) && Integer.parseInt(value) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isTrue(String value) {
        return Boolean.parseBoolean(value);
    }

    private Integer toInteger(String resolvedValue) {
        if (this.isEmpty(resolvedValue)) {
            return null;
        }
        try {
            return Integer.valueOf(resolvedValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

