/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.internal.notification.TimeUtil;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckTask;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckCleanupTask;
import fish.payara.nucleus.healthcheck.HistoricHealthCheckEventStore;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.events.PayaraHealthCheckServiceEvents;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="healthcheck-core")
@RunLevel(value=10)
public class HealthCheckService
implements EventListener,
ConfigListener,
MonitoringDataSource {
    private static final Logger logger = Logger.getLogger(HealthCheckService.class.getCanonicalName());
    @Inject
    @Named(value="default-instance-name")
    @Optional
    HealthCheckServiceConfiguration configuration;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Events events;
    @Inject
    ServerContext server;
    @Inject
    ServerEnvironment env;
    @Inject
    Transactions transactions;
    @Inject
    private HistoricHealthCheckEventStore healthCheckEventStore;
    @Inject
    private PayaraExecutorService executor;
    private Set<String> enabledNotifiers = new LinkedHashSet<String>();
    private Map<String, HealthCheckTask> registeredTasks = new HashMap<String, HealthCheckTask>();
    private boolean enabled;
    private boolean historicalTraceEnabled;
    private Integer historicalTraceStoreSize;
    private Long historicalTraceStoreTimeout;
    private ScheduledFuture<?> historicalTraceTask;
    private Set<ScheduledFuture<?>> scheduledCheckers;

    public void collect(MonitoringDataCollector rootCollector) {
        MonitoringDataCollector health = rootCollector.in((CharSequence)"health");
        for (Map.Entry<String, HealthCheckTask> task : this.registeredTasks.entrySet()) {
            HealthCheckResultStatus status;
            BaseHealthCheck check = task.getValue().getCheck();
            if (!check.isReady() || check.getChecksDone() <= 0 || (status = check.getMostRecentCumulativeStatus()) == null) continue;
            health.collect((CharSequence)task.getKey(), (long)status.getLevel());
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapHealthCheck();
        }
        this.transactions.addListenerForType(HealthCheckServiceConfiguration.class, (ConfigListener)this);
    }

    public void registerCheck(String name, BaseHealthCheck check) {
        this.registeredTasks.put(name, new HealthCheckTask(name, check));
    }

    @PostConstruct
    void postConstruct() {
        this.events.register((EventListener)this);
        this.configuration = (HealthCheckServiceConfiguration)this.habitat.getService(HealthCheckServiceConfiguration.class, new Annotation[0]);
        if (this.configuration != null) {
            if (Boolean.parseBoolean(this.configuration.getEnabled())) {
                this.enabled = true;
            }
            this.historicalTraceEnabled = Boolean.valueOf(this.configuration.getHistoricalTraceEnabled());
            String historicalTraceStoreSizeConfig = this.configuration.getHistoricalTraceStoreSize();
            if (historicalTraceStoreSizeConfig != null) {
                this.historicalTraceStoreSize = Integer.parseInt(historicalTraceStoreSizeConfig);
                String historicalTraceStoreTimeLimit = this.configuration.getHistoricalTraceStoreTimeout();
                if (historicalTraceStoreTimeLimit != null) {
                    this.historicalTraceStoreTimeout = TimeUtil.setStoreTimeLimit((String)historicalTraceStoreTimeLimit);
                }
            }
        }
    }

    public void bootstrapHealthCheck() {
        if (this.configuration != null) {
            if (this.enabled) {
                this.scheduledCheckers = new HashSet();
                this.executeTasks();
                if (this.historicalTraceEnabled) {
                    this.healthCheckEventStore.initialize(this.historicalTraceStoreSize);
                    if (this.historicalTraceStoreTimeout != null && this.historicalTraceStoreTimeout > 0L) {
                        long period = this.historicalTraceStoreTimeout > 500L ? 500L : this.historicalTraceStoreTimeout;
                        this.historicalTraceTask = this.executor.scheduleAtFixedRate((Runnable)new HistoricHealthCheckCleanupTask(this.historicalTraceStoreTimeout), 0L, period, TimeUnit.SECONDS);
                    }
                }
                logger.info("Payara Health Check Service Started.");
            }
            this.bootstrapNotifierList();
        }
    }

    public synchronized void bootstrapNotifierList() {
        this.enabledNotifiers.clear();
        if (this.configuration.getNotifierList() != null) {
            this.configuration.getNotifierList().forEach(this.enabledNotifiers::add);
        }
    }

    private void executeTasks() {
        for (String registeredTaskKey : this.registeredTasks.keySet()) {
            HealthCheckTask registeredTask = this.registeredTasks.get(registeredTaskKey);
            Object healthCheckExecutionOptions = registeredTask.getCheck().getOptions();
            logger.info("Scheduling Health Check for task: " + registeredTask.getName());
            if (((HealthCheckExecutionOptions)healthCheckExecutionOptions).isEnabled()) {
                ScheduledFuture checker = this.executor.scheduleAtFixedRate((Runnable)registeredTask, 0L, ((HealthCheckExecutionOptions)healthCheckExecutionOptions).getTime(), ((HealthCheckExecutionOptions)healthCheckExecutionOptions).getUnit());
                if (this.scheduledCheckers != null) {
                    this.scheduledCheckers.add(checker);
                }
            }
            this.exposeToMicroProfileHealthEndPoint((HealthCheckExecutionOptions)healthCheckExecutionOptions, registeredTask);
        }
    }

    private void exposeToMicroProfileHealthEndPoint(HealthCheckExecutionOptions healthCheckExecutionOptions, HealthCheckTask registeredTask) {
        if (healthCheckExecutionOptions.isEnabled() && healthCheckExecutionOptions.isAddToMicroProfileHealthCheck()) {
            this.events.send(new EventListener.Event(PayaraHealthCheckServiceEvents.HEALTHCHECK_SERVICE_CHECKER_ADD_TO_MICROPROFILE_HEALTH, (Object)registeredTask));
        } else {
            this.events.send(new EventListener.Event(PayaraHealthCheckServiceEvents.HEALTHCHECK_SERVICE_CHECKER_REMOVE_FROM_MICROPROFILE_HEALTH, (Object)registeredTask));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled && !enabled.booleanValue()) {
            this.enabled = false;
            this.shutdownHealthCheck();
        } else if (!this.enabled && enabled.booleanValue()) {
            this.enabled = true;
            this.bootstrapHealthCheck();
        } else if (this.enabled && enabled.booleanValue()) {
            this.shutdownHealthCheck();
            this.bootstrapHealthCheck();
        }
    }

    public void reboot() {
        this.shutdownHealthCheck();
        if (this.configuration == null) {
            this.configuration = (HealthCheckServiceConfiguration)this.server.getConfigBean().getConfig().getExtensionByType(HealthCheckServiceConfiguration.class);
        }
        if (Boolean.valueOf(this.configuration.getEnabled()).booleanValue()) {
            this.bootstrapHealthCheck();
        }
    }

    public void shutdownHealthCheck() {
        Logger.getLogger(HealthCheckService.class.getName()).log(Level.INFO, "Payara Health Check Service is shutdown.");
        if (this.historicalTraceTask != null) {
            this.historicalTraceTask.cancel(false);
            this.historicalTraceTask = null;
        }
        if (this.scheduledCheckers != null) {
            for (ScheduledFuture<?> scheduledChecker : this.scheduledCheckers) {
                scheduledChecker.cancel(false);
            }
            this.scheduledCheckers.clear();
        }
        this.events.send(new EventListener.Event(PayaraHealthCheckServiceEvents.HEALTHCHECK_SERVICE_DISABLED));
    }

    public BaseHealthCheck getCheck(String serviceName) {
        HealthCheckTask task = this.registeredTasks.get(serviceName);
        return task == null ? null : task.getCheck();
    }

    public HealthCheckServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HealthCheckServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isHistoricalTraceEnabled() {
        return this.historicalTraceEnabled;
    }

    public void setHistoricalTraceEnabled(boolean historicalTraceEnabled) {
        this.historicalTraceEnabled = historicalTraceEnabled;
    }

    public Integer getHistoricalTraceStoreSize() {
        return this.historicalTraceStoreSize;
    }

    public void setHistoricalTraceStoreSize(Integer historicalTraceStoreSize) {
        this.historicalTraceStoreSize = historicalTraceStoreSize;
    }

    public void setHistoricalTraceStoreTimeout(long historicalTraceStoreTimeout) {
        this.historicalTraceStoreTimeout = historicalTraceStoreTimeout;
    }

    public Set<String> getEnabledNotifiers() {
        return this.enabledNotifiers;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        boolean isCurrentInstanceMatchTarget = false;
        if (this.env.isInstance()) {
            isCurrentInstanceMatchTarget = true;
        } else {
            for (PropertyChangeEvent pe : events) {
                ConfigBeanProxy proxy;
                for (proxy = (ConfigBeanProxy)pe.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
                }
                if (proxy == null || !((Config)proxy).isDas()) continue;
                isCurrentInstanceMatchTarget = true;
                break;
            }
        }
        if (isCurrentInstanceMatchTarget) {
            return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                    if (changedType.equals(HealthCheckServiceConfiguration.class)) {
                        HealthCheckService.this.configuration = (HealthCheckServiceConfiguration)changedInstance;
                    }
                    return null;
                }
            }, (Logger)logger);
        }
        return null;
    }
}

