/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

public final class TokenValue
implements Comparable {
    public final String token;
    public final String value;
    public final String preDelimiter;
    public final String postDelimiter;
    public final String delimitedToken;
    public static final String DEFAULT_DELIMITER = "%%%";

    public TokenValue(String token, String value) {
        this(token, value, DEFAULT_DELIMITER);
    }

    public TokenValue(String token, String value, String delimiter) {
        this(token, value, delimiter, delimiter);
    }

    public TokenValue(String token, String value, String preDelimiter, String postDelimiter) {
        if (token == null || value == null || preDelimiter == null || postDelimiter == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        this.token = token;
        this.value = this.escapeBackslashes(value);
        this.preDelimiter = preDelimiter;
        this.postDelimiter = postDelimiter;
        this.delimitedToken = preDelimiter + token + postDelimiter;
    }

    public TokenValue(TokenValue other) {
        this.token = other.token;
        this.value = other.value;
        this.preDelimiter = other.preDelimiter;
        this.postDelimiter = other.postDelimiter;
        this.delimitedToken = other.delimitedToken;
    }

    public int compareTo(Object other) {
        TokenValue otherTokenValue = (TokenValue)other;
        return this.token.compareTo(otherTokenValue.token);
    }

    public boolean equals(Object other) {
        boolean same = false;
        if (other instanceof TokenValue) {
            same = this.delimitedToken.equals(((TokenValue)other).delimitedToken) && this.value.equals(((TokenValue)other).value);
        }
        return same;
    }

    public int hashCode() {
        int result = 43;
        result = 17 * result + this.token.hashCode();
        result = 17 * result + this.preDelimiter.hashCode();
        result = 17 * result + this.postDelimiter.hashCode();
        result = 17 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return this.delimitedToken + "=" + this.value;
    }

    private String escapeBackslashes(String anyString) {
        int BACK_SLASH = 92;
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < anyString.length(); ++i) {
            char ch = anyString.charAt(i);
            escaped.append(ch);
            if (ch != '\\') continue;
            escaped.append('\\');
        }
        return escaped.toString();
    }
}

