/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="update-resource-ref")
@I18n(value="update.resource.ref")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="update-resource-ref", description="Update a Resource Reference on a given target")})
public class UpdateResourceRef
implements AdminCommand {
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(UpdateResourceRef.class);
    @Param(primary=true)
    private String name;
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(optional=true)
    private Boolean enabled = null;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        DeploymentGroup dg;
        Cluster cluster;
        Config config;
        final ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ArrayList<ResourceRef> resourceRefsToChange = new ArrayList<ResourceRef>();
        Server server = this.domain.getServerNamed(this.target);
        if (server != null) {
            ResourceRef serverResourceRef = server.getResourceRef(this.name);
            if (serverResourceRef == null) {
                report.failure(logger, LOCAL_STRINGS.getLocalString("resource.ref.not.exists", "Target {1} does not have a reference to resource {0}.", new Object[]{this.name, this.target}));
                return;
            }
            resourceRefsToChange.add(serverResourceRef);
        }
        if ((config = this.domain.getConfigNamed(this.target)) != null) {
            ResourceRef configResourceRef = config.getResourceRef(this.name);
            if (configResourceRef == null) {
                report.failure(logger, LOCAL_STRINGS.getLocalString("resource.ref.not.exists", "Target {1} does not have a reference to resource {0}.", new Object[]{this.name, this.target}));
                return;
            }
            resourceRefsToChange.add(configResourceRef);
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            ResourceRef clusterResourceRef = cluster.getResourceRef(this.name);
            if (clusterResourceRef == null) {
                report.failure(logger, LOCAL_STRINGS.getLocalString("resource.ref.not.exists", "Target {1} does not have a reference to resource {0}.", new Object[]{this.name, this.target}));
                return;
            }
            resourceRefsToChange.add(clusterResourceRef);
            for (Server instance : cluster.getInstances()) {
                ResourceRef instanceResourceRef = instance.getResourceRef(this.name);
                if (instanceResourceRef == null) continue;
                resourceRefsToChange.add(instanceResourceRef);
            }
        }
        if ((dg = this.domain.getDeploymentGroupNamed(this.target)) != null) {
            ResourceRef ref = dg.getResourceRef(this.name);
            if (ref == null) {
                report.failure(logger, LOCAL_STRINGS.getLocalString("resource.ref.not.exists", "Target {1} does not have a reference to resource {0}.", new Object[]{this.name, this.target}));
                return;
            }
            resourceRefsToChange.add(ref);
            for (Server instance : dg.getInstances()) {
                ResourceRef instanceResourceRef = instance.getResourceRef(this.name);
                if (instanceResourceRef == null) continue;
                resourceRefsToChange.add(instanceResourceRef);
            }
        }
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                    for (ConfigBeanProxy proxy : params) {
                        if (!(proxy instanceof ResourceRef)) continue;
                        ResourceRef resourceRefProxy = (ResourceRef)proxy;
                        if (UpdateResourceRef.this.enabled == null) continue;
                        resourceRefProxy.setEnabled(UpdateResourceRef.this.enabled.toString());
                    }
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return true;
                }
            }, (ConfigBeanProxy[])((ConfigBeanProxy[])resourceRefsToChange.toArray(new ResourceRef[0])));
        }
        catch (TransactionFailure ex) {
            report.failure(logger, ex.getLocalizedMessage());
        }
    }
}

