/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification;

import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.internal.notification.PayaraNotifierConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public final class NotifierUtils {
    private NotifierUtils() {
    }

    public static final String getNotifierName(ActiveDescriptor<?> descriptor) {
        String name = descriptor.getName();
        if (name == null) {
            name = descriptor.getClassAnalysisName();
        }
        if (name == null) {
            name = descriptor.getImplementationClass().getSimpleName();
        }
        return name;
    }

    public static final Set<String> getNotifierNames(ServiceLocator serviceLocator) {
        List notifierHandles = serviceLocator.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        HashSet<String> names = new HashSet<String>();
        for (ServiceHandle handle : notifierHandles) {
            names.add(NotifierUtils.getNotifierName(handle.getActiveDescriptor()));
        }
        return names;
    }

    public static <C extends PayaraNotifierConfiguration> Class<C> getConfigurationClass(Class<?> notifierClass) {
        ParameterizedType genericSuperclass = (ParameterizedType)notifierClass.getGenericSuperclass();
        return (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    public static String convertToCamelCase(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim().replaceAll("^[^a-zA-Z0-9]+", "").replaceAll("[^a-zA-Z0-9]+$", "")).isEmpty()) {
            return string;
        }
        Object result = "";
        boolean upperCaseNextCharacter = false;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isWhitespace(ch) || !Character.isAlphabetic(ch) && !Character.isDigit(ch)) {
                upperCaseNextCharacter = true;
                continue;
            }
            if (upperCaseNextCharacter) {
                upperCaseNextCharacter = false;
                result = (String)result + Character.toUpperCase(ch);
                continue;
            }
            result = (String)result + Character.toLowerCase(ch);
        }
        return result;
    }
}

