/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification;

import java.util.concurrent.TimeUnit;

public class TimeUtil {
    public static final int CLEANUP_TASK_FIVE_MIN_PERIOD = 500;
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private static long ONE_SEC = 1000L;
    private static long ONE_MIN = 60L * ONE_SEC;

    public static long setStoreTimeLimit(String timeLimit) {
        long value;
        block10: {
            value = 0L;
            if (timeLimit != null) {
                try {
                    value = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException nfe) {
                    int i;
                    for (i = 0; i < timeLimit.length() && Character.isDigit(timeLimit.charAt(i)); ++i) {
                    }
                    if (i <= 0) break block10;
                    value = Integer.parseInt(timeLimit.substring(0, i));
                    char multiplier = timeLimit.charAt(i);
                    switch (multiplier) {
                        case 's': {
                            value *= 1L;
                            break;
                        }
                        case 'm': {
                            value *= 60L;
                            break;
                        }
                        case 'h': {
                            value *= 3600L;
                            break;
                        }
                        case 'd': {
                            value *= 86400L;
                            break;
                        }
                    }
                }
            }
        }
        return value;
    }

    public static String prettyPrintDuration(long value) {
        long minutes = 0L;
        long seconds = 0L;
        StringBuilder sb = new StringBuilder();
        if (value > ONE_MIN) {
            minutes = TimeUnit.MILLISECONDS.toMinutes(value);
            value -= TimeUnit.MINUTES.toMillis(minutes);
        }
        if (value > ONE_SEC) {
            seconds = TimeUnit.MILLISECONDS.toSeconds(value);
            value -= TimeUnit.SECONDS.toMillis(seconds);
        }
        if (value >= 0L) {
            if (minutes > 0L) {
                sb.append(minutes).append(" minutes ");
            }
            if (seconds > 0L) {
                sb.append(seconds).append(" seconds ");
            }
            if (value > 0L) {
                sb.append(value);
                sb.append(" milliseconds");
            }
            return sb.toString();
        }
        return null;
    }
}

