/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification.admin;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.internal.notification.NotifierManager;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifierConfiguration;
import fish.payara.internal.notification.admin.NotificationServiceConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class BaseSetNotifierConfigurationCommand<C extends PayaraNotifierConfiguration>
implements AdminCommand {
    @Inject
    protected Target targetUtil;
    @Inject
    protected ServerEnvironment server;
    @Inject
    private NotifierManager notificationService;
    @Inject
    protected Logger logger;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="enabled")
    protected Boolean enabled;
    @Param(name="noisy", optional=true, defaultValue="true")
    protected Boolean noisy;

    public void execute(AdminCommandContext context) {
        Class notifierConfigurationClass;
        Config configuration;
        NotificationServiceConfiguration notificationServiceConfiguration;
        Object c;
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((c = (notificationServiceConfiguration = (NotificationServiceConfiguration)(configuration = this.targetUtil.getConfig(this.target)).getExtensionByType(NotificationServiceConfiguration.class)).getNotifierConfigurationByType(notifierConfigurationClass = NotifierUtils.getConfigurationClass(this.getClass()))) == null) {
            try {
                ConfigSupport.apply(notificationServiceConfigurationProxy -> {
                    notificationServiceConfigurationProxy.getNotifierConfigurationList().add((PayaraNotifierConfiguration)notificationServiceConfigurationProxy.createChild(notifierConfigurationClass));
                    return notificationServiceConfigurationProxy;
                }, notificationServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                actionReport.setMessage(ex.getCause().getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            c = notificationServiceConfiguration.getNotifierConfigurationByType(notifierConfigurationClass);
            if (c == null) {
                actionReport.setMessage("Could not locate notifier config");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(cProxy -> {
                this.applyValues(cProxy);
                actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return cProxy;
            }, c);
            if (this.dynamic.booleanValue()) {
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        this.configureDynamically(c);
                    }
                } else {
                    this.configureDynamically(c);
                }
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    protected void applyValues(C configuration) throws PropertyVetoException {
        if (this.enabled != null) {
            configuration.enabled(this.enabled);
        }
        if (this.noisy != null) {
            configuration.noisy(this.noisy);
        }
    }

    protected void configureDynamically(C configuration) {
        this.notificationService.reconfigureNotifier((PayaraNotifierConfiguration)configuration);
    }
}

