/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class Target {
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    ServiceLocator habitat;

    public boolean isThisDAS() {
        return this.serverEnv.isDas();
    }

    public boolean isThisInstance() {
        return this.serverEnv.isInstance();
    }

    public boolean isCluster(String targetName) {
        return this.domain.getClusterNamed(targetName) != null;
    }

    public Cluster getCluster(String targetName) {
        return this.domain.getClusterNamed(targetName);
    }

    public Config getClusterConfig(String targetName) {
        Cluster cl = this.getCluster(targetName);
        if (cl == null) {
            return null;
        }
        return this.domain.getConfigNamed(cl.getConfigRef());
    }

    public boolean isDeploymentGroup(String targetName) {
        return this.domain.getDeploymentGroupNamed(targetName) != null;
    }

    public Config getServerConfig(String targetName) {
        Server s = this.domain.getServerNamed(targetName);
        if (s == null) {
            return null;
        }
        return this.domain.getConfigNamed(s.getConfigRef());
    }

    public Config getConfig(String targetName) {
        List<Server> servers;
        if (CommandTarget.CONFIG.isValid(this.habitat, targetName)) {
            return this.domain.getConfigNamed(targetName);
        }
        if (CommandTarget.DAS.isValid(this.habitat, targetName)) {
            return this.getServerConfig(targetName);
        }
        if (CommandTarget.STANDALONE_INSTANCE.isValid(this.habitat, targetName)) {
            return this.getServerConfig(targetName);
        }
        if (CommandTarget.CLUSTER.isValid(this.habitat, targetName)) {
            return this.getClusterConfig(targetName);
        }
        if (this.isDeploymentGroup(targetName) && (servers = this.getInstances(targetName)).size() >= 1) {
            return servers.get(0).getConfig();
        }
        return null;
    }

    public List<DeploymentGroup> getDGForInstance(String targetName) {
        return this.domain.getDeploymentGroupsForInstance(targetName);
    }

    public Cluster getClusterForInstance(String targetName) {
        return this.domain.getClusterForInstance(targetName);
    }

    public List<Server> getInstances(List<String> names) {
        ArrayList<Server> instances = new ArrayList<Server>();
        for (String aName : names) {
            instances.addAll(this.getInstances(aName));
        }
        return instances;
    }

    public Node getNode(String targetName) {
        return this.domain.getNodeNamed(targetName);
    }

    public List<Server> getInstances(String targetName) {
        List<Object> instances = new ArrayList<Server>();
        if (CommandTarget.DOMAIN.isValid(this.habitat, targetName)) {
            return instances;
        }
        if (CommandTarget.DAS.isValid(this.habitat, targetName)) {
            return instances;
        }
        if (CommandTarget.STANDALONE_INSTANCE.isValid(this.habitat, targetName)) {
            instances.add(this.domain.getServerNamed(targetName));
        }
        if (CommandTarget.CLUSTER.isValid(this.habitat, targetName)) {
            instances = this.getCluster(targetName).getInstances();
        }
        if (CommandTarget.CONFIG.isValid(this.habitat, targetName)) {
            List targets = this.domain.getAllTargets();
            for (String aTarget : targets) {
                if (CommandTarget.CLUSTER.isValid(this.habitat, aTarget) && this.getCluster(aTarget).getConfigRef().equals(targetName)) {
                    instances.addAll(this.getCluster(aTarget).getInstances());
                }
                if (!CommandTarget.STANDALONE_INSTANCE.isValid(this.habitat, aTarget) || !this.domain.getServerNamed(aTarget).getConfigRef().equals(targetName)) continue;
                instances.add(this.domain.getServerNamed(aTarget));
            }
        }
        if (CommandTarget.NODE.isValid(this.habitat, targetName)) {
            List<Server> allInstances = this.getAllInstances();
            for (Server s : allInstances) {
                if (!targetName.equals(s.getNodeRef())) continue;
                instances.add(s);
            }
        }
        if (CommandTarget.DEPLOYMENT_GROUP.isValid(this.habitat, targetName)) {
            DeploymentGroup dg = this.domain.getDeploymentGroupNamed(targetName);
            instances.addAll(dg.getInstances());
        }
        return instances;
    }

    public List<Server> getAllInstances() {
        ArrayList<Server> list = new ArrayList<Server>();
        for (Server s : this.domain.getServers().getServer()) {
            if (CommandTarget.DAS.isValid(this.habitat, s.getName())) continue;
            list.add(s);
        }
        return list;
    }

    public boolean isValid(String targetName) {
        if (this.isCluster(targetName)) {
            return true;
        }
        if (this.getInstances(targetName).size() != 0) {
            return true;
        }
        if (this.domain.getConfigNamed(targetName) != null) {
            return true;
        }
        return this.isDeploymentGroup(targetName);
    }
}

