/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.ExceptionUtil;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.analysis.DeploymentSpan;
import org.glassfish.internal.deployment.analysis.StructuredDeploymentTracing;
import org.glassfish.internal.deployment.analysis.TraceContext;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class ModuleInfo {
    protected Set<EngineRef> engines = new LinkedHashSet<EngineRef>();
    protected LinkedList<EngineRef> reversedEngines = new LinkedList();
    protected final Map<Class<? extends Object>, Object> metaData = new HashMap<Class<? extends Object>, Object>();
    protected final String name;
    protected final Events events;
    private Properties moduleProps;
    private boolean loaded = false;
    private boolean started = false;
    private ClassLoader moduleClassLoader;
    private Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();

    public ModuleInfo(Events events, String name, Collection<EngineRef> refs, Properties moduleProps) {
        this.name = name;
        this.events = events;
        for (EngineRef ref : refs) {
            this.engines.add(ref);
        }
        for (EngineRef ref : refs) {
            this.reversedEngines.addFirst(ref);
        }
        this.moduleProps = moduleProps;
    }

    public Set<EngineRef> getEngineRefs() {
        LinkedHashSet<EngineRef> copy = new LinkedHashSet<EngineRef>();
        copy.addAll(this._getEngineRefs());
        return copy;
    }

    protected Set<EngineRef> _getEngineRefs() {
        return this.engines;
    }

    public Set<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    protected void cleanClassLoaders() {
        this.classLoaders.clear();
        this.moduleClassLoader = null;
    }

    public void addMetaData(Object o) {
        this.metaData.put(o.getClass(), o);
    }

    public <T> T getMetaData(Class<T> c) {
        return c.cast(this.metaData.get(c));
    }

    public Object getMetaData(String className) {
        for (Map.Entry<Class<? extends Object>, Object> entry : this.metaData.entrySet()) {
            if (!entry.getKey().getName().equals(className)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Properties getModuleProps() {
        Properties props = new Properties();
        if (this.moduleProps != null) {
            props.putAll((Map<?, ?>)this.moduleProps);
        }
        return props;
    }

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef engine : this._getEngineRefs()) {
            sniffers.add(engine.getContainerInfo().getSniffer());
        }
        return sniffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ExtendedDeploymentContext context, ProgressTracker tracker) throws Exception {
        block25: {
            Logger logger = context.getLogger();
            context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
            StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load(context);
            this.moduleClassLoader = context.getClassLoader();
            LinkedHashSet<EngineRef> filteredEngines = new LinkedHashSet<EngineRef>();
            LinkedList<EngineRef> filteredReversedEngines = new LinkedList<EngineRef>();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try (DeploymentSpan span = tracing.startSpan(TraceContext.Level.MODULE, this.name, DeploymentTracing.AppStage.LOAD);){
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                for (EngineRef engine : this._getEngineRefs()) {
                    EngineInfo engineInfo = engine.getContainerInfo();
                    Deployer deployer = engineInfo.getDeployer();
                    try {
                        DeploymentSpan containerSpan = tracing.startSpan(TraceContext.Level.CONTAINER, engineInfo.getSniffer().getModuleType(), DeploymentTracing.AppStage.LOAD);
                        try {
                            ApplicationContainer appCtr = deployer.load(engineInfo.getContainer(), (DeploymentContext)context);
                            if (appCtr == null) {
                                String msg = "Cannot load application in " + engineInfo.getContainer().getName() + " container";
                                logger.fine(msg);
                                continue;
                            }
                            engine.load(context, tracker);
                            engine.setApplicationContainer(appCtr);
                            filteredEngines.add(engine);
                            filteredReversedEngines.addFirst(engine);
                        }
                        finally {
                            if (containerSpan == null) continue;
                            containerSpan.close();
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception while invoking " + deployer.getClass() + " load method", e);
                        throw e;
                    }
                }
                this.engines = filteredEngines;
                this.reversedEngines = filteredReversedEngines;
                if (this.events == null) break block25;
                try (DeploymentSpan innerSpan = tracing.startSpan(TraceContext.Level.MODULE, this.name, DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.MODULE_LOADED.type());){
                    this.events.send(new EventListener.Event(Deployment.MODULE_LOADED, (Object)this), false);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    public <T extends Container> EngineRef getEngineRefForContainer(Class<T> type2) {
        for (EngineRef engine : this._getEngineRefs()) {
            Container container = null;
            try {
                container = (Container)type2.cast(engine.getContainerInfo().getContainer());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (container == null) continue;
            return engine;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(DeploymentContext context, ProgressTracker tracker) throws Exception {
        block26: {
            Logger logger = context.getLogger();
            if (this.started) {
                return;
            }
            this.loaded = true;
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load(context);
            try (DeploymentSpan span = tracing.startSpan(TraceContext.Level.MODULE, this.getName(), DeploymentTracing.AppStage.START);){
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                for (EngineRef engine : this._getEngineRefs()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "starting {0}", engine.getContainerInfo().getSniffer().getModuleType());
                    }
                    try {
                        DeploymentSpan innerSpan = tracing.startSpan(TraceContext.Level.CONTAINER, engine.getContainerInfo().getSniffer().getModuleType(), DeploymentTracing.AppStage.START);
                        try {
                            if (engine.start((ApplicationContext)context, tracker)) continue;
                            logger.log(Level.SEVERE, "Module not started {0}", engine.getApplicationContainer().toString());
                            throw new Exception("Module not started " + engine.getApplicationContainer().toString());
                        }
                        finally {
                            if (innerSpan == null) continue;
                            innerSpan.close();
                        }
                    }
                    catch (Exception e) {
                        DeployCommandParameters dcp = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
                        if (dcp.isSkipDSFailure().booleanValue() && ExceptionUtil.isDSFailure((Exception)e)) {
                            logger.log(Level.WARNING, "Resource communication failure exception skipped while invoking " + engine.getApplicationContainer().getClass() + " start method", e);
                            continue;
                        }
                        logger.log(Level.SEVERE, "Exception while invoking " + engine.getApplicationContainer().getClass() + " start method", e);
                        throw e;
                    }
                }
                this.started = true;
                if (this.events == null) break block26;
                try (DeploymentSpan innerSpan = tracing.startSpan(DeploymentTracing.AppStage.PROCESS_EVENTS, Deployment.MODULE_STARTED.type());){
                    this.events.send(new EventListener.Event(Deployment.MODULE_STARTED, (Object)this), false);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(ExtendedDeploymentContext context, Logger logger) {
        if (!this.started) {
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
            for (EngineRef engine : this.reversedEngines) {
                try {
                    context.setClassLoader(this.moduleClassLoader);
                    engine.stop((ApplicationContext)context);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Cannot stop module " + engine.getContainerInfo().getSniffer().getModuleType(), e);
                }
            }
            this.started = false;
            this.loaded = false;
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.MODULE_STOPPED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reload(DeploymentContext context, ProgressTracker tracker) throws Exception {
        Logger logger = context.getLogger();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        StructuredDeploymentTracing tracing = StructuredDeploymentTracing.load(context);
        try (DeploymentSpan span = tracing.startSpan(TraceContext.Level.MODULE, this.getName(), DeploymentTracing.AppStage.START);){
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            for (EngineRef engine : this._getEngineRefs()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Reloading {0}", engine.getContainerInfo().getSniffer().getModuleType());
                }
                try {
                    DeploymentSpan innerSpan = tracing.startSpan(TraceContext.Level.CONTAINER, engine.getContainerInfo().getSniffer().getModuleType(), DeploymentTracing.AppStage.START);
                    try {
                        if (engine.reload((ApplicationContext)context, tracker)) continue;
                        logger.log(Level.SEVERE, "Module not reloaded {0}", engine.getApplicationContainer().toString());
                        throw new Exception("Module not reloaded " + engine.getApplicationContainer().toString());
                    }
                    finally {
                        if (innerSpan == null) continue;
                        innerSpan.close();
                    }
                }
                catch (Exception e) {
                    DeployCommandParameters dcp = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
                    if (dcp.isSkipDSFailure().booleanValue() && ExceptionUtil.isDSFailure((Exception)e)) {
                        logger.log(Level.WARNING, "Resource communication failure exception skipped while invoking " + engine.getApplicationContainer().getClass() + " start method", e);
                        continue;
                    }
                    logger.log(Level.SEVERE, "Exception while invoking " + engine.getApplicationContainer().getClass() + " reload method", e);
                    throw e;
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(ExtendedDeploymentContext context) {
        Logger logger = context.getLogger();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.moduleClassLoader);
            for (EngineRef engine : this.reversedEngines) {
                if (engine.getApplicationContainer() == null || engine.getApplicationContainer().getClassLoader() == null) continue;
                this.classLoaders.add(engine.getApplicationContainer().getClassLoader());
                try {
                    context.setClassLoader(this.moduleClassLoader);
                    engine.unload(context);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Failed to unload from container type : " + engine.getContainerInfo().getSniffer().getModuleType(), e);
                }
            }
            if (this.classLoaders != null && this.moduleClassLoader != null) {
                this.classLoaders.add(this.moduleClassLoader);
            }
            if (this.events != null) {
                this.events.send(new EventListener.Event(Deployment.MODULE_UNLOADED, (Object)this), false);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            context.setClassLoader(null);
        }
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        for (EngineRef ref : this.reversedEngines) {
            ref.clean(context);
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_CLEANED, (Object)context), false);
        }
    }

    public boolean suspend(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef engine : this.reversedEngines) {
            try {
                engine.getApplicationContainer().suspend();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error suspending module " + engine.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public boolean resume(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef module : this._getEngineRefs()) {
            try {
                module.getApplicationContainer().resume();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error resuming module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public void save(Module module) throws TransactionFailure, PropertyVetoException {
        if (Boolean.valueOf(this.moduleProps.getProperty("isComposite")).booleanValue()) {
            this.moduleProps.remove("isComposite");
            for (String string : this.moduleProps.keySet()) {
                Property prop = (Property)module.createChild(Property.class);
                module.getProperty().add(prop);
                prop.setName(string);
                prop.setValue(this.moduleProps.getProperty(string));
            }
        }
        for (EngineRef engineRef : this._getEngineRefs()) {
            Engine engine = (Engine)module.createChild(Engine.class);
            module.getEngines().add(engine);
            engineRef.save(engine);
        }
    }

    public void reset() {
        this.cleanClassLoaders();
        this.started = false;
        this.loaded = false;
    }
}

