/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment.analysis;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.glassfish.internal.deployment.analysis.TraceContext;

public class DeploymentSpan
implements AutoCloseable {
    static final DateTimeFormatter NS_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.nnnnnnnnn").withZone(ZoneId.systemDefault());
    private final Clock clock;
    final TraceContext context;
    private final String componentName;
    private final Enum<?> action;
    private final Instant start;
    private Instant finish;
    int nestLevel = 0;

    private DeploymentSpan(Clock clock, TraceContext context, String componentName, Enum<?> action) {
        this.start = clock.instant();
        this.clock = clock;
        this.context = context;
        this.componentName = componentName;
        this.action = action;
    }

    private DeploymentSpan(Instant start, Instant finish, TraceContext context, String componentName, Enum<?> action) {
        this.start = start;
        this.clock = null;
        this.finish = finish;
        this.context = context;
        this.componentName = componentName;
        this.action = action;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getFinish() {
        if (this.finish == null) {
            if (this.context == null) {
                return null;
            }
            return this.context.getFinish();
        }
        return this.finish;
    }

    public Duration getDuration() {
        Instant finish = this.getFinish();
        return finish != null ? Duration.between(this.getStart(), finish) : null;
    }

    boolean isOpen() {
        return this.finish == null;
    }

    public Enum<?> getAction() {
        return this.action;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NS_FORMATTER.formatTo(this.start, sb);
        sb.append('\t');
        Instant f = this.getFinish();
        if (f != null) {
            NS_FORMATTER.formatTo(f, sb);
        }
        sb.append('\t').append(this.getNestLevel()).append('\t');
        if (this.context != null) {
            sb.append(this.context.getLevelName(TraceContext.Level.CONTAINER)).append('\t').append(this.context);
        } else {
            sb.append('\t');
        }
        sb.append('\t').append(this.action).append('\t');
        if (this.componentName != null) {
            sb.append(this.componentName);
        }
        sb.append('\t');
        Duration duration = this.getDuration();
        if (duration != null) {
            sb.append(duration.toMillis());
        }
        return sb.toString();
    }

    @Override
    public void close() {
        if (this.clock == null) {
            throw new IllegalArgumentException("DeploymentSpan is already created closed");
        }
        if (this.finish != null) {
            return;
        }
        this.finish = this.clock.instant();
    }

    public int getNestLevel() {
        return this.nestLevel;
    }

    void setNestLevel(int nestLevel) {
        this.nestLevel = nestLevel;
    }

    static DeploymentSpan createOpen(Clock clock, TraceContext context, String componentName, Enum<?> action) {
        return new DeploymentSpan(clock, context, componentName, action);
    }

    static DeploymentSpan createClosed(DeploymentSpan previous, Clock clock, TraceContext context, String componentName, Enum<?> action) {
        if (previous != null) {
            Instant start = previous.getFinish();
            if (start == null) {
                start = context.getStart();
            }
            return new DeploymentSpan(start, clock.instant(), context, componentName, action);
        }
        return new DeploymentSpan(context.getStart(), clock.instant(), context, componentName, action);
    }
}

