/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.factory.AnnotatedElementHandlerFactory;
import com.sun.enterprise.deployment.annotation.factory.SJSASFactory;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ComponentPostVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.TracerVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import fish.payara.nucleus.hotdeploy.ApplicationState;
import jakarta.inject.Inject;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ErrorHandler;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.ProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.DefaultErrorHandler;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.jvnet.hk2.annotations.Contract;
import org.xml.sax.SAXParseException;

@Contract
public abstract class Archivist<T extends BundleDescriptor> {
    protected static final Logger logger = DOLUtils.getDefaultLogger();
    public static final String MANIFEST_VERSION_VALUE = "1.0";
    protected String path;
    protected boolean handleRuntimeInfo = true;
    protected boolean annotationProcessingRequested = false;
    protected Manifest manifest;
    protected DeploymentDescriptorFile<T> standardDD;
    protected List<ConfigurationDeploymentDescriptorFile> confDDFiles;
    private List<ConfigurationDeploymentDescriptorFile> sortedConfDDFiles;
    private ConfigurationDeploymentDescriptorFile confDD;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Archivist.class);
    protected ClassLoader classLoader = null;
    private boolean isValidatingXML = true;
    private boolean isValidatingRuntimeXML = true;
    private String validationLevel = "parsing";
    private String runtimeValidationLevel = "parsing";
    private ErrorHandler annotationErrorHandler = new DefaultErrorHandler();
    private static final String WSDL = ".wsdl";
    private static final String XML = ".xml";
    private static final String XSD = ".xsd";
    protected static final String APPLICATION_EXTENSION = ".ear";
    protected static final String APPCLIENT_EXTENSION = ".jar";
    protected static final String WEB_EXTENSION = ".war";
    protected static final String WEB_FRAGMENT_EXTENSION = ".jar";
    protected static final String EJB_EXTENSION = ".jar";
    protected static final String CONNECTOR_EXTENSION = ".rar";
    protected static final String UPLOAD_EXTENSION = ".tmp";
    private static final String PROCESS_ANNOTATION_FOR_OLD_DD = "process.annotation.for.old.dd";
    private static final boolean processAnnotationForOldDD = Boolean.getBoolean("process.annotation.for.old.dd");
    protected T descriptor;
    @Inject
    protected ServiceLocator habitat;
    @Inject
    protected ServiceLocator locator;
    @Inject
    SJSASFactory annotationFactory;
    @Inject
    ArchiveFactory archiveFactory;
    protected List<ExtensionsArchivist> extensionsArchivists;

    protected void initializeContext(Archivist other) {
        this.handleRuntimeInfo = other.isHandlingRuntimeInfo();
        this.annotationProcessingRequested = other.isAnnotationProcessingRequested();
        this.isValidatingXML = other.isValidatingXML;
        this.validationLevel = other.validationLevel;
        this.classLoader = other.classLoader;
        this.annotationErrorHandler = other.annotationErrorHandler;
    }

    public void setExtensionArchivists(List<ExtensionsArchivist> archivists) {
        this.extensionsArchivists = archivists;
    }

    public List<ExtensionsArchivist> getExtensionArchivists() {
        return this.extensionsArchivists;
    }

    public void setDescriptor(T descriptor) {
        this.descriptor = descriptor;
    }

    public T getDescriptor() {
        return this.descriptor;
    }

    public T open(ReadableArchive archive) throws IOException, SAXParseException {
        return this.open(archive, (Application)null);
    }

    public T open(ReadableArchive descriptorArchive, ReadableArchive contentArchive) throws IOException, SAXParseException {
        return this.open(descriptorArchive, contentArchive, null);
    }

    public T open(ReadableArchive descriptorArchive, ReadableArchive contentArchive, Application app) throws IOException, SAXParseException {
        this.setManifest(contentArchive.getManifest());
        T descriptor = this.readDeploymentDescriptors(descriptorArchive, contentArchive, app);
        if (descriptor != null) {
            this.postOpen(descriptor, contentArchive);
        }
        return descriptor;
    }

    public T open(ReadableArchive archive, Application app) throws IOException, SAXParseException {
        return this.open(archive, archive, app);
    }

    public Application openWith(Application app, ReadableArchive archive) throws IOException, SAXParseException {
        BundleDescriptor descriptor;
        this.setManifest(archive.getManifest());
        if (app.isVirtual() && (descriptor = this.readRestDeploymentDescriptors(app.getStandaloneBundleDescriptor(), archive, archive, app)) != null) {
            this.postOpen(descriptor, archive);
            descriptor.setApplication(app);
        }
        return app;
    }

    public T open(String path) throws IOException, SAXParseException {
        this.path = path;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        return this.open(file);
    }

    public T open(File file) throws IOException, SAXParseException {
        this.path = file.getAbsolutePath();
        ReadableArchive archive = this.archiveFactory.openArchive(file);
        T descriptor = this.open(archive);
        archive.close();
        this.validate(null);
        return descriptor;
    }

    protected void postStandardDDsRead(T descriptor, ReadableArchive archive, Map<ExtensionsArchivist, RootDeploymentDescriptor> extensions) throws IOException {
    }

    protected void postAnnotationProcess(T descriptor, ReadableArchive archive) throws IOException {
    }

    public void postRuntimeDDsRead(T descriptor, ReadableArchive archive) throws IOException {
    }

    protected void postOpen(T descriptor, ReadableArchive archive) throws IOException {
    }

    private T readDeploymentDescriptors(ReadableArchive descriptorArchive, ReadableArchive contentArchive, Application app) throws IOException, SAXParseException {
        T descriptor = this.readStandardDeploymentDescriptor(descriptorArchive);
        ((BundleDescriptor)descriptor).setApplication(app);
        ModuleDescriptor newModule = this.createModuleDescriptor(descriptor);
        newModule.setArchiveUri(contentArchive.getURI().getSchemeSpecificPart());
        return this.readRestDeploymentDescriptors(descriptor, descriptorArchive, contentArchive, app);
    }

    private T readRestDeploymentDescriptors(T descriptor, ReadableArchive descriptorArchive, ReadableArchive contentArchive, Application app) throws IOException, SAXParseException {
        ApplicationState state = (ApplicationState)descriptorArchive.getExtraData(ApplicationState.class);
        HashMap<ExtensionsArchivist, RootDeploymentDescriptor> extensions = new HashMap<ExtensionsArchivist, RootDeploymentDescriptor>();
        if (this.extensionsArchivists != null) {
            for (ExtensionsArchivist extension : this.extensionsArchivists) {
                Object extDescriptor = null;
                if (state != null && state.isActive() && extension.getDefaultDescriptor() != null) {
                    extDescriptor = state.getDeploymentContext().getModuleMetaData(extension.getDefaultDescriptor().getClass());
                }
                if (extDescriptor == null) {
                    extDescriptor = extension.open(this, descriptorArchive, (RootDeploymentDescriptor)descriptor);
                }
                if (extDescriptor instanceof RootDeploymentDescriptor) {
                    if (extDescriptor != descriptor) {
                        extension.addExtension((RootDeploymentDescriptor)descriptor, (RootDeploymentDescriptor)extDescriptor);
                    }
                    extensions.put(extension, (RootDeploymentDescriptor)extDescriptor);
                    continue;
                }
                extensions.put(extension, null);
            }
        }
        this.postStandardDDsRead(descriptor, contentArchive, extensions);
        this.readAnnotations(contentArchive, descriptor, extensions);
        this.postStandardDDsRead(descriptor, contentArchive, extensions);
        ApplicationState appState = (ApplicationState)contentArchive.getExtraData(ApplicationState.class);
        if (appState == null || !appState.isHotswap()) {
            this.postAnnotationProcess(descriptor, contentArchive);
        }
        this.readRuntimeDeploymentDescriptor(descriptorArchive, descriptor);
        for (Map.Entry extension : extensions.entrySet()) {
            if (extension.getValue() == null) continue;
            ((ExtensionsArchivist)extension.getKey()).readRuntimeDeploymentDescriptor(this, descriptorArchive, (RootDeploymentDescriptor)extension.getValue());
        }
        this.postRuntimeDDsRead(descriptor, contentArchive);
        return descriptor;
    }

    protected void readAnnotations(ReadableArchive archive, T descriptor, Map<ExtensionsArchivist, RootDeploymentDescriptor> extensions) throws IOException {
        this.readAnnotations(archive, descriptor, extensions, null);
    }

    protected void readAnnotations(ReadableArchive archive, T descriptor, Map<ExtensionsArchivist, RootDeploymentDescriptor> extensions, ModuleScanner scanner) throws IOException {
        try {
            boolean processAnnotationForMainDescriptor = this.isProcessAnnotation((BundleDescriptor)descriptor);
            ProcessingResult result = null;
            if (processAnnotationForMainDescriptor) {
                if (scanner == null) {
                    scanner = this.getScanner();
                }
                result = this.processAnnotations((RootDeploymentDescriptor)descriptor, scanner, archive);
            }
            for (Map.Entry<ExtensionsArchivist, RootDeploymentDescriptor> extension : extensions.entrySet()) {
                try {
                    BundleDescriptor extBundle;
                    if (extension.getValue() == null) {
                        if (!processAnnotationForMainDescriptor) continue;
                        Object o = extension.getKey().getDefaultDescriptor();
                        if (o != null) {
                            o.setModuleDescriptor(descriptor.getModuleDescriptor());
                            if (o instanceof BundleDescriptor) {
                                boolean isFullMain = ((BundleDescriptor)descriptor).isFullAttribute();
                                ((BundleDescriptor)o).setFullAttribute(String.valueOf(isFullMain));
                            }
                        }
                        this.processAnnotations((RootDeploymentDescriptor)o, extension.getKey().getScanner(), archive);
                        if (o == null || o.isEmpty()) continue;
                        extension.getKey().addExtension((RootDeploymentDescriptor)descriptor, (RootDeploymentDescriptor)o);
                        extensions.put(extension.getKey(), (RootDeploymentDescriptor)o);
                        continue;
                    }
                    if (!(extension.getValue() instanceof BundleDescriptor) || !this.isProcessAnnotation(extBundle = (BundleDescriptor)extension.getValue())) continue;
                    this.processAnnotations(extBundle, extension.getKey().getScanner(), archive);
                }
                catch (AnnotationProcessorException ex) {
                    DOLUtils.getDefaultLogger().severe(ex.getMessage());
                    DOLUtils.getDefaultLogger().log(Level.FINE, ex.getMessage(), ex);
                    throw new IllegalStateException(ex);
                }
            }
            if (result != null && ResultType.FAILED.equals((Object)result.getOverallResult())) {
                DOLUtils.getDefaultLogger().severe(localStrings.getLocalString("enterprise.deployment.archivist.annotationprocessingfailed", "Annotations processing failed for {0}", new Object[]{archive.getURI()}));
            }
        }
        catch (NoClassDefFoundError err) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.WARNING)) {
                DOLUtils.getDefaultLogger().log(Level.WARNING, "Error in annotation processing: {0}", err);
            }
        }
        catch (AnnotationProcessorException ex) {
            DOLUtils.getDefaultLogger().severe(ex.getMessage());
            DOLUtils.getDefaultLogger().log(Level.FINE, ex.getMessage(), ex);
            throw new IllegalStateException(ex);
        }
    }

    public ModuleScanner getScanner() {
        Scanner scanner = null;
        try {
            scanner = (Scanner)this.habitat.getService(Scanner.class, this.getModuleType().toString(), new Annotation[0]);
            if (scanner == null || !(scanner instanceof ModuleScanner)) {
                logger.log(Level.SEVERE, "Cannot find module scanner for " + this.getManifest());
            }
        }
        catch (MultiException e) {
            logger.log(Level.SEVERE, "Cannot find scanner for " + this.getModuleType(), e);
        }
        return (ModuleScanner)scanner;
    }

    public ProcessingResult processAnnotations(T bundleDesc, ReadableArchive archive) throws AnnotationProcessorException, IOException {
        return this.processAnnotations((RootDeploymentDescriptor)bundleDesc, this.getScanner(), archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessingResult processAnnotations(RootDeploymentDescriptor bundleDesc, ModuleScanner scanner, ReadableArchive archive) throws AnnotationProcessorException, IOException {
        if (scanner == null) {
            return null;
        }
        AnnotatedElementHandler aeHandler = AnnotatedElementHandlerFactory.createAnnotatedElementHandler(bundleDesc);
        if (aeHandler == null) {
            return null;
        }
        Parser parser = null;
        parser = archive.getParentArchive() != null ? (Parser)archive.getParentArchive().getExtraData(Parser.class) : (Parser)archive.getExtraData(Parser.class);
        scanner.process(archive, bundleDesc, this.classLoader, parser);
        if (!scanner.getElements().isEmpty()) {
            if (((BundleDescriptor)bundleDesc).isDDWithNoAnnotationAllowed()) {
                String ddName = this.getStandardDDFile().getDeploymentDescriptorPath();
                String explodedArchiveName = new File(archive.getURI()).getName();
                String archiveName = FileUtils.revertFriendlyFilenameExtension((String)explodedArchiveName);
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.oldDDwithAnnotation", "{0} in archive {1} is of version {2}, which cannot support annotations in an application.  Please upgrade the deployment descriptor to be a version supported by Java EE 5.0 (or later).", new Object[]{ddName, archiveName, bundleDesc.getSpecVersion()}));
            }
            boolean isFullAttribute = false;
            if (bundleDesc instanceof BundleDescriptor) {
                isFullAttribute = ((BundleDescriptor)bundleDesc).isFullAttribute();
            }
            AnnotationProcessor ap = this.annotationFactory.getAnnotationProcessor(isFullAttribute);
            ProcessingContext ctx = this.getProcessingContext(bundleDesc, archive, ap);
            ctx.setArchive(archive);
            if (this.annotationErrorHandler != null) {
                ctx.setErrorHandler(this.annotationErrorHandler);
            }
            ctx.setProcessingInput((Scanner)scanner);
            ctx.pushHandler(aeHandler);
            ClassLoader originalBundleClassLoader = null;
            try {
                originalBundleClassLoader = bundleDesc.getClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (originalBundleClassLoader == null) {
                bundleDesc.setClassLoader(this.classLoader);
            }
            try {
                ProcessingResult processingResult = ap.process(ctx);
                return processingResult;
            }
            finally {
                if (originalBundleClassLoader == null) {
                    bundleDesc.setClassLoader(null);
                }
            }
        }
        return null;
    }

    private ProcessingContext getProcessingContext(RootDeploymentDescriptor bundleDesc, ReadableArchive archive, AnnotationProcessor ap) {
        ProcessingContext ctx = null;
        ApplicationState state = (ApplicationState)archive.getExtraData(ApplicationState.class);
        if (state != null) {
            ctx = (ProcessingContext)state.getProcessingContext(bundleDesc.getClass(), ProcessingContext.class);
        }
        if (ctx == null) {
            ctx = ap.createContext();
            if (state != null) {
                state.addProcessingContext(bundleDesc.getClass(), (Object)ctx);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readStandardDeploymentDescriptor(ReadableArchive archive) throws IOException, SAXParseException {
        try (InputStream is = null;){
            this.getStandardDDFile().setArchiveType(this.getModuleType());
            File altDDFile = (File)archive.getArchiveMetaData("altdd", File.class);
            is = altDDFile != null && altDDFile.exists() && altDDFile.isFile() ? new FileInputStream(altDDFile) : archive.getEntry(this.standardDD.getDeploymentDescriptorPath());
            if (is != null) {
                this.standardDD.setXMLValidation(this.getXMLValidation());
                this.standardDD.setXMLValidationLevel(this.validationLevel);
                if (archive.getURI() != null) {
                    this.standardDD.setErrorReportingString(archive.getURI().getSchemeSpecificPart());
                }
                BundleDescriptor result = (BundleDescriptor)this.standardDD.read(is);
                result.setClassLoader(this.classLoader);
                BundleDescriptor bundleDescriptor = result;
                return (T)bundleDescriptor;
            }
            T t = this.getDefaultBundleDescriptor();
            return t;
        }
    }

    public void readRuntimeDeploymentDescriptor(ReadableArchive archive, T descriptor) throws IOException, SAXParseException {
        this.readRuntimeDeploymentDescriptor(archive, descriptor, true);
    }

    public void readRuntimeDeploymentDescriptor(ReadableArchive archive, T descriptor, boolean warnIfMultipleDDs) throws IOException, SAXParseException {
        String ddFileEntryName = this.getRuntimeDeploymentDescriptorPath(archive);
        if (!this.isHandlingRuntimeInfo() || ddFileEntryName == null) {
            return;
        }
        DOLUtils.readRuntimeDeploymentDescriptor(this.getSortedConfigurationDDFiles(archive), archive, descriptor, this, warnIfMultipleDDs);
    }

    public void write() throws IOException {
        this.write(this.path);
    }

    public void write(String outPath) throws IOException {
        ReadableArchive in = this.archiveFactory.openArchive(new File(this.path));
        this.write(in, outPath);
        in.close();
    }

    public void write(ReadableArchive in, String outPath) throws IOException {
        ReadableArchive oldArchive = null;
        try {
            oldArchive = this.archiveFactory.openArchive(new File(outPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        WritableArchive out = null;
        Object bos = null;
        try {
            File outputFile = null;
            if (oldArchive != null && oldArchive.exists() && !(oldArchive instanceof WritableArchive)) {
                outputFile = Archivist.getTempFile(outPath);
                outputFile.delete();
                out = this.archiveFactory.createArchive(outputFile);
                oldArchive.close();
            } else {
                out = this.archiveFactory.createArchive(new File(outPath));
            }
            this.writeContents(in, out);
            out.close();
            in.close();
            if (outputFile != null) {
                ReadableArchive finalArchive = this.archiveFactory.openArchive(new File(outPath));
                finalArchive.delete();
                ReadableArchive tmpArchive = this.archiveFactory.openArchive(outputFile);
                tmpArchive.renameTo(outPath);
            }
        }
        catch (IOException ioe) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public void write(ReadableArchive in, WritableArchive out) throws IOException {
        this.writeContents(in, out);
    }

    protected void writeContents(WritableArchive out) throws IOException {
        ReadableArchive in = this.archiveFactory.openArchive(new File(this.path));
        this.writeContents(in, out);
        in.close();
    }

    protected void writeContents(ReadableArchive in, WritableArchive out) throws IOException {
        this.writeContents(in, out, null);
    }

    protected void writeContents(ReadableArchive in, WritableArchive out, Vector entriesToSkip) throws IOException {
        if (in != null && in.exists()) {
            if (entriesToSkip == null) {
                entriesToSkip = this.getListOfFilesToSkip(in);
            } else {
                entriesToSkip.addAll(this.getListOfFilesToSkip(in));
            }
            this.copyJarElements(in, out, entriesToSkip);
        }
        this.writeDeploymentDescriptors(in, out);
        if (this.manifest != null) {
            OutputStream os = out.putNextEntry("META-INF/MANIFEST.MF");
            this.manifest.write(new DataOutputStream(os));
            out.closeEntry();
        }
    }

    public void writeDeploymentDescriptors(ReadableArchive in, WritableArchive out) throws IOException {
        this.writeStandardDeploymentDescriptors(out);
        this.writeRuntimeDeploymentDescriptors(in, out);
        this.writeExtensionDeploymentDescriptors(in, out);
    }

    public void writeStandardDeploymentDescriptors(WritableArchive out) throws IOException {
        this.getStandardDDFile().setArchiveType(this.getModuleType());
        OutputStream os = out.putNextEntry(this.getDeploymentDescriptorPath());
        this.standardDD.write(this.getDescriptor(), os);
        out.closeEntry();
    }

    public void writeRuntimeDeploymentDescriptors(ReadableArchive in, WritableArchive out) throws IOException {
        T desc = this.getDescriptor();
        List<ConfigurationDeploymentDescriptorFile> confDDFilesToWrite = this.getSortedConfigurationDDFiles(in);
        if (confDDFilesToWrite.isEmpty()) {
            confDDFilesToWrite = this.getConfigurationDDFiles();
        }
        for (ConfigurationDeploymentDescriptorFile ddFile : confDDFilesToWrite) {
            ddFile.setArchiveType(this.getModuleType());
            OutputStream os = out.putNextEntry(ddFile.getDeploymentDescriptorPath());
            ddFile.write(desc, os);
            out.closeEntry();
        }
    }

    public void writeExtensionDeploymentDescriptors(ReadableArchive in, WritableArchive out) throws IOException {
        List extArchivists = this.habitat.getAllServices(ExtensionsArchivist.class, new Annotation[0]);
        for (ExtensionsArchivist extension : extArchivists) {
            if (!extension.supportsModuleType(this.getModuleType())) continue;
            extension.writeDeploymentDescriptors(this, (BundleDescriptor)this.getDescriptor(), in, out);
        }
    }

    private List<ConfigurationDeploymentDescriptorFile> getSortedConfigurationDDFiles(ReadableArchive archive) throws IOException {
        if (this.sortedConfDDFiles == null) {
            this.sortedConfDDFiles = DOLUtils.processConfigurationDDFiles(this.getConfigurationDDFiles(), archive, this.getModuleType());
        }
        return this.sortedConfDDFiles;
    }

    public String getDeploymentDescriptorPath() {
        return this.getStandardDDFile().getDeploymentDescriptorPath();
    }

    public String getRuntimeDeploymentDescriptorPath(ReadableArchive archive) throws IOException {
        ConfigurationDeploymentDescriptorFile ddFile = this.getConfigurationDDFile(archive);
        if (ddFile != null) {
            return ddFile.getDeploymentDescriptorPath();
        }
        return null;
    }

    public void setModuleDescriptor(ModuleDescriptor<T> module) {
        this.setDescriptor((BundleDescriptor)module.getDescriptor());
        this.setManifest(module.getManifest());
    }

    public boolean performOptionalPkgDependenciesCheck(ReadableArchive archive) throws IOException {
        Vector libs;
        boolean dependenciesSatisfied = true;
        Manifest m = archive.getManifest();
        if (m != null) {
            dependenciesSatisfied = InstalledLibrariesResolver.resolveDependencies((Manifest)m, (String)archive.getURI().getSchemeSpecificPart());
        }
        if ((libs = this.getLibraries((Archive)archive)) != null) {
            for (String libUri : libs) {
                try (JarInputStream jis = new JarInputStream(archive.getEntry(libUri));){
                    m = jis.getManifest();
                    if (m == null || InstalledLibrariesResolver.resolveDependencies((Manifest)m, (String)libUri)) continue;
                    dependenciesSatisfied = false;
                }
            }
        }
        return dependenciesSatisfied;
    }

    public abstract ArchiveType getModuleType();

    public abstract DeploymentDescriptorFile<T> getStandardDDFile();

    public abstract List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles();

    private ConfigurationDeploymentDescriptorFile getConfigurationDDFile(ReadableArchive archive) throws IOException {
        if (this.confDD == null) {
            this.getSortedConfigurationDDFiles(archive);
            if (this.sortedConfDDFiles != null && !this.sortedConfDDFiles.isEmpty()) {
                this.confDD = this.sortedConfDDFiles.get(0);
            }
        }
        return this.confDD;
    }

    public abstract T getDefaultBundleDescriptor();

    protected abstract String getArchiveExtension();

    protected abstract boolean postHandles(ReadableArchive var1) throws IOException;

    public boolean hasStandardDeploymentDescriptor(ReadableArchive archive) throws IOException {
        InputStream stIs = archive.getEntry(this.getDeploymentDescriptorPath());
        if (stIs != null) {
            stIs.close();
            return true;
        }
        return false;
    }

    public boolean hasRuntimeDeploymentDescriptor(ReadableArchive archive) throws IOException {
        this.getConfigurationDDFile(archive);
        return this.confDD != null;
    }

    public boolean handles(ReadableArchive archive) {
        try {
            if (this.hasStandardDeploymentDescriptor(archive) || this.hasRuntimeDeploymentDescriptor(archive)) {
                return true;
            }
            String uri = archive.getURI().toString();
            File file = new File(archive.getURI());
            if (!file.isDirectory() && !uri.endsWith(".jar") && uri.endsWith(this.getArchiveExtension())) {
                return true;
            }
            if (this.postHandles(archive)) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public ModuleDescriptor createModuleDescriptor(T descriptor) {
        ModuleDescriptor newModule = descriptor.getModuleDescriptor();
        this.setDescriptor(descriptor);
        return newModule;
    }

    public void printDescriptor() {
        DescriptorVisitor tracerVisitor = this.getDescriptor().getTracerVisitor();
        if (tracerVisitor == null) {
            tracerVisitor = new TracerVisitor();
        }
        this.getDescriptor().visit(tracerVisitor);
    }

    public void setHandleRuntimeInfo(boolean handleRuntimeInfo) {
        this.handleRuntimeInfo = handleRuntimeInfo;
    }

    public boolean isHandlingRuntimeInfo() {
        return this.handleRuntimeInfo;
    }

    public void setAnnotationProcessingRequested(boolean annotationProcessingRequested) {
        this.annotationProcessingRequested = annotationProcessingRequested;
    }

    public boolean isAnnotationProcessingRequested() {
        return this.annotationProcessingRequested;
    }

    public void setAnnotationErrorHandler(ErrorHandler annotationErrorHandler) {
        this.annotationErrorHandler = annotationErrorHandler;
    }

    public ErrorHandler getAnnotationErrorHandler() {
        return this.annotationErrorHandler;
    }

    public void setManifest(Manifest m) {
        this.manifest = m;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setClassPath(String newClassPath) {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes atts = this.manifest.getMainAttributes();
        atts.putValue(Attributes.Name.CLASS_PATH.toString(), newClassPath);
    }

    public String getClassPath() {
        if (this.manifest == null) {
            return null;
        }
        Attributes atts = this.manifest.getMainAttributes();
        return atts.getValue(Attributes.Name.CLASS_PATH);
    }

    public Vector getLibraries(Archive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (entryName.indexOf(47) != -1 || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    protected String getUniqueEntryFilenameFor(Archive archive, String trialName) throws IOException {
        Vector entriesNames = new Vector();
        Enumeration e = archive.entries();
        while (e != null && e.hasMoreElements()) {
            entriesNames.add(e.nextElement());
        }
        return Descriptor.createUniqueFilenameAmongst((String)trialName, entriesNames);
    }

    protected static File getTempFile(String fileOrDirPath) throws IOException {
        if (fileOrDirPath != null) {
            return Archivist.getTempFile(new File(fileOrDirPath));
        }
        return Archivist.getTempFile((File)null);
    }

    public Vector getListOfFilesToSkip(ReadableArchive archive) throws IOException {
        Vector<String> filesToSkip = new Vector<String>();
        filesToSkip.add(this.getDeploymentDescriptorPath());
        if (this.manifest != null) {
            filesToSkip.add("META-INF/MANIFEST.MF");
        }
        if (this.getRuntimeDeploymentDescriptorPath(archive) != null) {
            filesToSkip.add(this.getRuntimeDeploymentDescriptorPath(archive));
        }
        filesToSkip.addAll(this.getAllWebservicesDeploymentDescriptorPaths());
        return filesToSkip;
    }

    protected static File getTempFile(File fileOrDir) throws IOException {
        File dir;
        if (fileOrDir == null) {
            dir = new File(System.getProperty("user.dir"));
        } else if (!fileOrDir.isDirectory()) {
            dir = fileOrDir.getParentFile();
            if (dir == null) {
                dir = new File(System.getProperty("user.dir"));
            }
        } else {
            dir = fileOrDir;
        }
        return File.createTempFile("tmp", ".jar", dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addFileToArchive(WritableArchive archive, String filePath, String entryName) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(new File(filePath));
            OutputStream os = archive.putNextEntry(entryName);
            ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                archive.closeEntry();
                throw e;
            }
            archive.closeEntry();
        }
    }

    protected void copyJarElements(ReadableArchive in, WritableArchive out, Vector ignoreList) throws IOException {
        Enumeration entries = in.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (ignoreList != null && ignoreList.contains(anEntry)) continue;
                InputStream is = in.getEntry(anEntry);
                if (is != null) {
                    OutputStream os = out.putNextEntry(anEntry);
                    ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
                    is.close();
                }
                out.closeEntry();
            }
        }
    }

    protected boolean renameTmp(String from, String to) throws IOException {
        ReadableArchive finalArchive = this.archiveFactory.openArchive(new File(to));
        finalArchive.delete();
        ReadableArchive tmpArchive = this.archiveFactory.openArchive(new File(from));
        boolean success = tmpArchive.renameTo(to);
        if (!success) {
            throw new IOException("Error renaming JAR");
        }
        return success;
    }

    public void setArchiveUri(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setXMLValidation(boolean validate) {
        this.isValidatingXML = validate;
    }

    public boolean getXMLValidation() {
        return this.isValidatingXML;
    }

    public void setRuntimeXMLValidation(boolean validate) {
        this.isValidatingRuntimeXML = validate;
    }

    public boolean getRuntimeXMLValidation() {
        return this.isValidatingRuntimeXML;
    }

    public void setXMLValidationLevel(String level) {
        this.validationLevel = level;
    }

    public String getXMLValidationLevel() {
        return this.validationLevel;
    }

    public void setRuntimeXMLValidationLevel(String level) {
        this.runtimeValidationLevel = level;
    }

    public String getRuntimeXMLValidationLevel() {
        return this.runtimeValidationLevel;
    }

    public void validate(ClassLoader aClassLoader) {
    }

    protected void postValidate(BundleDescriptor bundleDesc, ReadableArchive archive) {
        ComponentPostVisitor postVisitor = (ComponentPostVisitor)this.habitat.getService(ComponentPostVisitor.class, new Annotation[0]);
        postVisitor.setArchive(archive);
        bundleDesc.visit(postVisitor);
    }

    public void copyInto(WritableArchive target) throws IOException {
        ReadableArchive source = this.archiveFactory.openArchive(new File(this.path));
        this.copyInto(source, target);
    }

    public void copyInto(ReadableArchive source, WritableArchive target) throws IOException {
        this.copyInto(source, target, null, true);
    }

    public void copyInto(ReadableArchive source, WritableArchive target, boolean overwriteManifest) throws IOException {
        this.copyInto(source, target, null, overwriteManifest);
    }

    public void copyInto(ReadableArchive source, WritableArchive target, Vector entriesToSkip) throws IOException {
        this.copyInto(source, target, entriesToSkip, true);
    }

    public void copyInto(ReadableArchive source, WritableArchive target, Vector entriesToSkip, boolean overwriteManifest) throws IOException {
        Manifest m;
        this.copyJarElements(source, target, entriesToSkip);
        if (overwriteManifest && (m = source.getManifest()) != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAnEntry(ReadableArchive in, WritableArchive out, String entryName) throws IOException {
        InputStream is = null;
        InputStream is2 = null;
        ReadableArchive in2 = this.archiveFactory.openArchive(out.getURI());
        try {
            is = in.getEntry(entryName);
            is2 = in2.getEntry(entryName);
            if (is != null && is2 == null) {
                OutputStream os = out.putNextEntry(entryName);
                ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
            }
        }
        finally {
            in2.close();
            if (is != null) {
                is.close();
            }
            if (is2 != null) {
                is2.close();
            }
            out.closeEntry();
        }
    }

    public void copyStandardDeploymentDescriptors(ReadableArchive in, WritableArchive out) throws IOException {
        String entryName = this.getDeploymentDescriptorPath();
        this.copyAnEntry(in, out, entryName);
    }

    public void copyExtraElements(ReadableArchive in, WritableArchive out) throws IOException {
        Enumeration entries = in.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (anEntry.endsWith("META-INF/persistence.xml") || !anEntry.contains(WSDL) && !anEntry.contains(XML) && !anEntry.contains(XSD)) continue;
                this.copyAnEntry(in, out, anEntry);
            }
        }
    }

    public Object readMetaInfo(ReadableArchive archive) {
        return null;
    }

    protected boolean isProcessAnnotation(BundleDescriptor descriptor) {
        boolean isFull = false;
        if (!processAnnotationForOldDD) {
            isFull = descriptor.isFullFlag();
        }
        return !isFull && this.annotationProcessingRequested && this.classLoader != null;
    }

    public Vector getAllWebservicesDeploymentDescriptorPaths() {
        Vector<String> allDescPaths = new Vector<String>();
        allDescPaths.add("WEB-INF/webservices.xml");
        allDescPaths.add("META-INF/webservices.xml");
        return allDescPaths;
    }
}

