/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.PersistenceDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.xml.sax.SAXParseException;

public abstract class PersistenceArchivist
extends ExtensionsArchivist {
    protected static final String JAR_EXT = ".jar";
    protected static final char SEPERATOR_CHAR = '/';
    public static final Logger deplLogger = DOLUtils.deplLogger;
    @LogMessageInfo(message="Exception caught:  {0} for the subarchve indicated by the path:  {1}.", cause="An exception was caught when the subarchive was opened because the subarchive was not present.", action="Correct the archive so that the subarchive is present.", level="SEVERE")
    private static final String EXCEPTION_CAUGHT = "AS-DEPLOYMENT-00004";

    @Override
    public DeploymentDescriptorFile getStandardDDFile(RootDeploymentDescriptor descriptor) {
        if (this.standardDD == null) {
            this.standardDD = new PersistenceDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    @Override
    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles(RootDeploymentDescriptor descriptor) {
        return Collections.emptyList();
    }

    @Override
    public abstract boolean supportsModuleType(ArchiveType var1);

    @Override
    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        String puRoot = this.getPuRoot(archive);
        this.readPersistenceDeploymentDescriptor(main, archive, puRoot, descriptor);
        return null;
    }

    public static boolean isProbablePuRootJar(String path) {
        return PersistenceArchivist.isJarEntry(path) && PersistenceArchivist.checkIsInRootOfArchive(path);
    }

    private static boolean checkIsInRootOfArchive(String path) {
        return path.indexOf(47) == -1;
    }

    private static boolean isJarEntry(String path) {
        return path.endsWith(JAR_EXT);
    }

    protected PersistenceUnitsDescriptor readPersistenceDeploymentDescriptor(Archivist main, ReadableArchive subArchive, String puRoot, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        String subArchiveURI = subArchive.getURI().getSchemeSpecificPart();
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PURoot = [{0}] subArchive = {1}", new Object[]{puRoot, subArchiveURI});
        }
        if (descriptor.getExtensionsDescriptors(PersistenceUnitsDescriptor.class, puRoot) != null) {
            if (deplLogger.isLoggable(Level.FINE)) {
                deplLogger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PU has been already read for = {0}", subArchiveURI);
            }
            return null;
        }
        PersistenceUnitsDescriptor persistenceUnitsDescriptor = (PersistenceUnitsDescriptor)((Object)PersistenceUnitsDescriptor.class.cast(super.open(main, subArchive, descriptor)));
        if (persistenceUnitsDescriptor != null) {
            persistenceUnitsDescriptor.setParent(descriptor);
            persistenceUnitsDescriptor.setPuRoot(puRoot);
            descriptor.addExtensionDescriptor(PersistenceUnitsDescriptor.class, (RootDeploymentDescriptor)persistenceUnitsDescriptor, puRoot);
        }
        return persistenceUnitsDescriptor;
    }

    @Override
    public <T extends RootDeploymentDescriptor> T getDefaultDescriptor() {
        return null;
    }

    protected static Map<String, ReadableArchive> getProbablePersistenceRoots(ReadableArchive parentArchive, SubArchivePURootScanner subArchivePURootScanner) {
        HashMap<String, ReadableArchive> probablePersitenceArchives = new HashMap<String, ReadableArchive>();
        ReadableArchive archiveToScan = subArchivePURootScanner.getSubArchiveToScan(parentArchive);
        if (archiveToScan != null) {
            Enumeration entries = archiveToScan.entries();
            String puRootPrefix = subArchivePURootScanner.getPurRootPrefix();
            while (entries.hasMoreElements()) {
                ReadableArchive puRootArchive;
                String entry = (String)entries.nextElement();
                if (!subArchivePURootScanner.isProbablePuRootJar(entry) || (puRootArchive = PersistenceArchivist.getSubArchive(archiveToScan, entry, false)) == null) continue;
                String puRoot = puRootPrefix + entry;
                probablePersitenceArchives.put(puRoot, puRootArchive);
            }
        }
        return probablePersitenceArchives;
    }

    private static ReadableArchive getSubArchive(ReadableArchive parentArchive, String path, boolean expectAbscenceOfSubArchive) {
        ReadableArchive returnedArchive;
        block2: {
            returnedArchive = null;
            try {
                returnedArchive = parentArchive.getSubArchive(path);
            }
            catch (IOException ioe) {
                if (expectAbscenceOfSubArchive) break block2;
                LogRecord lr = new LogRecord(Level.SEVERE, EXCEPTION_CAUGHT);
                Object[] args = new Object[]{ioe.getMessage(), path};
                lr.setParameters(args);
                lr.setThrown(ioe);
                deplLogger.log(lr);
            }
        }
        return returnedArchive;
    }

    protected String getPuRoot(ReadableArchive archive) {
        assert (false);
        return null;
    }

    @Override
    public void writeDeploymentDescriptors(Archivist main, BundleDescriptor descriptor, ReadableArchive in, WritableArchive out) throws IOException {
    }

    protected static abstract class SubArchivePURootScanner {
        protected SubArchivePURootScanner() {
        }

        abstract String getPathOfSubArchiveToScan();

        ReadableArchive getSubArchiveToScan(ReadableArchive parentArchive) {
            String pathOfSubArchiveToScan = this.getPathOfSubArchiveToScan();
            return pathOfSubArchiveToScan == null || pathOfSubArchiveToScan.isEmpty() ? parentArchive : PersistenceArchivist.getSubArchive(parentArchive, pathOfSubArchiveToScan, true);
        }

        String getPurRootPrefix() {
            String pathOfSubArchiveToScan = this.getPathOfSubArchiveToScan();
            return pathOfSubArchiveToScan == null || pathOfSubArchiveToScan.isEmpty() ? pathOfSubArchiveToScan : pathOfSubArchiveToScan + "/";
        }

        boolean isProbablePuRootJar(String jarName) {
            boolean probablePuRootJar = PersistenceArchivist.isProbablePuRootJar(jarName);
            if (!probablePuRootJar && PersistenceArchivist.isJarEntry(jarName) && deplLogger.isLoggable(Level.FINE)) {
                deplLogger.logp(Level.FINE, "PersistenceArchivist", "readPersistenceDeploymentDescriptors", "skipping {0} as it exists inside a directory in {1}.", new Object[]{jarName, this.getPathOfSubArchiveToScan()});
            }
            return probablePuRootJar;
        }
    }
}

