/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import fish.payara.admin.amx.config.AMXConfiguration;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.jmx.monitoring.JMXMonitoringService;
import fish.payara.jmx.monitoring.configuration.MonitoredAttribute;
import fish.payara.jmx.monitoring.configuration.MonitoringServiceConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-jmx-monitoring-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.jmx.monitoring.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-jmx-monitoring-configuration", description="Set JMX Monitoring Configuration")})
public class SetJMXMonitoringConfiguration
implements AdminCommand {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    protected Target targetUtil;
    @Inject
    JMXMonitoringService jmxMonitoringService;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Deprecated
    @Param(name="amx", optional=true)
    private Boolean amx;
    @Param(name="logfrequency", optional=true)
    private String logfrequency;
    @Param(name="logfrequencyunit", optional=true, acceptableValues="NANOSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS")
    private String logfrequencyunit;
    @Param(name="addattribute", optional=true, multiple=true, alias="addproperty")
    private List<String> attributesToAdd;
    @Param(name="delattribute", optional=true, multiple=true, alias="delproperty")
    private List<String> attributesToRemove;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Param(name="enableNotifiers", alias="enable-notifiers", optional=true)
    private List<String> enableNotifiers;
    @Param(name="disableNotifiers", alias="disable-notifiers", optional=true)
    private List<String> disableNotifiers;
    @Param(name="setNotifiers", alias="set-notifiers", optional=true)
    private List<String> setNotifiers;
    @Inject
    protected Logger logger;
    private MonitoringServiceConfiguration jmxMonitoringConfig;

    public void execute(AdminCommandContext context) {
        JMXMonitoringService jmxMonitoringService;
        final ActionReport actionReport = context.getActionReport();
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            actionReport.setMessage("Cound not find target: " + this.target);
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if ((jmxMonitoringService = (JMXMonitoringService)this.serviceLocator.getService(JMXMonitoringService.class, new Annotation[0])) == null) {
            actionReport.appendMessage("Could not find a monitoring service.");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.jmxMonitoringConfig = (MonitoringServiceConfiguration)config.getExtensionByType(MonitoringServiceConfiguration.class);
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringServiceConfiguration>(){

                public Object run(MonitoringServiceConfiguration monitoringConfigProxy) throws PropertyVetoException, TransactionFailure {
                    SetJMXMonitoringConfiguration.this.updateConfiguration(monitoringConfigProxy);
                    SetJMXMonitoringConfiguration.this.updateAttributes(monitoringConfigProxy, actionReport);
                    actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return monitoringConfigProxy;
                }
            }, (ConfigBeanProxy)this.jmxMonitoringConfig);
            if (this.dynamic.booleanValue()) {
                this.enableOnTarget(actionReport, context, this.enabled);
            }
            if (this.enabled != null && this.enabled.booleanValue()) {
                MonitoringService monitoringService = config.getMonitoringService();
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MonitoringService>(){

                    public Object run(MonitoringService monitoringServiceProxy) throws PropertyVetoException, TransactionFailure {
                        monitoringServiceProxy.setMbeanEnabled(String.valueOf(SetJMXMonitoringConfiguration.this.enabled));
                        return monitoringServiceProxy;
                    }
                }, (ConfigBeanProxy)monitoringService);
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Falied to excute the command set-jmx-monitoring-configuration: " + ex.getCause().getMessage());
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void updateConfiguration(MonitoringServiceConfiguration monitoringConfig) throws PropertyVetoException, TransactionFailure {
        if (null != this.enabled) {
            monitoringConfig.setEnabled(String.valueOf(this.enabled));
        }
        if (null != this.amx) {
            AMXConfiguration amxConfig = (AMXConfiguration)this.serviceLocator.getService(AMXConfiguration.class, new Annotation[0]);
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AMXConfiguration>(){

                public Object run(AMXConfiguration amxConfigProxy) throws PropertyVetoException, TransactionFailure {
                    amxConfigProxy.setEnabled(String.valueOf(SetJMXMonitoringConfiguration.this.amx));
                    return amxConfigProxy;
                }
            }, (ConfigBeanProxy)amxConfig);
            monitoringConfig.setAmx(null);
        }
        if (null != this.logfrequency) {
            monitoringConfig.setLogFrequency(this.logfrequency);
        }
        if (null != this.logfrequencyunit) {
            monitoringConfig.setLogFrequencyUnit(this.logfrequencyunit);
        }
        Set notifierNames = NotifierUtils.getNotifierNames((ServiceLocator)this.serviceLocator);
        List<String> notifiers = monitoringConfig.getNotifierList();
        if (this.enableNotifiers != null) {
            for (String notifier : this.enableNotifiers) {
                if (notifierNames.contains(notifier)) {
                    if (notifiers.contains(notifier)) continue;
                    notifiers.add(notifier);
                    continue;
                }
                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(monitoringConfig, "notifiers", notifiers, notifiers));
            }
        }
        if (this.disableNotifiers != null) {
            for (String notifier : this.disableNotifiers) {
                if (notifierNames.contains(notifier)) {
                    notifiers.remove(notifier);
                    continue;
                }
                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(monitoringConfig, "notifiers", notifiers, notifiers));
            }
        }
        if (this.setNotifiers != null) {
            notifiers.clear();
            for (String notifier : this.setNotifiers) {
                if (notifierNames.contains(notifier)) {
                    if (notifiers.contains(notifier)) continue;
                    notifiers.add(notifier);
                    continue;
                }
                throw new PropertyVetoException("Unrecognised notifier " + notifier, new PropertyChangeEvent(monitoringConfig, "notifiers", notifiers, notifiers));
            }
        }
    }

    private void enableOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        CommandRunner.CommandInvocation invocation = this.target.equals("server-config") ? runner.getCommandInvocation("__enable-jmx-monitoring-service-on-das", subReport, context.getSubject()) : runner.getCommandInvocation("__enable-jmx-monitoring-service-on-instance", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        enabled = Boolean.valueOf(this.jmxMonitoringConfig.getEnabled());
        params.add((Object)"enabled", (Object)enabled.toString());
        params.add((Object)"target", (Object)this.target);
        invocation.parameters(params);
        invocation.execute();
    }

    private void updateAttributes(MonitoringServiceConfiguration monitoringConfig, ActionReport report) throws PropertyVetoException, TransactionFailure {
        MonitoredAttribute monitoredAttribute;
        List<MonitoredAttribute> attributes = monitoringConfig.getMonitoredAttributes();
        if (this.attributesToRemove != null && !this.attributesToRemove.isEmpty()) {
            for (String attributeToRemove : this.attributesToRemove) {
                monitoredAttribute = this.parseToMonitoredAttribute(attributeToRemove, (MonitoredAttribute)monitoringConfig.createChild(MonitoredAttribute.class));
                boolean removed = false;
                for (MonitoredAttribute attribute : attributes) {
                    if (!attribute.equals(monitoredAttribute)) continue;
                    attributes.remove(attribute);
                    report.appendMessage(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attribute.remove", "Attribute 'objectName={0} attributeName={1}' successfully deleted.", new Object[]{monitoredAttribute.getObjectName(), monitoredAttribute.getAttributeName()}) + "\n");
                    removed = true;
                    break;
                }
                if (removed) continue;
                report.appendMessage(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attribute.remove.error", "Attribute 'objectName={0} attributeName={1}' doesn't exist, so was ignored.", new Object[]{monitoredAttribute.getObjectName(), monitoredAttribute.getAttributeName()}) + "\n");
            }
        }
        if (this.attributesToAdd != null && !this.attributesToAdd.isEmpty()) {
            for (String attributeToAdd : this.attributesToAdd) {
                monitoredAttribute = this.parseToMonitoredAttribute(attributeToAdd, (MonitoredAttribute)monitoringConfig.createChild(MonitoredAttribute.class));
                boolean attributeExists = false;
                for (MonitoredAttribute attribute : attributes) {
                    if (!attribute.equals(monitoredAttribute)) continue;
                    attributeExists = true;
                    report.appendMessage(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attribute.add.error", "Attribute 'objectName={0} attributeName={1}' already exists, so was ignored.", new Object[]{monitoredAttribute.getObjectName(), monitoredAttribute.getAttributeName()}) + "\n");
                    break;
                }
                if (attributeExists) continue;
                attributes.add(monitoredAttribute);
                report.appendMessage(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attribute.add", "Attribute 'objectName={0} attributeName={1}' successfully added.", new Object[]{monitoredAttribute.getObjectName(), monitoredAttribute.getAttributeName()}) + "\n");
            }
        }
    }

    private MonitoredAttribute parseToMonitoredAttribute(String input, MonitoredAttribute monitoredAttribute) throws PropertyVetoException {
        String[] attributeTokens = input.split("(?=objectName ?=)|(?=attributeName ?=)|(?=description ?=)");
        String attributeName = null;
        String objectName = null;
        String description = null;
        if (attributeTokens.length < 2) {
            throw new IllegalArgumentException(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attributes.too.few", "Too few properties. Required properties are 'objectName' and 'attributeName'."));
        }
        block12: for (String token : attributeTokens) {
            String[] param = (token = token.replaceAll("\\\\", "")).split("=", 2);
            if (param.length != 2) {
                throw new IllegalArgumentException(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attributes.too.few", "Too few properties. Required properties are 'objectName' and 'attributeName'."));
            }
            switch (param[0]) {
                case "attributeName": 
                case "name": {
                    attributeName = param[1].trim();
                    continue block12;
                }
                case "objectName": 
                case "value": {
                    objectName = param[1].trim();
                    continue block12;
                }
                case "description": {
                    description = param[1].trim();
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attributes.unknown", "Unknown property: {0}. Valid properties are: 'objectName', 'attributeName' and 'description'.", new Object[]{param[0]}));
                }
            }
        }
        if (attributeName == null || attributeName.isEmpty()) {
            throw new IllegalArgumentException(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attributes.invalid", "Invalid property: {0}.", new Object[]{"attributeName"}));
        }
        if (objectName == null || objectName.isEmpty()) {
            throw new IllegalArgumentException(this.jmxMonitoringService.getLocalStringManager().getLocalString("jmxmonitoring.configure.attributes.invalid", "Invalid property: {0}.", new Object[]{"objectName"}));
        }
        monitoredAttribute.setAttributeName(attributeName);
        monitoredAttribute.setObjectName(objectName);
        if (description != null) {
            monitoredAttribute.setDescription(description);
        }
        return monitoredAttribute;
    }
}

