/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.runtime.ContextSetupProviderImpl;
import org.glassfish.concurrent.runtime.TransactionSetupProviderImpl;
import org.glassfish.concurrent.runtime.deployer.ContextServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedScheduledExecutorServiceConfig;
import org.glassfish.concurrent.runtime.deployer.ManagedThreadFactoryConfig;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ConcurrentRuntime
implements PostConstruct,
PreDestroy {
    private static ConcurrentRuntime _runtime;
    private Map<String, ManagedExecutorServiceImpl> managedExecutorServiceMap;
    private Map<String, ManagedScheduledExecutorServiceImpl> managedScheduledExecutorServiceMap;
    private Map<String, ContextServiceImpl> contextServiceMap = new HashMap<String, ContextServiceImpl>();
    private Map<String, ManagedThreadFactoryImpl> managedThreadFactoryMap;
    public static final String CONTEXT_INFO_CLASSLOADER = "Classloader";
    public static final String CONTEXT_INFO_JNDI = "JNDI";
    public static final String CONTEXT_INFO_SECURITY = "Security";
    public static final String CONTEXT_INFO_WORKAREA = "WorkArea";
    public static final String CONTEXT_INFO_ALL = "Classloader,JNDI,Security,WorkArea";
    private ScheduledExecutorService internalScheduler;
    private static final Logger logger;
    @Inject
    InvocationManager invocationManager;
    @Inject
    Deployment deployment;
    @Inject
    Applications applications;
    @Inject
    JavaEETransactionManager transactionManager;
    @Inject
    ApplicationRegistry applicationRegistry;
    @Inject
    ComponentEnvManager compEnvMgr;
    @Inject
    private ResourceNamingService resourceNamingService;

    public static ConcurrentRuntime getRuntime() {
        if (_runtime == null) {
            throw new RuntimeException("ConcurrentRuntime not initialized");
        }
        return _runtime;
    }

    private static void setRuntime(ConcurrentRuntime runtime) {
        _runtime = runtime;
    }

    ConcurrentRuntime() {
        ConcurrentRuntime.setRuntime(this);
    }

    InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    Applications getApplications() {
        return this.applications;
    }

    JavaEETransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    ApplicationRegistry getApplicationRegistry() {
        return this.applicationRegistry;
    }

    public ComponentEnvManager getCompEnvMgr() {
        return this.compEnvMgr;
    }

    public synchronized ContextServiceImpl getContextService(ResourceInfo resource, ContextServiceConfig config) {
        String jndiName = config.getJndiName();
        if (this.contextServiceMap != null && this.contextServiceMap.containsKey(jndiName)) {
            return this.contextServiceMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.createContextService(resource, config);
        if (this.contextServiceMap == null) {
            this.contextServiceMap = new HashMap<String, ContextServiceImpl>();
        }
        this.contextServiceMap.put(jndiName, contextService);
        return contextService;
    }

    public synchronized ContextServiceImpl createContextService(ResourceInfo resource, ContextServiceConfig config) {
        ContextServiceImpl contextService = this.createContextServiceImpl(config.getJndiName(), config.isContextInfoEnabledBoolean(), config.getPropagatedContexts(), config.getClearedContexts(), config.getUchangedContexts());
        return contextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownContextService(String jndiName) {
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.contextServiceMap != null) {
                this.contextServiceMap.remove(jndiName);
            }
        }
    }

    public synchronized ManagedExecutorServiceImpl getManagedExecutorService(ResourceInfo resourceInfo, ManagedExecutorServiceConfig config) {
        String jndiName = config.getJndiName();
        if (this.managedExecutorServiceMap != null && this.managedExecutorServiceMap.containsKey(jndiName)) {
            return this.managedExecutorServiceMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.prepareContextService(ConcurrentRuntime.createContextServiceName(config.getContext(), config.getJndiName()), config.getContextInfo(), config.isContextInfoEnabledBoolean(), true);
        ManagedExecutorServiceImpl mes = this.createManagedExecutorService(resourceInfo, config, contextService);
        if (this.managedExecutorServiceMap == null) {
            this.managedExecutorServiceMap = new HashMap<String, ManagedExecutorServiceImpl>();
        }
        this.managedExecutorServiceMap.put(jndiName, mes);
        return mes;
    }

    public synchronized ManagedExecutorServiceImpl createManagedExecutorService(ResourceInfo resourceInfo, ManagedExecutorServiceConfig config, ContextServiceImpl contextService) {
        ThreadFactoryWrapper managedThreadFactory = new ThreadFactoryWrapper(config.getJndiName() + "-managedThreadFactory", null, config.getThreadPriority());
        ManagedExecutorServiceImpl mes = new ManagedExecutorServiceImpl(config.getJndiName(), (ManagedThreadFactoryImpl)managedThreadFactory, (long)config.getHungAfterSeconds() * 1000L, config.isLongRunningTasks(), config.getUseForkJoinPool(), config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveSeconds(), TimeUnit.SECONDS, config.getThreadLifeTimeSeconds(), config.getTaskQueueCapacity(), contextService, AbstractManagedExecutorService.RejectPolicy.ABORT);
        if ((long)config.getHungAfterSeconds() > 0L && !config.isLongRunningTasks()) {
            this.scheduleInternalTimer();
        }
        return mes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownManagedExecutorService(String jndiName) {
        ManagedExecutorServiceImpl mes = null;
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.managedExecutorServiceMap != null) {
                mes = this.managedExecutorServiceMap.remove(jndiName);
            }
        }
        if (mes != null) {
            mes.shutdownNow();
        }
    }

    public synchronized ManagedScheduledExecutorServiceImpl getManagedScheduledExecutorService(ResourceInfo resource, ManagedScheduledExecutorServiceConfig config) {
        String jndiName = config.getJndiName();
        if (this.managedScheduledExecutorServiceMap != null && this.managedScheduledExecutorServiceMap.containsKey(jndiName)) {
            return this.managedScheduledExecutorServiceMap.get(jndiName);
        }
        ContextServiceImpl contextService = this.prepareContextService(ConcurrentRuntime.createContextServiceName(config.getContext(), config.getJndiName()), config.getContextInfo(), config.isContextInfoEnabledBoolean(), true);
        ManagedScheduledExecutorServiceImpl mes = this.createManagedScheduledExecutorService(resource, config, contextService);
        if (this.managedScheduledExecutorServiceMap == null) {
            this.managedScheduledExecutorServiceMap = new HashMap<String, ManagedScheduledExecutorServiceImpl>();
        }
        this.managedScheduledExecutorServiceMap.put(jndiName, mes);
        if ((long)config.getHungAfterSeconds() > 0L && !config.isLongRunningTasks()) {
            this.scheduleInternalTimer();
        }
        return mes;
    }

    public ManagedScheduledExecutorServiceImpl createManagedScheduledExecutorService(ResourceInfo resource, ManagedScheduledExecutorServiceConfig config, ContextServiceImpl contextService) {
        ThreadFactoryWrapper managedThreadFactory = new ThreadFactoryWrapper(config.getJndiName() + "-managedThreadFactory", null, config.getThreadPriority());
        ManagedScheduledExecutorServiceImpl mes = new ManagedScheduledExecutorServiceImpl(config.getJndiName(), (ManagedThreadFactoryImpl)managedThreadFactory, (long)config.getHungAfterSeconds() * 1000L, config.isLongRunningTasks(), config.getCorePoolSize(), config.getKeepAliveSeconds(), TimeUnit.SECONDS, config.getThreadLifeTimeSeconds(), contextService, AbstractManagedExecutorService.RejectPolicy.ABORT);
        return mes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownScheduledManagedExecutorService(String jndiName) {
        ManagedScheduledExecutorServiceImpl mses = null;
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.managedScheduledExecutorServiceMap != null) {
                mses = this.managedScheduledExecutorServiceMap.remove(jndiName);
            }
        }
        if (mses != null) {
            mses.shutdownNow();
        }
    }

    public synchronized ManagedThreadFactoryImpl getManagedThreadFactory(ResourceInfo resource, ManagedThreadFactoryConfig config) {
        String jndiName = config.getJndiName();
        if (this.managedThreadFactoryMap != null && this.managedThreadFactoryMap.containsKey(jndiName)) {
            return this.managedThreadFactoryMap.get(jndiName);
        }
        String context = config.getContext();
        ContextServiceImpl contextService = this.prepareContextService(ConcurrentRuntime.createContextServiceName(context, config.getJndiName()), config.getContextInfo(), config.isContextInfoEnabledBoolean(), true);
        ManagedThreadFactoryImpl managedThreadFactory = this.createManagedThreadFactory(resource, config, contextService);
        if (this.managedThreadFactoryMap == null) {
            this.managedThreadFactoryMap = new HashMap<String, ManagedThreadFactoryImpl>();
        }
        this.managedThreadFactoryMap.put(jndiName, managedThreadFactory);
        return managedThreadFactory;
    }

    public ManagedThreadFactoryImpl createManagedThreadFactory(ResourceInfo resource, ManagedThreadFactoryConfig config, ContextServiceImpl contextService) {
        ThreadFactoryWrapper managedThreadFactory = new ThreadFactoryWrapper(config.getJndiName(), contextService, config.getThreadPriority());
        return managedThreadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownManagedThreadFactory(String jndiName) {
        ManagedThreadFactoryImpl mtf = null;
        ConcurrentRuntime concurrentRuntime = this;
        synchronized (concurrentRuntime) {
            if (this.managedThreadFactoryMap != null) {
                mtf = this.managedThreadFactoryMap.remove(jndiName);
            }
        }
        if (mtf != null) {
            mtf.stop();
        }
    }

    private ContextServiceImpl prepareContextService(String contextServiceJndiName, String contextInfo, boolean contextInfoEnabled, boolean cleanupTransaction) {
        ContextServiceImpl contextService = this.contextServiceMap.get(contextServiceJndiName);
        if (contextService == null) {
            Set<String> propagated = ContextServiceConfig.parseContextInfo(contextInfo, contextInfoEnabled);
            Set<String> cleared = Collections.EMPTY_SET;
            if (cleanupTransaction && !propagated.contains("WORKAREA")) {
                cleared = Set.of("WORKAREA");
            }
            contextService = this.createContextServiceImpl(contextServiceJndiName, contextInfoEnabled, propagated, cleared, Collections.EMPTY_SET);
            this.contextServiceMap.put(contextServiceJndiName, contextService);
        }
        return contextService;
    }

    private ContextServiceImpl createContextServiceImpl(String jndiName, boolean isContextInfoEnabled, Set<String> propagated, Set<String> cleared, Set<String> unchanged) {
        ContextSetupProviderImpl contextSetupProvider = new ContextSetupProviderImpl(this.invocationManager, this.deployment, this.compEnvMgr, this.applicationRegistry, this.applications, this.transactionManager, propagated, cleared, unchanged);
        ContextServiceImpl contextService = new ContextServiceImpl(jndiName, (ContextSetupProvider)contextSetupProvider, (TransactionSetupProvider)new TransactionSetupProviderImpl(this.transactionManager, unchanged.contains("WORKAREA"), cleared.contains("WORKAREA")));
        return contextService;
    }

    private void scheduleInternalTimer() {
        if (this.internalScheduler == null) {
            String name = "glassfish-internal";
            ThreadFactoryWrapper managedThreadFactory = new ThreadFactoryWrapper(name + "-managedThreadFactory", null, 5);
            this.internalScheduler = new ManagedScheduledExecutorServiceImpl(name, (ManagedThreadFactoryImpl)managedThreadFactory, 0L, false, 1, 60L, TimeUnit.SECONDS, 0L, this.prepareContextService(ConcurrentRuntime.createContextServiceName(null, name), CONTEXT_INFO_CLASSLOADER, true, false), AbstractManagedExecutorService.RejectPolicy.ABORT);
            this.internalScheduler.scheduleAtFixedRate(new HungTasksLogger(), 1L, 1L, TimeUnit.MINUTES);
        }
    }

    public static String createContextServiceName(String configuredContextJndiName, String parentObjectJndiName) {
        Object contextServiceJndiName = configuredContextJndiName;
        if (contextServiceJndiName == null) {
            contextServiceJndiName = parentObjectJndiName + "-contextservice";
        }
        return contextServiceJndiName;
    }

    public ContextServiceImpl findOrCreateContextService(String configuredContextJndiName, String parentObjectJndiName, String applicationName, String moduleName) {
        ContextServiceImpl contextService;
        String contextOfResource = ConcurrentRuntime.createContextServiceName(configuredContextJndiName, parentObjectJndiName);
        ResourceInfo contextResourceInfo = new ResourceInfo(contextOfResource, applicationName, moduleName);
        try {
            contextService = (ContextServiceImpl)this.resourceNamingService.lookup((GenericResourceInfo)contextResourceInfo, contextOfResource);
        }
        catch (NamingException e) {
            contextService = this.prepareContextService(contextOfResource, CONTEXT_INFO_ALL, true, true);
        }
        return contextService;
    }

    public void postConstruct() {
    }

    public void preDestroy() {
    }

    static {
        logger = LogFacade.getLogger();
    }

    class HungTasksLogger
    implements Runnable {
        HungTasksLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection hungThreads;
            ArrayList<ManagedExecutorServiceImpl> executorServices = new ArrayList<ManagedExecutorServiceImpl>();
            ArrayList<ManagedScheduledExecutorServiceImpl> scheduledExecutorServices = new ArrayList<ManagedScheduledExecutorServiceImpl>();
            Iterator iterator = ConcurrentRuntime.this;
            synchronized (iterator) {
                if (ConcurrentRuntime.this.managedExecutorServiceMap != null) {
                    Collection<ManagedExecutorServiceImpl> mesColl = ConcurrentRuntime.this.managedExecutorServiceMap.values();
                    executorServices.addAll(mesColl);
                }
            }
            iterator = ConcurrentRuntime.this;
            synchronized (iterator) {
                if (ConcurrentRuntime.this.managedScheduledExecutorServiceMap != null) {
                    Collection<ManagedScheduledExecutorServiceImpl> msesColl = ConcurrentRuntime.this.managedScheduledExecutorServiceMap.values();
                    scheduledExecutorServices.addAll(msesColl);
                }
            }
            for (ManagedExecutorServiceImpl mes : executorServices) {
                hungThreads = mes.getHungThreads();
                this.logHungThreads(hungThreads, mes.getManagedThreadFactory(), mes.getName());
            }
            for (ManagedScheduledExecutorServiceImpl mses : scheduledExecutorServices) {
                hungThreads = mses.getHungThreads();
                this.logHungThreads(hungThreads, mses.getManagedThreadFactory(), mses.getName());
            }
        }

        private void logHungThreads(Collection<AbstractManagedThread> hungThreads, ManagedThreadFactoryImpl mtf, String mesName) {
            if (hungThreads != null) {
                for (AbstractManagedThread hungThread : hungThreads) {
                    Object[] params = new Object[]{hungThread.getTaskIdentityName(), hungThread.getName(), hungThread.getTaskRunTime(System.currentTimeMillis()) / 1000L, mtf.getHungTaskThreshold() / 1000L, mesName};
                    logger.log(Level.WARNING, "AS-CONCURRENT-00001", params);
                }
            }
        }
    }

    private static final class ThreadFactoryWrapper
    extends ManagedThreadFactoryImpl {
        public ThreadFactoryWrapper(String string, ContextServiceImpl contextService, int threadPriority) {
            super(string, contextService, threadPriority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected AbstractManagedThread createThread(Runnable r, ContextHandle contextHandleForSetup) {
            ClassLoader appClassLoader = Utility.getClassLoader();
            Utility.setContextClassLoader(null);
            try {
                AbstractManagedThread abstractManagedThread = super.createThread(r, contextHandleForSetup);
                return abstractManagedThread;
            }
            finally {
                Utility.setContextClassLoader(appClassLoader);
            }
        }
    }
}

