/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.Utility;
import fish.payara.nucleus.healthcheck.stuck.StuckThreadsStore;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.Tracer;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.InvocationContext;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;

public class ContextSetupProviderImpl
implements ContextSetupProvider {
    private transient InvocationManager invocationManager;
    private transient Deployment deployment;
    private transient ComponentEnvManager compEnvMgr;
    private transient ApplicationRegistry applicationRegistry;
    private transient Applications applications;
    private transient JavaEETransactionManager transactionManager;
    private static final Logger logger = LogFacade.getLogger();
    static final long serialVersionUID = -1095988075917755802L;
    public static final String CONTEXT_TYPE_CLASSLOADING = "CLASSLOADING";
    public static final String CONTEXT_TYPE_SECURITY = "SECURITY";
    public static final String CONTEXT_TYPE_NAMING = "NAMING";
    public static final String CONTEXT_TYPE_WORKAREA = "WORKAREA";
    private boolean classloading;
    private boolean security;
    private boolean naming;
    private boolean workArea;
    private final Set<String> contextPropagate;
    private final Set<String> contextClear;
    private final Set<String> contextUnchanged;
    private Map<String, ThreadContextProvider> allThreadContextProviders = null;
    private final Set<String> allRemaining;
    private transient RequestTracingService requestTracing;
    private transient OpenTracingService openTracing;
    private transient StuckThreadsStore stuckThreads;

    public ContextSetupProviderImpl(InvocationManager invocationManager, Deployment deployment, ComponentEnvManager compEnvMgr, ApplicationRegistry applicationRegistry, Applications applications, JavaEETransactionManager transactionManager, Set<String> propagated, Set<String> cleared, Set<String> unchanged) {
        this.invocationManager = invocationManager;
        this.deployment = deployment;
        this.compEnvMgr = compEnvMgr;
        this.applicationRegistry = applicationRegistry;
        this.applications = applications;
        this.transactionManager = transactionManager;
        this.contextPropagate = new HashSet<String>(propagated);
        this.contextClear = new HashSet<String>(cleared);
        this.contextUnchanged = new HashSet<String>(unchanged);
        this.allRemaining = this.contextPropagate.contains("Remaining") ? this.contextPropagate : (this.contextClear.contains("Remaining") ? this.contextClear : (this.contextUnchanged.contains("Remaining") ? this.contextUnchanged : this.contextPropagate));
        this.addToRemainingIfNotPresent(CONTEXT_TYPE_CLASSLOADING);
        this.addToRemainingIfNotPresent(CONTEXT_TYPE_SECURITY);
        this.addToRemainingIfNotPresent(CONTEXT_TYPE_NAMING);
        this.addToRemainingIfNotPresent(CONTEXT_TYPE_WORKAREA);
        this.initialiseServices();
        Iterator<String> iterator = this.contextPropagate.iterator();
        while (iterator.hasNext()) {
            String contextType;
            switch (contextType = iterator.next()) {
                case "CLASSLOADING": {
                    this.classloading = true;
                    break;
                }
                case "SECURITY": {
                    this.security = true;
                    break;
                }
                case "NAMING": {
                    this.naming = true;
                    break;
                }
                case "WORKAREA": {
                    this.workArea = true;
                }
            }
        }
    }

    public ContextHandle saveContext(ContextService contextService) {
        return this.saveContext(contextService, null);
    }

    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        ClassLoader contextClassloader = null;
        SecurityContext currentSecurityContext = null;
        ComponentInvocation savedInvocation = null;
        if (this.classloading) {
            contextClassloader = Utility.getClassLoader();
        }
        if (this.security) {
            currentSecurityContext = SecurityContext.getCurrent();
        }
        this.allThreadContextProviders = new HashMap<String, ThreadContextProvider>();
        for (ThreadContextProvider service : ServiceLoader.load(ThreadContextProvider.class, Utility.getClassLoader())) {
            String serviceName = service.getThreadContextType();
            if (this.contextPropagate.contains(serviceName) || this.contextClear.contains(serviceName) || this.contextUnchanged.contains(serviceName)) {
                this.allThreadContextProviders.put(serviceName, service);
                continue;
            }
            if (this.allRemaining == null) continue;
            this.allRemaining.add(serviceName);
            this.allThreadContextProviders.put(serviceName, service);
        }
        Set<String> verifiedContextPropagate = this.filterVerifiedProviders(this.contextPropagate);
        Set<String> verifiedContextClear = this.filterVerifiedProviders(this.contextClear);
        Set<String> verifiedContextUnchanged = this.filterVerifiedProviders(this.contextUnchanged);
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation != null) {
            if (verifiedContextPropagate.contains(CONTEXT_TYPE_NAMING)) {
                savedInvocation = this.createComponentInvocation(currentInvocation);
            }
            if (verifiedContextClear.contains(CONTEXT_TYPE_NAMING)) {
                savedInvocation = new ComponentInvocation();
            }
        }
        boolean useTransactionOfExecutionThread = this.transactionManager == null && this.useTransactionOfExecutionThread(contextObjectProperties) || verifiedContextUnchanged.contains(CONTEXT_TYPE_WORKAREA);
        ArrayList<ThreadContextSnapshot> threadContextSnapshots = new ArrayList<ThreadContextSnapshot>();
        verifiedContextPropagate.stream().map(provider -> this.allThreadContextProviders.get(provider)).filter(snapshot -> snapshot != null).map(snapshot -> snapshot.currentContext(contextObjectProperties)).forEach(snapshot -> threadContextSnapshots.add((ThreadContextSnapshot)snapshot));
        verifiedContextClear.stream().map(provider -> this.allThreadContextProviders.get(provider)).filter(snapshot -> snapshot != null).map(snapshot -> snapshot.clearedContext(contextObjectProperties)).forEach(snapshot -> threadContextSnapshots.add((ThreadContextSnapshot)snapshot));
        return new InvocationContext(savedInvocation, contextClassloader, currentSecurityContext, useTransactionOfExecutionThread, threadContextSnapshots, Collections.EMPTY_LIST);
    }

    public ContextHandle setup(ContextHandle contextHandle) throws IllegalStateException {
        if (!(contextHandle instanceof InvocationContext)) {
            logger.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return null;
        }
        InvocationContext handle = (InvocationContext)contextHandle;
        String appName = null;
        ComponentInvocation invocation = handle.getInvocation();
        ClassLoader backupClassLoader = null;
        if (invocation != null) {
            Application appInfo;
            JndiNameEnvironment currJndiEnv;
            appName = invocation.getRegistrationName();
            if (appName == null && invocation.getJNDIEnvironment() != null) {
                appName = DOLUtils.getApplicationFromEnv((JndiNameEnvironment)((JndiNameEnvironment)invocation.getJNDIEnvironment())).getRegistrationName();
            }
            if (appName == null && invocation.getComponentId() != null && this.compEnvMgr != null && (currJndiEnv = this.compEnvMgr.getJndiNameEnvironment(invocation.getComponentId())) != null && (appInfo = DOLUtils.getApplicationFromEnv((JndiNameEnvironment)currJndiEnv)) != null) {
                appName = appInfo.getRegistrationName();
                invocation.setJNDIEnvironment((Object)currJndiEnv);
                backupClassLoader = appInfo.getClassLoader();
            }
        }
        if (appName != null && !this.isApplicationEnabled(appName)) {
            throw new IllegalStateException("Module " + appName + " is disabled");
        }
        ClassLoader resetClassLoader = null;
        if (handle.getContextClassLoader() != null) {
            resetClassLoader = Utility.setContextClassLoader(handle.getContextClassLoader());
        } else if (backupClassLoader != null) {
            resetClassLoader = Utility.setContextClassLoader(backupClassLoader);
        }
        SecurityContext resetSecurityContext = null;
        if (handle.getSecurityContext() != null && !this.contextUnchanged.contains(CONTEXT_TYPE_SECURITY)) {
            resetSecurityContext = SecurityContext.getCurrent();
            SecurityContext.setCurrent((SecurityContext)handle.getSecurityContext());
        }
        if (invocation != null) {
            invocation.setResourceTableKey((Object)new PairKey(invocation.getInstance(), Thread.currentThread()));
            this.invocationManager.preInvoke(invocation);
        }
        if (this.transactionManager != null && this.contextClear.contains(CONTEXT_TYPE_WORKAREA)) {
            this.transactionManager.clearThreadTx();
        }
        if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
            this.startConcurrentContextSpan(invocation, handle);
        }
        if (this.stuckThreads != null) {
            this.stuckThreads.registerThread(Long.valueOf(Thread.currentThread().getId()));
        }
        List<ThreadContextRestorer> restorers = Collections.EMPTY_LIST;
        if (handle.getThreadContextSnapshots() != null) {
            restorers = handle.getThreadContextSnapshots().stream().map(snapshot -> snapshot.begin()).collect(Collectors.toList());
        }
        return new InvocationContext(invocation, resetClassLoader, resetSecurityContext, handle.isUseTransactionOfExecutionThread(), Collections.EMPTY_LIST, restorers);
    }

    private void startConcurrentContextSpan(ComponentInvocation invocation, InvocationContext handle) {
        Tracer tracer = this.openTracing.getTracer(this.openTracing.getApplicationName((InvocationManager)Globals.getDefaultBaseServiceLocator().getService(InvocationManager.class, new Annotation[0])));
        Tracer.SpanBuilder builder = tracer.buildSpan("executeConcurrentContext");
        if (handle.getParentTraceContext() != null) {
            builder.asChildOf(handle.getParentTraceContext());
            StreamSupport.stream(handle.getParentTraceContext().baggageItems().spliterator(), false).filter(e -> "operation.name".equals(e.getKey())).forEach(e -> builder.withTag("Parent Operation Name", (String)e.getValue()));
        }
        if (invocation != null) {
            builder.withTag("App Name", invocation.getAppName()).withTag("Component ID", invocation.getComponentId()).withTag("Module Name", invocation.getModuleName());
            Object instance = invocation.getInstance();
            if (instance != null) {
                builder.withTag("Class Name", instance.getClass().getName());
            }
        }
        builder.withTag("Thread Name", Thread.currentThread().getName());
        tracer.activateSpan(builder.start());
    }

    public void reset(ContextHandle contextHandle) {
        if (!(contextHandle instanceof InvocationContext)) {
            logger.log(Level.SEVERE, "AS-CONCURRENT-00002");
            return;
        }
        InvocationContext handle = (InvocationContext)contextHandle;
        for (ThreadContextRestorer restorer : handle.getThreadContextRestorers()) {
            restorer.endContext();
        }
        if (handle.getContextClassLoader() != null) {
            Utility.setContextClassLoader(handle.getContextClassLoader());
        }
        if (handle.getSecurityContext() != null) {
            SecurityContext.setCurrent((SecurityContext)handle.getSecurityContext());
        }
        if (handle.getInvocation() != null) {
            this.invocationManager.postInvoke(((InvocationContext)contextHandle).getInvocation());
        }
        if (this.contextClear.contains(CONTEXT_TYPE_WORKAREA) && this.transactionManager != null) {
            JavaEETransaction transaction = this.transactionManager.getCurrentTransaction();
            if (transaction != null) {
                try {
                    int status = transaction.getStatus();
                    if (status == 0) {
                        this.transactionManager.commit();
                    } else if (status == 1) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.toString());
                }
            }
            this.transactionManager.clearThreadTx();
        }
        if (this.requestTracing != null && this.requestTracing.isRequestTracingEnabled()) {
            this.requestTracing.endTrace();
        }
        if (this.stuckThreads != null) {
            this.stuckThreads.deregisterThread(Thread.currentThread().getId());
        }
    }

    private boolean isApplicationEnabled(String appId) {
        boolean result = false;
        if (appId != null) {
            com.sun.enterprise.config.serverbeans.Application app = this.applications.getApplication(appId);
            if (app != null) {
                result = this.deployment.isAppEnabled(app);
            } else if (this.applicationRegistry.get(appId) != null) {
                logger.log(Level.FINE, "Job submitted for {0} likely during deployment. Continuing...", appId);
                result = true;
            }
        }
        return result;
    }

    private ComponentInvocation createComponentInvocation(ComponentInvocation currInv) {
        ComponentInvocation newInv = currInv.clone();
        newInv.setResourceTableKey(null);
        newInv.clearRegistry();
        newInv.instance = currInv.getInstance();
        if (!this.naming) {
            newInv.setJNDIEnvironment(null);
        }
        return newInv;
    }

    private boolean useTransactionOfExecutionThread(Map<String, String> executionProperties) {
        return "USE_TRANSACTION_OF_EXECUTION_THREAD".equals(this.getTransactionExecutionProperty(executionProperties));
    }

    private String getTransactionExecutionProperty(Map<String, String> executionProperties) {
        if (executionProperties != null && executionProperties.get("jakarta.enterprise.concurrent.TRANSACTION") != null) {
            return executionProperties.get("jakarta.enterprise.concurrent.TRANSACTION");
        }
        return "SUSPEND";
    }

    private Set<String> filterVerifiedProviders(Set<String> providers) {
        HashSet<String> filtered = new HashSet<String>();
        Iterator<String> providerIter = providers.iterator();
        block10: while (providerIter.hasNext()) {
            String provider;
            switch (provider = providerIter.next()) {
                case "CLASSLOADING": 
                case "SECURITY": 
                case "NAMING": 
                case "WORKAREA": 
                case "Remaining": {
                    filtered.add(provider);
                    continue block10;
                }
            }
            if (this.allThreadContextProviders.containsKey(provider)) {
                filtered.add(provider);
                continue;
            }
            logger.log(Level.SEVERE, "Thread context provider ''{0}'' is not registered in WEB-APP/services/jakarta.enterprise.concurrent.spi.ThreadContextProvider and will be ignored!", provider);
        }
        return filtered;
    }

    private void addToRemainingIfNotPresent(String contextType) {
        if (!(this.contextPropagate.contains(contextType) || this.contextClear.contains(contextType) || this.contextUnchanged.contains(contextType))) {
            this.allRemaining.add(contextType);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.transactionManager == null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean nullTransactionManager = in.readBoolean();
        ConcurrentRuntime concurrentRuntime = ConcurrentRuntime.getRuntime();
        this.invocationManager = concurrentRuntime.getInvocationManager();
        this.deployment = concurrentRuntime.getDeployment();
        this.applications = concurrentRuntime.getApplications();
        this.compEnvMgr = concurrentRuntime.getCompEnvMgr();
        if (!nullTransactionManager) {
            this.transactionManager = concurrentRuntime.getTransactionManager();
        }
        this.initialiseServices();
    }

    private void initialiseServices() {
        try {
            this.requestTracing = (RequestTracingService)Globals.getDefaultHabitat().getService(RequestTracingService.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving Request Tracing service during initialisation of Concurrent Context - NullPointerException", ex);
        }
        try {
            this.stuckThreads = (StuckThreadsStore)Globals.getDefaultHabitat().getService(StuckThreadsStore.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving Stuck Threads Store Healthcheck service during initialisation of Concurrent Context - NullPointerException", ex);
        }
        try {
            this.openTracing = (OpenTracingService)Globals.getDefaultHabitat().getService(OpenTracingService.class, new Annotation[0]);
        }
        catch (NullPointerException ex) {
            logger.log(Level.INFO, "Error retrieving OpenTracing service during initialisation of Concurrent Context - NullPointerException", ex);
        }
    }

    private static class PairKey {
        private Object instance = null;
        private Thread thread = null;
        int hCode = 0;

        private PairKey(Object inst, Thread thr) {
            this.instance = inst;
            this.thread = thr;
            if (inst != null) {
                this.hCode = 7 * inst.hashCode();
            }
            if (thr != null) {
                this.hCode += thr.hashCode();
            }
        }

        public int hashCode() {
            return this.hCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            boolean eq = false;
            if (obj != null && obj instanceof PairKey) {
                PairKey p = (PairKey)obj;
                if (this.instance != null) {
                    eq = this.instance.equals(p.instance);
                } else {
                    boolean bl = eq = p.instance == null;
                }
                if (eq) {
                    eq = this.thread != null ? this.thread.equals(p.thread) : p.thread == null;
                }
            }
            return eq;
        }
    }
}

