/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedThreadFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ManagedThreadFactoryDefinition.class)
public class ManagedThreadFactoryDefinitionHandler
extends AbstractResourceHandler {
    private static final Logger logger = Logger.getLogger(ManagedThreadFactoryDefinitionHandler.class.getName());

    protected HandlerProcessingResult processAnnotation(AnnotationInfo annotationInfo, ResourceContainerContext[] resourceContainerContexts) throws AnnotationProcessorException {
        logger.log(Level.INFO, "Entering ManagedThreadFactoryDefinitionHandler.processAnnotation");
        ManagedThreadFactoryDefinition managedThreadFactoryDefinition = (ManagedThreadFactoryDefinition)annotationInfo.getAnnotation();
        return this.processAnnotation(managedThreadFactoryDefinition, resourceContainerContexts);
    }

    protected HandlerProcessingResult processAnnotation(ManagedThreadFactoryDefinition managedThreadFactoryDefinition, ResourceContainerContext[] contexts) {
        logger.log(Level.INFO, "Registering ManagedThreadFactory from annotation config");
        for (ResourceContainerContext context : contexts) {
            ManagedThreadFactoryDefinitionDescriptor mtfdd;
            Set resourceDescriptors = context.getResourceDescriptors(JavaEEResourceType.MTFDD);
            if (this.descriptorAlreadyPresent(resourceDescriptors, mtfdd = this.createDescriptor(managedThreadFactoryDefinition))) {
                this.merge(resourceDescriptors, managedThreadFactoryDefinition);
                continue;
            }
            resourceDescriptors.add(mtfdd);
        }
        return this.getDefaultProcessedResult();
    }

    public ManagedThreadFactoryDefinitionDescriptor createDescriptor(ManagedThreadFactoryDefinition managedThreadFactoryDefinition) {
        ManagedThreadFactoryDefinitionDescriptor mtfdd = new ManagedThreadFactoryDefinitionDescriptor();
        mtfdd.setMetadataSource(MetadataSource.ANNOTATION);
        mtfdd.setName(TranslatedConfigView.expandValue(managedThreadFactoryDefinition.name()));
        mtfdd.setContext(TranslatedConfigView.expandValue(managedThreadFactoryDefinition.context()));
        if (managedThreadFactoryDefinition.priority() <= 0) {
            mtfdd.setPriority(5);
        } else {
            mtfdd.setPriority(managedThreadFactoryDefinition.priority());
        }
        return mtfdd;
    }

    private boolean descriptorAlreadyPresent(Set<ResourceDescriptor> resourceDescriptors, ManagedThreadFactoryDefinitionDescriptor mtfdd) {
        Optional<ResourceDescriptor> optResourceDescriptor = resourceDescriptors.stream().filter(d -> d.equals(mtfdd)).findAny();
        return optResourceDescriptor.isPresent();
    }

    private void merge(Set<ResourceDescriptor> resourceDescriptors, ManagedThreadFactoryDefinition mtfdd) {
        for (ResourceDescriptor resource : resourceDescriptors) {
            ManagedThreadFactoryDefinitionDescriptor descriptor = (ManagedThreadFactoryDefinitionDescriptor)resource;
            if (!descriptor.getName().equals(mtfdd.name())) continue;
            if (descriptor.getPriority() == -1 && mtfdd.priority() != -1) {
                descriptor.setPriority(mtfdd.priority());
            }
            if (descriptor.getContext() != null || mtfdd.context() == null || mtfdd.context().isBlank()) continue;
            descriptor.setContext(TranslatedConfigView.expandValue(mtfdd.context()));
        }
    }
}

