/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebPipeline;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Pipeline;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.LogFacade;
import org.glassfish.web.config.serverbeans.ManagerProperties;
import org.glassfish.web.config.serverbeans.SessionManager;
import org.glassfish.web.config.serverbeans.SessionProperties;
import org.glassfish.web.deployment.runtime.StoreProperties;
import org.glassfish.web.deployment.runtime.WebProperty;
import org.jvnet.hk2.config.types.Property;

public abstract class BasePersistenceStrategyBuilder
implements PersistenceStrategyBuilder {
    public static final Logger _logger = LogFacade.getLogger();
    public static final ResourceBundle _rb = _logger.getResourceBundle();
    protected String directory = null;
    protected static final String DEFAULT_SESSION_FILENAME = null;
    protected String sessionFilename = DEFAULT_SESSION_FILENAME;
    protected String sessionIdGeneratorClassname = null;
    protected String _persistenceFrequency = null;
    protected String _persistenceScope = null;
    protected String _passedInPersistenceType = null;
    protected int maxSessions = -1;
    protected static final int DEFAULT_REAP_INTERVAL = 60;
    protected int reapInterval = 60;
    protected int storeReapInterval = 60;
    protected static final int DEFAULT_MAX_IDLE_BACKUP = -1;
    protected int maxIdleBackup = -1;
    protected static final int DEFAULT_MIN_IDLE_SWAP = -1;
    protected int minIdleSwap = -1;
    protected static final int DEFAULT_MAX_IDLE_SWAP = -1;
    protected int maxIdleSwap = -1;
    protected static final int DEFAULT_SESSION_TIMEOUT = 1800;
    protected int sessionMaxInactiveInterval = 1800;
    protected String persistentCookieName = "GLASSFISHCOOKIE";
    protected boolean relaxCacheVersionSemantics = true;
    protected static final String JSF_HA_ENABLED = "com.sun.appserver.enableHighAvailability";
    protected static final String MIN_IDLE_SWAP_PROPERTY = "minIdleSwap";
    protected static final String MAX_IDLE_SWAP_PROPERTY = "maxIdleSwap";

    @Override
    public void initializePersistenceStrategy(Context ctx, org.glassfish.web.deployment.runtime.SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        this.setDefaultParams(ctx, smBean);
        this.readInstanceLevelParams(serverConfigLookup);
        this.readWebAppParams(ctx, smBean);
        ctx.setBackgroundProcessorDelay(this.reapInterval);
        StandardContext sctx = (StandardContext)ctx;
        sctx.restrictedSetPipeline((Pipeline)new WebPipeline((Container)sctx));
    }

    public void setDefaultParams(Context ctx, org.glassfish.web.deployment.runtime.SessionManager smBean) {
        this.reapInterval = 60;
        this.maxSessions = -1;
        this.sessionFilename = DEFAULT_SESSION_FILENAME;
        this.storeReapInterval = 60;
        this.directory = ((StandardContext)ctx).getWorkDir();
    }

    public void readInstanceLevelParams(ServerConfigLookup serverConfigLookup) {
        SessionProperties spBean;
        SessionManager smBean = serverConfigLookup.getInstanceSessionManager();
        if (smBean != null) {
            org.glassfish.web.config.serverbeans.StoreProperties storeBean;
            ManagerProperties mgrBean = smBean.getManagerProperties();
            if (mgrBean != null) {
                List props;
                String sessionFilenameString;
                String maxSessionsString;
                String reapIntervalInSecondsString = mgrBean.getReapIntervalInSeconds();
                if (reapIntervalInSecondsString != null) {
                    try {
                        this.reapInterval = Integer.parseInt(reapIntervalInSecondsString);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "AS-WEB-GLUE-00052", this.reapInterval);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "AS-WEB-GLUE-00053");
                }
                if ((maxSessionsString = mgrBean.getMaxSessions()) != null) {
                    try {
                        this.maxSessions = Integer.parseInt(maxSessionsString);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "AS-WEB-GLUE-00054", this.maxSessions);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "AS-WEB-GLUE-00055");
                }
                if ((sessionFilenameString = mgrBean.getSessionFileName()) != null) {
                    this.sessionFilename = sessionFilenameString;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "AS-WEB-GLUE-00056", this.sessionFilename);
                    }
                }
                this.sessionIdGeneratorClassname = mgrBean.getSessionIdGeneratorClassname();
                if (this.sessionIdGeneratorClassname != null && _logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "AS-WEB-GLUE-00057", this.sessionIdGeneratorClassname);
                }
                if ((props = mgrBean.getProperty()) != null) {
                    for (Property prop : props) {
                        String name = prop.getName();
                        String value = prop.getValue();
                        if (name.equalsIgnoreCase("maxIdleBackupSeconds")) {
                            try {
                                this.maxIdleBackup = Integer.parseInt(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        if (name.equalsIgnoreCase(MIN_IDLE_SWAP_PROPERTY)) {
                            try {
                                this.minIdleSwap = Integer.parseInt(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        if (!name.equalsIgnoreCase(MAX_IDLE_SWAP_PROPERTY)) continue;
                        try {
                            this.maxIdleSwap = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            if ((storeBean = smBean.getStoreProperties()) != null) {
                String directoryString;
                String reapIntervalInSecondsString = storeBean.getReapIntervalInSeconds();
                if (reapIntervalInSecondsString != null) {
                    try {
                        this.storeReapInterval = Integer.parseInt(reapIntervalInSecondsString);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "AS-WEB-GLUE-00058", this.storeReapInterval);
                        }
                    }
                    catch (NumberFormatException sessionFilenameString) {
                        // empty catch block
                    }
                }
                if ((directoryString = storeBean.getDirectory()) != null) {
                    this.directory = directoryString;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "AS-WEB-GLUE-00059", directoryString);
                    }
                }
            }
        }
        if ((spBean = serverConfigLookup.getInstanceSessionProperties()) != null) {
            String timeoutSecondsString = spBean.getTimeoutInSeconds();
            if (timeoutSecondsString != null) {
                try {
                    this.sessionMaxInactiveInterval = Integer.parseInt(timeoutSecondsString);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "AS-WEB-GLUE-00060", this.sessionMaxInactiveInterval);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00061");
            }
        }
    }

    public void readWebAppParams(Context ctx, org.glassfish.web.deployment.runtime.SessionManager smBean) {
        if (smBean != null) {
            StoreProperties storeBean;
            org.glassfish.web.deployment.runtime.ManagerProperties mgrBean = smBean.getManagerProperties();
            if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
                for (WebProperty prop : mgrBean.getWebProperty()) {
                    String name = prop.getAttributeValue("name");
                    String value = prop.getAttributeValue("value");
                    if (name.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.reapInterval = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("maxSessions")) {
                        try {
                            this.maxSessions = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("maxIdleBackupSeconds")) {
                        try {
                            this.maxIdleBackup = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase(MIN_IDLE_SWAP_PROPERTY)) {
                        try {
                            this.minIdleSwap = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase(MAX_IDLE_SWAP_PROPERTY)) {
                        try {
                            this.maxIdleSwap = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("relaxCacheVersionSemantics")) {
                        this.relaxCacheVersionSemantics = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (name.equalsIgnoreCase("sessionFilename")) {
                        this.sessionFilename = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("persistenceFrequency")) {
                        this._persistenceFrequency = value;
                        continue;
                    }
                    if (!_logger.isLoggable(Level.INFO)) continue;
                    Object[] params = new Object[]{name};
                    _logger.log(Level.INFO, "AS-WEB-GLUE-00179", params);
                }
            }
            if ((storeBean = smBean.getStoreProperties()) != null && storeBean.sizeWebProperty() > 0) {
                for (WebProperty prop : storeBean.getWebProperty()) {
                    String name = prop.getAttributeValue("name");
                    String value = prop.getAttributeValue("value");
                    if (name.equalsIgnoreCase("reapIntervalSeconds")) {
                        try {
                            this.storeReapInterval = Integer.parseInt(value);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("directory")) {
                        this.directory = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("persistenceScope")) {
                        this._persistenceScope = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("cookieName")) {
                        this.persistentCookieName = value;
                        continue;
                    }
                    if (!_logger.isLoggable(Level.INFO)) continue;
                    Object[] params = new Object[]{name};
                    _logger.log(Level.INFO, "AS-WEB-GLUE-00179", params);
                }
            }
        }
    }

    protected String prependContextPathTo(String str, Context ctx) {
        if (str == null) {
            return str;
        }
        String filePart = this.getFilePartOf(str);
        if (filePart == null || filePart.equals("")) {
            return null;
        }
        String strippedContextPath = this.stripNonAlphaNumericsExceptUnderscore(ctx.getPath());
        Object modifiedFilePart = null;
        modifiedFilePart = strippedContextPath != null && !strippedContextPath.equals("") ? strippedContextPath + "_" + filePart : filePart;
        int lastSlashIdx = str.lastIndexOf(File.separator);
        Object result = null;
        if (lastSlashIdx == -1) {
            result = modifiedFilePart;
        } else {
            String firstPart = str.substring(0, lastSlashIdx);
            result = firstPart + File.separator + (String)modifiedFilePart;
        }
        return result;
    }

    protected String getFilePartOf(String str) {
        if (str == null) {
            return str;
        }
        int lastSlashIdx = str.lastIndexOf(File.separator);
        String result = null;
        result = lastSlashIdx == -1 ? this.cleanFileParts(str) : this.cleanFileParts(str.substring(lastSlashIdx + 1, str.length()));
        return result;
    }

    private String cleanFileParts(String fileString) {
        String fileMainPart = this.getFileMainPart(fileString);
        String fileSuffixPart = this.getFileSuffixPart(fileString);
        if (fileMainPart == null) {
            return null;
        }
        if (fileSuffixPart == null) {
            return fileMainPart;
        }
        return fileMainPart + "." + fileSuffixPart;
    }

    private String getFileMainPart(String fileString) {
        ArrayList<String> results = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fileString, ".");
        while (st.hasMoreTokens()) {
            results.add(st.nextToken());
        }
        if (results.size() > 0) {
            return this.stripNonAlphaNumericsExceptUnderscore((String)results.get(0));
        }
        return null;
    }

    private String getFileSuffixPart(String fileString) {
        ArrayList<String> results = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fileString, ".");
        while (st.hasMoreTokens()) {
            results.add(st.nextToken());
        }
        if (results.size() > 1) {
            return this.stripNonAlphaNumericsExceptUnderscore((String)results.get(1));
        }
        return null;
    }

    protected String stripNonAlphas(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    protected String stripNonAlphaNumericsExceptUnderscore(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetterOrDigit(nextChar) && !"_".equals(String.valueOf(nextChar))) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    protected String stripNonAlphaNumerics(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetterOrDigit(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    public String getPersistenceFrequency() {
        return this._persistenceFrequency;
    }

    @Override
    public void setPersistenceFrequency(String persistenceFrequency) {
        this._persistenceFrequency = persistenceFrequency;
    }

    public String getPersistenceScope() {
        return this._persistenceScope;
    }

    @Override
    public void setPersistenceScope(String persistenceScope) {
        this._persistenceScope = persistenceScope;
    }

    public String getPassedInPersistenceType() {
        return this._passedInPersistenceType;
    }

    @Override
    public void setPassedInPersistenceType(String persistenceType) {
        this._passedInPersistenceType = persistenceType;
    }
}

