/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.client.Client;
import com.hazelcast.client.ClientListener;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEndpointManager;
import com.hazelcast.client.impl.ClientEndpointManagerImpl;
import com.hazelcast.client.impl.ClientEndpointStatisticsManager;
import com.hazelcast.client.impl.ClientEndpointStatisticsManagerImpl;
import com.hazelcast.client.impl.ClientEndpointStatisticsSnapshot;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.ClientEvent;
import com.hazelcast.client.impl.ClientEventType;
import com.hazelcast.client.impl.ClientHeartbeatMonitor;
import com.hazelcast.client.impl.ClientLifecycleMonitor;
import com.hazelcast.client.impl.ClientSelector;
import com.hazelcast.client.impl.ClientSelectors;
import com.hazelcast.client.impl.ClusterViewListenerService;
import com.hazelcast.client.impl.CompositeMessageTaskFactory;
import com.hazelcast.client.impl.NoOpClientEndpointStatisticsManager;
import com.hazelcast.client.impl.operations.GetConnectedClientsOperation;
import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.client.impl.protocol.task.AbstractPartitionMessageTask;
import com.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.hazelcast.client.impl.protocol.task.BlockingMessageTask;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.client.impl.protocol.task.TransactionalMessageTask;
import com.hazelcast.client.impl.protocol.task.UrgentMessageTask;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapQueryMessageTask;
import com.hazelcast.client.impl.statistics.ClientStatistics;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.AddressChecker;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.AddressCheckerImpl;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.services.CoreService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.tpcengine.iobuffer.ConcurrentIOBufferAllocator;
import com.hazelcast.internal.tpcengine.iobuffer.IOBufferAllocator;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.executor.ExecutorType;
import com.hazelcast.internal.util.executor.UnblockablePoolExecutorThreadFactory;
import com.hazelcast.internal.util.phonehome.PhoneHome;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.proxyservice.ProxyService;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.sql.impl.client.SqlAbstractMessageTask;
import com.hazelcast.transaction.TransactionManagerService;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.security.auth.login.LoginException;

public class ClientEngineImpl
implements ClientEngine,
CoreService,
ManagedService,
EventPublishingService<ClientEvent, ClientListener> {
    public static final String SERVICE_NAME = "hz:core:clientEngine";
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_CORE = 100000;
    private static final int BLOCKING_THREADS_PER_CORE = 20;
    private static final int THREADS_PER_CORE = 1;
    private static final int QUERY_THREADS_PER_CORE = 1;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final Executor executor;
    private final Executor blockingExecutor;
    private final Executor queryExecutor;
    private volatile ClientSelector clientSelector = ClientSelectors.any();
    private final ClientEndpointManagerImpl endpointManager;
    private final ILogger logger;
    private final ConnectionListener connectionListener = new ConnectionListenerImpl();
    private final MessageTaskFactory messageTaskFactory;
    private final ClientExceptionFactory clientExceptionFactory;
    private final ClusterViewListenerService clusterListenerService;
    private final boolean advancedNetworkConfigEnabled;
    private final ClientLifecycleMonitor lifecycleMonitor;
    private final Map<UUID, Consumer<Long>> backupListeners = new ConcurrentHashMap<UUID, Consumer<Long>>();
    private final AddressChecker addressChecker;
    private final IOBufferAllocator responseBufAllocator = new ConcurrentIOBufferAllocator(4096, true);
    private final boolean tpcEnabled;
    private ClientEndpointStatisticsManager endpointStatisticsManager;

    public ClientEngineImpl(Node node) {
        this.logger = node.getLogger(ClientEngine.class);
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.endpointManager = new ClientEndpointManagerImpl(this.nodeEngine);
        this.executor = this.newClientExecutor();
        this.queryExecutor = this.newClientQueryExecutor();
        this.blockingExecutor = this.newBlockingExecutor();
        this.messageTaskFactory = new CompositeMessageTaskFactory(this.nodeEngine);
        this.clientExceptionFactory = this.initClientExceptionFactory();
        this.clusterListenerService = new ClusterViewListenerService(this.nodeEngine);
        this.advancedNetworkConfigEnabled = node.getConfig().getAdvancedNetworkConfig().isEnabled();
        this.lifecycleMonitor = new ClientLifecycleMonitor(this.endpointManager, this, this.logger, this.nodeEngine, this.nodeEngine.getExecutionService(), node.getProperties());
        Set<String> trustedInterfaces = node.getConfig().getManagementCenterConfig().getTrustedInterfaces();
        this.addressChecker = new AddressCheckerImpl(trustedInterfaces, this.logger);
        this.endpointStatisticsManager = PhoneHome.isPhoneHomeEnabled(node) ? new ClientEndpointStatisticsManagerImpl() : new NoOpClientEndpointStatisticsManager();
        this.tpcEnabled = this.nodeEngine.getTpcServerBootstrap().isEnabled();
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        ClassLoader configClassLoader = this.nodeEngine.getConfigClassLoader();
        boolean jcacheAvailable = JCacheDetector.isJCacheAvailable(configClassLoader);
        return new ClientExceptionFactory(jcacheAvailable, configClassLoader);
    }

    private Executor newClientExecutor() {
        boolean userCodeDeploymentEnabled = this.nodeEngine.getConfig().getUserCodeDeploymentConfig().isEnabled();
        int threadsPerCore = userCodeDeploymentEnabled ? 20 : 1;
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        int coreSize = RuntimeAvailableProcessors.get();
        int threadCount = this.node.getProperties().getInteger(ClusterProperty.CLIENT_ENGINE_THREAD_COUNT);
        if (threadCount <= 0) {
            threadCount = coreSize * threadsPerCore;
        }
        this.logger.finest("Creating new client executor with threadCount=" + threadCount);
        if (userCodeDeploymentEnabled) {
            return executionService.register("hz:client", threadCount, coreSize * 100000, ExecutorType.CONCRETE);
        }
        String name = "hz:client";
        ClassLoader classLoader = this.nodeEngine.getConfigClassLoader();
        String hzName = this.nodeEngine.getHazelcastInstance().getName();
        String internalName = name.substring("hz:".length());
        String threadNamePrefix = ThreadUtil.createThreadPoolName(hzName, internalName);
        UnblockablePoolExecutorThreadFactory factory = new UnblockablePoolExecutorThreadFactory(threadNamePrefix, classLoader);
        return executionService.register("hz:client", threadCount, coreSize * 100000, factory);
    }

    private Executor newClientQueryExecutor() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        int coreSize = RuntimeAvailableProcessors.get();
        int threadCount = this.node.getProperties().getInteger(ClusterProperty.CLIENT_ENGINE_QUERY_THREAD_COUNT);
        if (threadCount <= 0) {
            threadCount = coreSize * 1;
        }
        this.logger.finest("Creating new client query executor with threadCount=" + threadCount);
        return executionService.register("hz:client-query", threadCount, coreSize * 100000, ExecutorType.CONCRETE);
    }

    private Executor newBlockingExecutor() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        int coreSize = Runtime.getRuntime().availableProcessors();
        int threadCount = this.node.getProperties().getInteger(ClusterProperty.CLIENT_ENGINE_BLOCKING_THREAD_COUNT);
        if (threadCount <= 0) {
            threadCount = coreSize * 20;
        }
        this.logger.finest("Creating new client executor for blocking tasks with threadCount=" + threadCount);
        return executionService.register("hz:client-blocking-tasks", threadCount, coreSize * 100000, ExecutorType.CONCRETE);
    }

    @Override
    public int getClientEndpointCount() {
        return this.endpointManager.size();
    }

    @Override
    public void accept(ClientMessage clientMessage) {
        Connection connection = clientMessage.getConnection();
        MessageTask messageTask = this.messageTaskFactory.create(clientMessage, connection);
        if (this.tpcEnabled && messageTask instanceof AbstractMessageTask) {
            AbstractMessageTask abstractMessageTask = (AbstractMessageTask)messageTask;
            abstractMessageTask.setAsyncSocket(clientMessage.getAsyncSocket());
            abstractMessageTask.setResponseBufAllocator(this.responseBufAllocator);
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        if (this.isUrgent(messageTask)) {
            operationService.execute((UrgentMessageTask)((Object)messageTask));
        } else if (messageTask instanceof AbstractPartitionMessageTask) {
            operationService.execute((AbstractPartitionMessageTask)messageTask);
        } else if (this.isQuery(messageTask)) {
            this.queryExecutor.execute(messageTask);
        } else if (messageTask instanceof TransactionalMessageTask) {
            this.blockingExecutor.execute(messageTask);
        } else if (messageTask instanceof BlockingMessageTask) {
            this.blockingExecutor.execute(messageTask);
        } else {
            this.executor.execute(messageTask);
        }
    }

    private boolean isUrgent(MessageTask messageTask) {
        if (messageTask instanceof AuthenticationBaseMessageTask) {
            return this.node.securityContext == null;
        }
        return messageTask instanceof UrgentMessageTask;
    }

    private boolean isQuery(MessageTask messageTask) {
        return messageTask instanceof AbstractMapQueryMessageTask || messageTask instanceof SqlAbstractMessageTask;
    }

    @Override
    public IPartitionService getPartitionService() {
        return this.nodeEngine.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.nodeEngine.getClusterService();
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.nodeEngine.getProxyService();
    }

    @Override
    public Address getThisAddress() {
        if (this.advancedNetworkConfigEnabled) {
            Address clientServerSocketAddress = this.node.getLocalMember().getAddressMap().get(EndpointQualifier.CLIENT);
            assert (clientServerSocketAddress != null);
            return clientServerSocketAddress;
        }
        return this.node.getThisAddress();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    @Override
    public ClientEndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    @Override
    public ClientExceptionFactory getExceptionFactory() {
        return this.clientExceptionFactory;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.node.securityContext;
    }

    @Override
    public boolean bind(ClientEndpoint endpoint) {
        if (!this.isClientAllowed(endpoint)) {
            return false;
        }
        ServerConnection conn = endpoint.getConnection();
        InetSocketAddress socketAddress = conn.getRemoteSocketAddress();
        if (socketAddress != null) {
            conn.setRemoteAddress(new Address(socketAddress));
        }
        if (this.endpointManager.registerEndpoint(endpoint) && conn.getRemoteAddress() != null && endpoint.getUuid() != null) {
            this.node.getServer().getConnectionManager(EndpointQualifier.CLIENT).register(conn.getRemoteAddress(), endpoint.getUuid(), conn);
        }
        if (!this.isClientAllowed(endpoint)) {
            this.endpointManager.removeEndpoint(endpoint);
            return false;
        }
        return true;
    }

    @Override
    public void applySelector(ClientSelector newSelector) {
        this.logger.info("Applying a new client selector :" + newSelector);
        this.clientSelector = newSelector;
        for (ClientEndpoint endpoint : this.endpointManager.getEndpoints()) {
            if (this.isClientAllowed(endpoint)) continue;
            endpoint.getConnection().close("Client disconnected from cluster via Management Center", null);
        }
    }

    @Override
    public void dispatchEvent(ClientEvent event, ClientListener listener) {
        if (event.getEventType() == ClientEventType.CONNECTED) {
            listener.clientConnected(event);
        } else {
            listener.clientDisconnected(event);
        }
    }

    @Override
    @Nonnull
    public Collection<Client> getClients() {
        Collection<ClientEndpoint> endpoints = this.endpointManager.getEndpoints();
        Set<Client> clients = SetUtil.createHashSet(endpoints.size());
        clients.addAll(endpoints);
        return clients;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.node.getServer().getConnectionManager(EndpointQualifier.CLIENT).addConnectionListener(this.connectionListener);
        ClientHeartbeatMonitor heartbeatMonitor = new ClientHeartbeatMonitor(this.endpointManager, this.getLogger(ClientHeartbeatMonitor.class), nodeEngine.getExecutionService(), this.node.getProperties());
        heartbeatMonitor.start();
        this.lifecycleMonitor.start();
    }

    @Override
    public void reset() {
        this.clear("Resetting clientEngine");
    }

    @Override
    public void shutdown(boolean terminate) {
        this.clear("Shutting down clientEngine");
    }

    private void clear(String reason) {
        for (ClientEndpoint ce : this.endpointManager.getEndpoints()) {
            ClientEndpointImpl endpoint = (ClientEndpointImpl)ce;
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.finest(e.getMessage());
            }
            try {
                ServerConnection conn = endpoint.getConnection();
                if (!conn.isAlive()) continue;
                conn.close(reason, null);
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        this.endpointManager.clear();
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.node.nodeEngine.getTransactionManagerService();
    }

    @Override
    public ClusterViewListenerService getClusterListenerService() {
        return this.clusterListenerService;
    }

    @Override
    public boolean isClientAllowed(Client client) {
        return "MCJVM".equals(client.getClientType()) || this.clientSelector.select(client);
    }

    @Override
    public Map<String, Long> getActiveClientsInCluster() {
        Map<UUID, String> clients = this.getClientsInCluster();
        return clients.values().stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    @Override
    public Map<String, ClientEndpointStatisticsSnapshot> getEndpointStatisticsSnapshots() {
        return this.endpointStatisticsManager.getSnapshotsAndReset(this.endpointManager.getEndpoints());
    }

    @Override
    public void onEndpointAuthenticated(ClientEndpoint endpoint) {
        this.endpointStatisticsManager.onEndpointAuthenticated(endpoint);
    }

    @Override
    public void onEndpointDestroyed(ClientEndpoint endpoint) {
        this.endpointStatisticsManager.onEndpointDestroyed(endpoint);
    }

    Map<UUID, String> getClientsInCluster() {
        OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
        HashMap<UUID, String> clientsMap = new HashMap<UUID, String>();
        for (Member member : this.node.getClusterService().getMembers()) {
            Address target = member.getAddress();
            GetConnectedClientsOperation clientInfoOperation = new GetConnectedClientsOperation();
            InvocationFuture future = operationService.invokeOnTarget(SERVICE_NAME, clientInfoOperation, target);
            try {
                Map endpoints = (Map)future.get();
                if (endpoints == null) continue;
                clientsMap.putAll(endpoints);
            }
            catch (Exception e) {
                this.logger.warning("Cannot get client information from: " + target.toString(), e);
            }
        }
        return clientsMap;
    }

    @Override
    public Map<UUID, ClientStatistics> getClientStatistics() {
        Collection<ClientEndpoint> clientEndpoints = this.endpointManager.getEndpoints();
        Map<UUID, ClientStatistics> statsMap = MapUtil.createHashMap(clientEndpoints.size());
        for (ClientEndpoint e : clientEndpoints) {
            ClientStatistics statistics = e.getClientStatistics();
            if (null == statistics) continue;
            statsMap.put(e.getUuid(), statistics);
        }
        return statsMap;
    }

    @Override
    public void onClientAcquiredResource(UUID uuid) {
        this.lifecycleMonitor.addClientToMonitor(uuid);
    }

    @Override
    public void addBackupListener(UUID clientUuid, Consumer<Long> backupListener) {
        this.backupListeners.put(clientUuid, backupListener);
    }

    @Override
    public void dispatchBackupEvent(UUID clientUUID, long clientCorrelationId) {
        Consumer<Long> backupListener = this.backupListeners.get(clientUUID);
        if (backupListener != null) {
            backupListener.accept(clientCorrelationId);
        }
    }

    @Override
    public boolean deregisterBackupListener(UUID clientUUID, Consumer<Long> backupListener) {
        return this.backupListeners.remove(clientUUID, backupListener);
    }

    public Map<UUID, Consumer<Long>> getBackupListeners() {
        return this.backupListeners;
    }

    @Override
    public AddressChecker getManagementTasksChecker() {
        return this.addressChecker;
    }

    public void setEndpointStatisticsManager(ClientEndpointStatisticsManager endpointStatisticsManager) {
        this.endpointStatisticsManager = endpointStatisticsManager;
    }

    private final class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        public void connectionAdded(Connection conn) {
        }

        public void connectionRemoved(Connection c) {
            ServerConnection connection = (ServerConnection)c;
            if (!connection.isClient() || !ClientEngineImpl.this.nodeEngine.isRunning()) {
                return;
            }
            ClientEndpointImpl endpoint = (ClientEndpointImpl)ClientEngineImpl.this.endpointManager.getEndpoint(connection);
            if (endpoint == null) {
                ClientEngineImpl.this.logger.finest("connectionRemoved: No endpoint for connection:" + connection);
                return;
            }
            UUID clientUuid = endpoint.getUuid();
            if (clientUuid != null) {
                ClientEngineImpl.this.node.getLocalAddressRegistry().tryRemoveRegistration(clientUuid, endpoint.getConnection().getRemoteAddress());
            }
            ClientEngineImpl.this.endpointManager.removeEndpoint(endpoint);
        }
    }
}

