/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.DataConnectionBase;
import com.hazelcast.dataconnection.DataConnectionResource;
import com.hazelcast.dataconnection.impl.ConnectionDelegate;
import com.hazelcast.dataconnection.impl.jdbcproperties.DriverManagerTranslator;
import com.hazelcast.dataconnection.impl.jdbcproperties.HikariTranslator;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.shaded.com.zaxxer.hikari.HikariConfig;
import com.hazelcast.shaded.com.zaxxer.hikari.HikariDataSource;
import com.hazelcast.spi.annotation.Beta;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@Beta
public class JdbcDataConnection
extends DataConnectionBase {
    public static final String OBJECT_TYPE_TABLE = "Table";
    private static final AtomicInteger DATA_SOURCE_COUNTER = new AtomicInteger();
    private volatile ConcurrentMemoizingSupplier<HikariDataSource> pooledDataSourceSup;
    private volatile Supplier<Connection> singleUseConnectionSup;

    public JdbcDataConnection(DataConnectionConfig config) {
        super(config);
        if (config.isShared()) {
            this.pooledDataSourceSup = new ConcurrentMemoizingSupplier<HikariDataSource>(this::createHikariDataSource);
        } else {
            this.singleUseConnectionSup = this.createSingleConnectionSup();
        }
    }

    protected HikariDataSource createHikariDataSource() {
        try {
            this.validate(this.getConfig());
            Properties properties = this.getConfig().getProperties();
            HikariTranslator translator = new HikariTranslator(DATA_SOURCE_COUNTER, this.getName());
            Properties translatedProperties = translator.translate(properties);
            HikariConfig dataSourceConfig = new HikariConfig(translatedProperties);
            return new HikariDataSource(dataSourceConfig);
        }
        catch (Exception e) {
            throw new HazelcastException("Could not create pool for data connection '" + this.getName() + "'", e);
        }
    }

    private Supplier<Connection> createSingleConnectionSup() {
        this.validate(this.getConfig());
        Properties properties = this.getConfig().getProperties();
        DriverManagerTranslator translator = new DriverManagerTranslator();
        Properties translatedProperties = translator.translate(properties);
        return () -> {
            try {
                String jdbcUrl = properties.getProperty("jdbcUrl");
                return DriverManager.getConnection(jdbcUrl, translatedProperties);
            }
            catch (SQLException e) {
                throw new HazelcastException("Could not create a new connection: " + e, e);
            }
        };
    }

    private void validate(DataConnectionConfig config) {
        Properties properties = config.getProperties();
        if (properties.get("jdbcUrl") == null) {
            throw new HazelcastException("jdbcUrl property is not defined for data connection '" + this.getName() + "'");
        }
    }

    @Override
    @Nonnull
    public Collection<String> resourceTypes() {
        return Collections.singleton(OBJECT_TYPE_TABLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public List<DataConnectionResource> listResources() {
        try (Connection connection = this.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(null, null, "%", null);
            ArrayList<DataConnectionResource> result = new ArrayList<DataConnectionResource>();
            while (tables.next()) {
                String[] name = (String[])Stream.of(tables.getString("TABLE_CAT"), tables.getString("TABLE_SCHEM"), tables.getString("TABLE_NAME")).filter(Objects::nonNull).toArray(String[]::new);
                result.add(new DataConnectionResource(OBJECT_TYPE_TABLE, name));
            }
            ArrayList<DataConnectionResource> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new HazelcastException("Could not read resources for DataConnection " + this.getName(), e);
        }
    }

    private Connection pooledConnection() {
        this.retain();
        try {
            return new ConnectionDelegate(this.pooledDataSourceSup.get().getConnection()){

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    catch (Exception e) {
                        throw new HazelcastException("Could not close connection", e);
                    }
                    finally {
                        JdbcDataConnection.this.release();
                    }
                }
            };
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not get Connection from pool", e);
        }
    }

    private Connection singleUseConnection() {
        return this.singleUseConnectionSup.get();
    }

    public Connection getConnection() {
        return this.getConfig().isShared() ? this.pooledConnection() : this.singleUseConnection();
    }

    @Override
    public void destroy() {
        ConcurrentMemoizingSupplier<HikariDataSource> localPooledDataSourceSup = this.pooledDataSourceSup;
        if (localPooledDataSourceSup != null) {
            HikariDataSource dataSource = localPooledDataSourceSup.remembered();
            this.pooledDataSourceSup = null;
            if (dataSource != null) {
                try {
                    dataSource.close();
                }
                catch (Exception e) {
                    throw new HazelcastException("Could not close connection pool", e);
                }
            }
        }
        this.singleUseConnectionSup = null;
    }

    HikariDataSource pooledDataSource() {
        return this.pooledDataSourceSup.get();
    }
}

