/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.FragmentedMigrationAwareService;
import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.internal.partition.operation.UrgentPartitionRunnable;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractPartitionOperation
extends Operation
implements IdentifiedDataSerializable {
    AbstractPartitionOperation() {
    }

    final Collection<MigrationAwareService> getMigrationAwareServices() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        return nodeEngine.getServices(MigrationAwareService.class);
    }

    final Collection<Operation> createAllReplicationOperations(PartitionReplicationEvent event) {
        return this.createReplicationOperations(event, false);
    }

    final Collection<Operation> createNonFragmentedReplicationOperations(PartitionReplicationEvent event) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            return this.createReplicationOperations(event, true);
        }
        UrgentPartitionRunnable runnable = new UrgentPartitionRunnable(event.getPartitionId(), () -> this.createReplicationOperations(event, true));
        this.getNodeEngine().getOperationService().execute(runnable);
        try {
            return (Collection)runnable.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.sneakyThrow(ExceptionUtil.peel(e));
        }
    }

    private Collection<Operation> createReplicationOperations(PartitionReplicationEvent event, boolean nonFragmentedOnly) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(MigrationAwareService.class);
        for (ServiceInfo serviceInfo : services) {
            Operation op;
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            if (nonFragmentedOnly && service instanceof FragmentedMigrationAwareService || (op = service.prepareReplicationOperation(event)) == null) continue;
            op.setServiceName(serviceInfo.getName());
            operations.add(op);
        }
        return operations;
    }

    @Nonnull
    final Collection<ChunkSupplier> collectChunkSuppliers(PartitionReplicationEvent event, Collection<String> serviceNames, ServiceNamespace namespace) {
        ILogger logger = this.getLogger();
        logger.fine("Collecting chunk suppliers...");
        Collection<ChunkSupplier> chunkSuppliers = Collections.emptyList();
        NodeEngine nodeEngine = this.getNodeEngine();
        for (String serviceName : serviceNames) {
            Object service = nodeEngine.getService(serviceName);
            if (!(service instanceof ChunkedMigrationAwareService)) continue;
            chunkSuppliers = this.collectChunkSuppliers(event, namespace, ThreadUtil.isRunningOnPartitionThread(), chunkSuppliers, (ChunkedMigrationAwareService)service);
            if (!logger.isFineEnabled()) continue;
            logger.fine(String.format("Created chunk supplier:[%s, partitionId:%d]", namespace, event.getPartitionId()));
        }
        return chunkSuppliers;
    }

    @Nonnull
    final Collection<ChunkSupplier> collectChunkSuppliers(PartitionReplicationEvent event, ServiceNamespace ns) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for chunked migrations enabled services!";
        ILogger logger = this.getLogger();
        logger.fine("Collecting chunk chunk suppliers...");
        Collection<ChunkSupplier> chunkSuppliers = Collections.emptyList();
        NodeEngine nodeEngine = this.getNodeEngine();
        Collection<ChunkedMigrationAwareService> services = nodeEngine.getServices(ChunkedMigrationAwareService.class);
        for (ChunkedMigrationAwareService service : services) {
            if (!service.isKnownServiceNamespace(ns)) continue;
            chunkSuppliers = this.collectChunkSuppliers(event, ns, ThreadUtil.isRunningOnPartitionThread(), chunkSuppliers, service);
            if (!logger.isFineEnabled()) continue;
            logger.fine(String.format("Created chunk supplier:[%s, partitionId:%d]", ns, event.getPartitionId()));
        }
        return chunkSuppliers;
    }

    private Collection<ChunkSupplier> collectChunkSuppliers(PartitionReplicationEvent event, ServiceNamespace ns, boolean currentThreadIsPartitionThread, Collection<ChunkSupplier> chunkSuppliers, ChunkedMigrationAwareService service) {
        ChunkSupplier supplier;
        if (currentThreadIsPartitionThread ^ (service instanceof OffloadedReplicationPreparation && ((OffloadedReplicationPreparation)((Object)service)).shouldOffload())) {
            return this.prepareAndAppendNewChunkSupplier(event, ns, service, chunkSuppliers);
        }
        if (currentThreadIsPartitionThread) {
            ChunkSupplier supplier2 = service.newChunkSupplier(event, Collections.singleton(ns));
            return this.appendNewElement(chunkSuppliers, supplier2);
        }
        UrgentPartitionRunnable partitionThreadRunnable = new UrgentPartitionRunnable(event.getPartitionId(), () -> service.newChunkSupplier(event, Collections.singleton(ns)));
        this.getNodeEngine().getOperationService().execute(partitionThreadRunnable);
        try {
            supplier = (ChunkSupplier)partitionThreadRunnable.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.sneakyThrow(ExceptionUtil.peel(e));
        }
        return this.appendNewElement(chunkSuppliers, supplier);
    }

    final Collection<Operation> createFragmentReplicationOperations(PartitionReplicationEvent event, ServiceNamespace ns) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for fragmented services!";
        ThreadUtil.assertRunningOnPartitionThread();
        Collection<Operation> operations = Collections.emptySet();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(FragmentedMigrationAwareService.class);
        for (ServiceInfo serviceInfo : services) {
            FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)serviceInfo.getService();
            if (!service.isKnownServiceNamespace(ns)) continue;
            operations = this.prepareAndAppendReplicationOperation(event, ns, service, serviceInfo.getName(), operations);
        }
        return operations;
    }

    final Collection<Operation> createFragmentReplicationOperationsOffload(PartitionReplicationEvent event, ServiceNamespace ns, Collection<String> serviceNames) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for fragmented services!";
        Collection<Operation> operations = Collections.emptySet();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        for (String serviceName : serviceNames) {
            FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)nodeEngine.getService(serviceName);
            assert (service.isKnownServiceNamespace(ns)) : ns + " should be known by " + service;
            operations = this.collectReplicationOperations(event, ns, ThreadUtil.isRunningOnPartitionThread(), operations, serviceName, service);
        }
        return operations;
    }

    final Collection<Operation> createFragmentReplicationOperationsOffload(PartitionReplicationEvent event, ServiceNamespace ns) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for fragmented services!";
        Collection<Operation> operations = Collections.emptySet();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(FragmentedMigrationAwareService.class);
        for (ServiceInfo serviceInfo : services) {
            FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)serviceInfo.getService();
            if (!service.isKnownServiceNamespace(ns)) continue;
            operations = this.collectReplicationOperations(event, ns, ThreadUtil.isRunningOnPartitionThread(), operations, serviceInfo.getName(), service);
        }
        return operations;
    }

    @Nullable
    private Collection<Operation> collectReplicationOperations(PartitionReplicationEvent event, ServiceNamespace ns, boolean currentThreadIsPartitionThread, Collection<Operation> operations, String serviceName, FragmentedMigrationAwareService service) {
        Operation op;
        if (currentThreadIsPartitionThread ^ (service instanceof OffloadedReplicationPreparation && ((OffloadedReplicationPreparation)((Object)service)).shouldOffload())) {
            return this.prepareAndAppendReplicationOperation(event, ns, service, serviceName, operations);
        }
        if (currentThreadIsPartitionThread) {
            Operation op2 = this.prepareReplicationOperation(event, ns, service, serviceName);
            return this.appendNewElement(operations, op2);
        }
        UrgentPartitionRunnable partitionThreadRunnable = new UrgentPartitionRunnable(event.getPartitionId(), () -> this.prepareReplicationOperation(event, ns, service, serviceName));
        this.getNodeEngine().getOperationService().execute(partitionThreadRunnable);
        try {
            op = (Operation)partitionThreadRunnable.future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.sneakyThrow(ExceptionUtil.peel(e));
        }
        return this.appendNewElement(operations, op);
    }

    private Collection<ChunkSupplier> prepareAndAppendNewChunkSupplier(PartitionReplicationEvent event, ServiceNamespace ns, ChunkedMigrationAwareService service, Collection<ChunkSupplier> chunkSuppliers) {
        ChunkSupplier supplier = service.newChunkSupplier(event, Collections.singleton(ns));
        if (supplier == null) {
            return chunkSuppliers;
        }
        if (CollectionUtil.isEmpty(chunkSuppliers)) {
            chunkSuppliers = this.newSetOf(chunkSuppliers);
        }
        chunkSuppliers.add(supplier);
        return chunkSuppliers;
    }

    private <T> Collection<T> appendNewElement(Collection<T> previous, T newElement) {
        if (newElement == null) {
            return previous;
        }
        if (CollectionUtil.isEmpty(previous)) {
            previous = this.newSetOf(previous);
        }
        previous.add(newElement);
        return previous;
    }

    private Operation prepareReplicationOperation(PartitionReplicationEvent event, ServiceNamespace ns, FragmentedMigrationAwareService service, String serviceName) {
        Operation op = service.prepareReplicationOperation(event, Collections.singleton(ns));
        if (op == null) {
            return null;
        }
        op.setServiceName(serviceName);
        return op;
    }

    private Collection<Operation> prepareAndAppendReplicationOperation(PartitionReplicationEvent event, ServiceNamespace ns, FragmentedMigrationAwareService service, String serviceName, Collection<Operation> operations) {
        Operation op = service.prepareReplicationOperation(event, Collections.singleton(ns));
        if (op == null) {
            return operations;
        }
        op.setServiceName(serviceName);
        if (CollectionUtil.isEmpty(operations)) {
            operations = this.newSetOf(operations);
        }
        operations.add(op);
        return operations;
    }

    @Override
    public final int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    <T> Set<T> newSetOf(Collection<T> previous) {
        Set newSet = Collections.newSetFromMap(new ConcurrentHashMap());
        newSet.addAll(previous);
        return newSet;
    }
}

