/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.admin.rest.resources.AbstractAttributeBagResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

public class MonitoredAttributeBagResource
extends AbstractAttributeBagResource {
    public static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(MonitoredAttributeBagResource.class);

    @Override
    public String getDescriptionName() {
        return "monitored-attribute";
    }

    @Override
    public String getPropertiesName() {
        return "monitoredAttributes";
    }

    @Override
    public String getnodeElementName() {
        return "monitored-attributes";
    }

    @Override
    public List<Map<String, String>> getAllAttributes() {
        ArrayList<Map<String, String>> attributes = new ArrayList<Map<String, String>>();
        for (Dom child : this.entity) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("attributeName", child.attribute("attribute-name"));
            entry.put("objectName", child.attribute("object-name"));
            String description = child.attribute("description");
            if (description != null) {
                entry.put("description", description);
            }
            attributes.add(entry);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excuteSetCommand(List<Map<String, String>> attributesToAdd, List<Map<String, String>> attributesToDelete) throws TransactionFailure {
        try {
            RestActionReporter reporter;
            HashMap<String, String> parameters;
            for (Map<String, String> attribute : attributesToAdd) {
                parameters = new HashMap<String, String>();
                parameters.put("addattribute", String.format("attributeName=%s objectName=%s description=%s", attribute.get("attributeName"), attribute.get("objectName"), attribute.get("description")));
                reporter = ResourceUtil.runCommand("set-jmx-monitoring-configuration", parameters, this.getSubject());
                if (!reporter.isFailure()) continue;
                throw new TransactionFailure(reporter.getMessage());
            }
            for (Map<String, String> attribute : attributesToDelete) {
                parameters = new HashMap();
                parameters.put("delattribute", String.format("attributeName=%s objectName=%s", attribute.get("attributeName"), attribute.get("objectName")));
                reporter = ResourceUtil.runCommand("set-jmx-monitoring-configuration", parameters, this.getSubject());
                if (!reporter.isFailure()) continue;
                throw new TransactionFailure(reporter.getMessage());
            }
        }
        finally {
            TranslatedConfigView.doSubstitution.set(true);
        }
    }

    @Override
    public boolean attributesAreEqual(Map<String, String> attribute1, Map<String, String> attribute2) {
        return attribute1.get("attributeName").equals(attribute2.get("attributeName")) && attribute1.get("objectName").equals(attribute2.get("objectName"));
    }
}

