/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.rest.streams;

import fish.payara.admin.rest.streams.StreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlStreamWriter
implements StreamWriter {
    private final String prefix;
    private final String postfix;
    private final OutputStream os;
    private final XMLStreamWriter writer;

    public XmlStreamWriter(OutputStream os, String prefix, String postfix) throws XMLStreamException {
        this.prefix = prefix;
        this.postfix = postfix;
        this.os = os;
        this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os, "UTF-8");
    }

    public XmlStreamWriter(OutputStream os) throws XMLStreamException {
        this(os, null, null);
    }

    @Override
    public String getPostfix() {
        return this.postfix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void writeStartDocument() throws XMLStreamException, IOException {
        if (this.prefix != null) {
            this.os.write(this.prefix.getBytes("UTF-8"));
        }
        this.writer.writeStartDocument();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException, IOException {
        this.writer.writeEndDocument();
        if (this.postfix != null) {
            this.os.write(this.postfix.getBytes("UTF-8"));
        }
    }

    @Override
    public void writeStartObject(String element) throws XMLStreamException {
        this.writer.writeStartElement(element);
    }

    @Override
    public void writeEndObject() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    @Override
    public void writeAttribute(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name.replaceAll("@", ""), value);
    }

    @Override
    public void writeAttribute(String name, Boolean value) throws XMLStreamException {
        this.writer.writeAttribute(name.replaceAll("@", ""), Boolean.toString(value));
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void writeStartArray(String element) throws Exception {
    }

    @Override
    public void writeEndArray() throws Exception {
    }
}

