/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite.metadata;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.metadata.Confidential;
import org.glassfish.admin.rest.composite.metadata.CreateOnly;
import org.glassfish.admin.rest.composite.metadata.Default;
import org.glassfish.admin.rest.composite.metadata.DefaultsGenerator;
import org.glassfish.admin.rest.composite.metadata.Immutable;
import org.glassfish.admin.rest.composite.metadata.ReadOnly;
import org.glassfish.admin.rest.utils.JsonUtil;
import org.jvnet.hk2.config.Attribute;

public class ParamMetadata {
    private String name;
    private Type type;
    private String help;
    private JsonValue defaultValue;
    private boolean readOnly = false;
    private boolean confidential = false;
    private boolean immutable = false;
    private boolean createOnly = false;
    private OptionsCapable context;

    public ParamMetadata() {
    }

    public ParamMetadata(OptionsCapable context, Type paramType, String name, Annotation[] annotations) {
        this.name = name;
        this.context = context;
        this.type = paramType;
        CompositeUtil instance = CompositeUtil.instance();
        this.help = instance.getHelpText(annotations);
        this.defaultValue = this.getDefaultValue(annotations);
        for (Annotation a : annotations) {
            if (a.annotationType().equals(ReadOnly.class)) {
                this.readOnly = true;
            }
            if (a.annotationType().equals(Confidential.class)) {
                this.confidential = true;
            }
            if (a.annotationType().equals(Immutable.class)) {
                this.immutable = true;
            }
            if (!a.annotationType().equals(CreateOnly.class)) continue;
            this.createOnly = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(JsonValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return "ParamMetadata{name=" + this.name + ", type=" + this.getTypeString() + ", help=" + this.help + "}";
    }

    public JsonObject toJson() throws JsonException {
        JsonObjectBuilder o = Json.createObjectBuilder();
        o.add("type", this.getTypeString());
        if (this.help != null) {
            o.add("help", this.help);
        }
        JsonValue defVal = this.defaultValue != null ? this.defaultValue : JsonObject.NULL;
        o.add("default", defVal);
        o.add("readOnly", this.readOnly);
        o.add("confidential", this.confidential);
        o.add("immutable", this.immutable);
        o.add("createOnly", this.createOnly);
        return o.build();
    }

    protected String getTypeString() {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.type;
            StringBuilder sb = new StringBuilder(((Class)pt.getRawType()).getSimpleName());
            sb.append("<");
            String sep = "";
            for (Type t : pt.getActualTypeArguments()) {
                sb.append(sep).append(((Class)t).getSimpleName());
                sep = ";";
            }
            return sb.append(">").toString();
        }
        return ((Class)this.type).getSimpleName();
    }

    private JsonValue getDefaultValue(Annotation[] annos) {
        Object defval = null;
        if (annos != null) {
            for (Annotation annotation : annos) {
                if (Default.class.isAssignableFrom(annotation.getClass())) {
                    try {
                        Default def = (Default)annotation;
                        Class<?> clazz = def.generator();
                        if (def.useContext()) {
                            defval = ((DefaultsGenerator)((Object)this.context)).getDefaultValue(this.name);
                            break;
                        }
                        if (clazz != null && clazz != Void.class) {
                            if (DefaultsGenerator.class.isAssignableFrom(clazz)) {
                                defval = ((DefaultsGenerator)clazz.newInstance()).getDefaultValue(this.name);
                                break;
                            }
                            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00004");
                            break;
                        }
                        defval = this.parseValue(def.value());
                        break;
                    }
                    catch (Exception ex) {
                        RestLogging.restLogger.log(Level.SEVERE, null, ex);
                        continue;
                    }
                }
                if (!Attribute.class.isAssignableFrom(annotation.getClass())) continue;
                Attribute attr = (Attribute)annotation;
                defval = attr.defaultValue();
                break;
            }
        }
        try {
            return JsonUtil.getJsonValue(defval);
        }
        catch (JsonException e) {
            return null;
        }
    }

    private Object parseValue(String value) {
        Class clazz = (Class)this.type;
        try {
            if (clazz.equals(String.class)) {
                return value;
            }
            if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
                return Boolean.valueOf(value);
            }
            if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                return new Integer(value);
            }
            if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                return new Long(value);
            }
            if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
                return new Double(value);
            }
            if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                return new Float(value);
            }
            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00005");
        }
        catch (NumberFormatException e) {
            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00006");
        }
        return null;
    }
}

