/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite.metadata;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.Suspended;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.composite.RestCollection;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.composite.metadata.ParamMetadata;
import org.glassfish.admin.rest.utils.Util;

public class RestMethodMetadata {
    private String httpMethod;
    private List<ParamMetadata> queryParameters = new ArrayList<ParamMetadata>();
    private Type requestPayload;
    private Type returnPayload;
    private boolean isCollection = false;
    private final String path;
    private String[] produces;
    private String[] consumes;
    private final OptionsCapable context;

    public RestMethodMetadata(OptionsCapable context, Method method, Annotation designator) {
        this.context = context;
        this.httpMethod = designator.getClass().getInterfaces()[0].getSimpleName();
        this.returnPayload = this.calculateReturnPayload(method);
        this.path = this.getPath(method);
        Consumes cann = this.getAnnotation(Consumes.class, method);
        Produces pann = this.getAnnotation(Produces.class, method);
        if (cann != null) {
            this.consumes = cann.value();
        }
        if (pann != null) {
            this.produces = pann.value();
        }
        this.processParameters(method);
    }

    private <T> T getAnnotation(Class<T> annoClass, Method method) {
        T annotation = method.getAnnotation(annoClass);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(annoClass);
        }
        return annotation;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public List<ParamMetadata> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(List<ParamMetadata> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Type getRequestPayload() {
        return this.requestPayload;
    }

    public void setRequestPayload(Type requestPayload) {
        this.requestPayload = requestPayload;
    }

    public Type getReturnPayload() {
        return this.returnPayload;
    }

    public void setReturnPayload(Type returnPayload) {
        this.returnPayload = returnPayload;
    }

    public boolean getIsCollection() {
        return this.isCollection;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public String toString() {
        try {
            return this.toJson().toString();
        }
        catch (JsonException ex) {
            return ex.getMessage();
        }
    }

    public JsonObject toJson() throws JsonException {
        JsonArrayBuilder array;
        JsonObjectBuilder o = Json.createObjectBuilder();
        if (this.path != null) {
            o.add("path", this.path);
        }
        JsonObjectBuilder queryParamJson = Json.createObjectBuilder();
        for (ParamMetadata pmd : this.queryParameters) {
            queryParamJson.add(pmd.getName(), (JsonValue)pmd.toJson());
        }
        if (this.consumes != null) {
            array = Json.createArrayBuilder();
            for (String type : this.consumes) {
                array.add(type);
            }
            o.add("accepts", array);
        }
        if (this.produces != null) {
            array = Json.createArrayBuilder();
            for (String type : this.produces) {
                array.add(type);
            }
            o.add("produces", array);
        }
        o.add("queryParams", queryParamJson);
        if (this.requestPayload != null) {
            JsonObjectBuilder requestProps = Json.createObjectBuilder();
            requestProps.add("isCollection", this.isCollection);
            requestProps.add("dataType", this.getTypeString(this.requestPayload));
            requestProps.add("properties", (JsonValue)this.getProperties(this.requestPayload));
            o.add("request", requestProps);
        }
        if (this.returnPayload != null) {
            JsonObjectBuilder returnProps = Json.createObjectBuilder();
            returnProps.add("isCollection", this.isCollection);
            returnProps.add("dataType", this.getTypeString(this.returnPayload));
            returnProps.add("properties", (JsonValue)this.getProperties(this.returnPayload));
            o.add("response", returnProps);
        }
        return o.build();
    }

    private Type calculateReturnPayload(Method method) {
        Type grt = method.getGenericReturnType();
        Class<?> value = method.getReturnType();
        if (ParameterizedType.class.isAssignableFrom(grt.getClass())) {
            ParameterizedType pt = (ParameterizedType)grt;
            if (RestCollection.class.isAssignableFrom((Class)pt.getRawType())) {
                this.isCollection = true;
                value = Util.getFirstGenericType(grt);
            } else if (RestModel.class.isAssignableFrom((Class)pt.getRawType())) {
                value = Util.getFirstGenericType(grt);
            }
        }
        return value;
    }

    private Type calculateParameterType(Type paramType) {
        Type type;
        if (Util.isGenericType(paramType)) {
            ParameterizedType pt = (ParameterizedType)((Object)paramType);
            Class<?> first = Util.getFirstGenericType(paramType);
            type = RestModel.class.isAssignableFrom(first) || RestCollection.class.isAssignableFrom(first) ? first : pt;
        } else {
            type = paramType;
        }
        return type;
    }

    private String getPath(Method method) {
        Path p = method.getAnnotation(Path.class);
        if (p != null) {
            return p.value();
        }
        return null;
    }

    private void processParameters(Method method) {
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnos = method.getParameterAnnotations();
        int paramCount = paramTypes.length;
        for (int i = 0; i < paramCount; ++i) {
            boolean processed = false;
            boolean isPathParam = false;
            Type paramType = paramTypes[i];
            for (Annotation annotation : paramAnnos[i]) {
                boolean bl = processed = annotation instanceof Suspended || annotation instanceof PathParam;
                if (!(annotation instanceof QueryParam)) continue;
                this.queryParameters.add(new ParamMetadata(this.context, paramType, ((QueryParam)annotation).value(), paramAnnos[i]));
                processed = true;
            }
            if (processed || isPathParam) continue;
            this.requestPayload = this.calculateParameterType(paramType);
        }
    }

    private JsonObject getProperties(Type type) throws JsonException {
        Class clazz;
        JsonObjectBuilder props = Json.createObjectBuilder();
        HashMap<CallSite, ParamMetadata> map = new HashMap<CallSite, ParamMetadata>();
        if (Util.isGenericType(type)) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        if (RestModel.class.isAssignableFrom(clazz) || RestCollection.class.isAssignableFrom(clazz)) {
            for (Method m : clazz.getMethods()) {
                String methodName = m.getName();
                if (!methodName.startsWith("get")) continue;
                String propertyName = methodName.substring(3, 4).toLowerCase(Locale.getDefault()) + methodName.substring(4);
                map.put((CallSite)((Object)propertyName), new ParamMetadata(this.context, m.getGenericReturnType(), propertyName, m.getAnnotations()));
            }
            for (Map.Entry entry : map.entrySet()) {
                props.add((String)entry.getKey(), (JsonValue)((ParamMetadata)entry.getValue()).toJson());
            }
        }
        return props.build();
    }

    protected String getTypeString(Type clazz) {
        StringBuilder sb = new StringBuilder();
        if (Util.isGenericType(clazz)) {
            ParameterizedType pt = (ParameterizedType)clazz;
            sb.append(((Class)pt.getRawType()).getSimpleName());
            Type[] typeArgs = pt.getActualTypeArguments();
            if (typeArgs != null && typeArgs.length >= 1) {
                String sep = "";
                sb.append("<");
                for (Type arg : typeArgs) {
                    sb.append(sep).append(((Class)arg).getSimpleName());
                    sep = ",";
                }
                sb.append(">");
            }
        } else {
            sb.append(((Class)clazz).getSimpleName());
        }
        return sb.toString();
    }
}

