/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite.metadata;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.composite.metadata.RestMethodMetadata;
import org.glassfish.admin.rest.utils.JsonUtil;

public class RestResourceMetadata {
    private MultivaluedHashMap<String, RestMethodMetadata> resourceMethods = new MultivaluedHashMap();
    private List<String> subResources = new ArrayList<String>();
    private final OptionsCapable context;

    public RestResourceMetadata(OptionsCapable context) {
        this.context = context;
        this.processClass();
    }

    public MultivaluedHashMap<String, RestMethodMetadata> getResourceMethods() {
        return this.resourceMethods;
    }

    public void setResourceMethods(MultivaluedHashMap<String, RestMethodMetadata> resourceMethods) {
        this.resourceMethods = resourceMethods;
    }

    public List<String> getSubResources() {
        return this.subResources;
    }

    public void setSubResources(List<String> subResources) {
        this.subResources = subResources;
    }

    private void processClass() {
        for (Method m : this.context.getClass().getMethods()) {
            Path path;
            Annotation designator = this.getMethodDesignator(m);
            if (designator != null) {
                String httpMethod = designator.annotationType().getSimpleName();
                RestMethodMetadata rmm = new RestMethodMetadata(this.context, m, designator);
                this.resourceMethods.add(httpMethod, rmm);
            }
            if ((path = m.getAnnotation(Path.class)) == null) continue;
            this.subResources.add(this.context.getUriInfo().getAbsolutePathBuilder().build(new Object[0]).toASCIIString() + "/" + path.value());
        }
        Collections.sort(this.subResources);
    }

    private Annotation getMethodDesignator(Method method) {
        Annotation a = method.getAnnotation(GET.class);
        if (a == null && (a = method.getAnnotation(POST.class)) == null && (a = method.getAnnotation(DELETE.class)) == null) {
            a = method.getAnnotation(OPTIONS.class);
        }
        return a;
    }

    public JsonObject toJson() throws JsonException {
        JsonObjectBuilder o = Json.createObjectBuilder();
        if (!this.resourceMethods.isEmpty()) {
            JsonObjectBuilder methods = Json.createObjectBuilder();
            for (Map.Entry entry : this.resourceMethods.entrySet()) {
                for (RestMethodMetadata rmm : entry.getValue()) {
                    methods.add((String)entry.getKey(), (JsonValue)rmm.toJson());
                }
            }
            o.add("resourceMethods", methods);
        }
        if (!this.subResources.isEmpty()) {
            o.add("subResources", JsonUtil.getJsonValue(this.subResources));
        }
        return o.build();
    }
}

