/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import fish.payara.admin.rest.streams.JsonStreamWriter;
import fish.payara.admin.rest.streams.StreamWriter;
import fish.payara.admin.rest.streams.XmlStreamWriter;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;

public abstract class AbstractStaxProvider<T>
extends BaseProvider<T> {
    public AbstractStaxProvider(Class desiredType, MediaType ... mediaType) {
        super(desiredType, mediaType);
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    protected abstract void writeContentToStream(T var1, StreamWriter var2) throws Exception;

    @Override
    public String getContent(T proxy) {
        throw new UnsupportedOperationException("Provides only streaming implementation");
    }

    @Override
    public void writeTo(T proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        StreamWriter writer = null;
        try {
            writer = "xml".equals(mediaType.getSubtype()) ? new XmlStreamWriter(entityStream) : new JsonStreamWriter(entityStream);
            this.writeContentToStream(proxy, writer);
            writer.close();
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00007", ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

